/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jbi;

import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBIRequestURL {
    private User _user;
    private Map<String, String> _params = new LinkedHashMap<String, String>();

    public JBIRequestURL() {
        this(null);
    }

    public JBIRequestURL(User user) {
        if (user != null) {
            this._user = user;
            this._params.put("userId", String.valueOf(this._user.getUserId()));
            this._params.put("timeZoneId", this._user.getTimeZone().getID());
        } else {
            this._params.put("userId", "0");
            this._params.put("timeZoneId", TimeZoneUtil.getDefault().getID());
        }
    }

    public void addParameterMap(Map<String, String[]> parameterMap) {
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (!Validator.isNotNull((String)key) || value == null || value.length <= 0 || !Validator.isNotNull((String)value[0])) continue;
            this._params.put(key, value[0]);
        }
    }

    public void setParameter(String name, boolean value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, double value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, float value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, int value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, long value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, short value) {
        this.setParameter(name, String.valueOf(value));
    }

    public void setParameter(String name, String value) {
        this._params.put(name, value);
    }

    public String getContent() throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(this.getURL());
        options.setParts(this._params);
        options.setPost(true);
        return HttpUtil.URLtoString((Http.Options)options);
    }

    protected abstract String getURL();
}

