/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletCategory
implements Serializable {
    private String _name;
    private Map<String, PortletCategory> _categories;
    private Set<String> _portletIds;

    public PortletCategory() {
        this("root");
    }

    public PortletCategory(String name) {
        this(name, new HashSet<String>());
    }

    public PortletCategory(String name, Set<String> portletIds) {
        this._name = name;
        this._categories = new HashMap<String, PortletCategory>();
        this._portletIds = portletIds;
    }

    public String getName() {
        return this._name;
    }

    public Collection<PortletCategory> getCategories() {
        return Collections.unmodifiableCollection(this._categories.values());
    }

    public void addCategory(PortletCategory portletCategory) {
        this._categories.put(portletCategory.getName(), portletCategory);
    }

    public PortletCategory getCategory(String name) {
        return this._categories.get(name);
    }

    public Set<String> getPortletIds() {
        return this._portletIds;
    }

    public void setPortletIds(Set<String> portletIds) {
        this._portletIds = portletIds;
    }

    public void merge(PortletCategory newPortletCategory) {
        this._merge(this, newPortletCategory);
    }

    public void separate(Set<String> portletIds) {
        for (PortletCategory category : this._categories.values()) {
            category.separate(portletIds);
        }
        Iterator<String> portletIdsItr = this._portletIds.iterator();
        while (portletIdsItr.hasNext()) {
            String portletId = portletIdsItr.next();
            if (!portletIds.contains(portletId)) continue;
            portletIdsItr.remove();
        }
    }

    private void _merge(PortletCategory portletCategory1, PortletCategory portletCategory2) {
        for (PortletCategory curCategory2 : portletCategory2.getCategories()) {
            PortletCategory curCategory1 = portletCategory1.getCategory(curCategory2.getName());
            if (curCategory1 != null) {
                this._merge(curCategory1, curCategory2);
                continue;
            }
            portletCategory1.addCategory(curCategory2);
        }
        Set<String> portletIds1 = portletCategory1.getPortletIds();
        Set<String> portletIds2 = portletCategory2.getPortletIds();
        portletIds1.addAll(portletIds2);
    }
}

