/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

public class DefaultScreenNameGenerator
implements ScreenNameGenerator {
    public String generate(long companyId, long userId, String emailAddress) throws Exception {
        String screenName = null;
        if (Validator.isNotNull((String)emailAddress)) {
            screenName = StringUtil.extractFirst((String)emailAddress, (String)"@").toLowerCase();
            if ((screenName = StringUtil.replace((String)screenName, (String[])new String[]{"/", "_"}, (String[])new String[]{".", "."})).equals("cyrus") || screenName.equals("postfix")) {
                screenName = screenName + "." + userId;
            }
        } else {
            screenName = String.valueOf(userId);
        }
        try {
            UserLocalServiceUtil.getUserByScreenName(companyId, screenName);
        }
        catch (NoSuchUserException nsue) {
            try {
                GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + screenName);
            }
            catch (NoSuchGroupException nsge) {
                return screenName;
            }
        }
        int i = 1;
        while (true) {
            String tempScreenName = screenName + "." + i;
            try {
                UserLocalServiceUtil.getUserByScreenName(companyId, tempScreenName);
            }
            catch (NoSuchUserException nsue) {
                try {
                    GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + tempScreenName);
                }
                catch (NoSuchGroupException nsge) {
                    screenName = tempScreenName;
                    break;
                }
            }
            ++i;
        }
        return screenName;
    }
}

