/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFactory {
    public static ServiceContext getInstance(String className, PortletRequest portletRequest) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        serviceContext.setCompanyId(themeDisplay.getCompanyId());
        serviceContext.setLanguageId(themeDisplay.getLanguageId());
        serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL(themeDisplay));
        serviceContext.setLayoutURL(PortalUtil.getLayoutURL(themeDisplay));
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setPlid(themeDisplay.getPlid());
        serviceContext.setPortalURL(PortalUtil.getPortalURL(portletRequest));
        serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
        serviceContext.setUserDisplayURL(themeDisplay.getUser().getDisplayURL(themeDisplay));
        serviceContext.setUserId(themeDisplay.getUserId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = portletRequest.getParameterValues(param);
            if (values == null || values.length <= 0) continue;
            if (values.length == 1) {
                attributes.put(param, (Serializable)((Object)values[0]));
                continue;
            }
            attributes.put(param, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        String cmd = ParamUtil.getString((PortletRequest)portletRequest, (String)"cmd");
        serviceContext.setCommand(cmd);
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(className), portletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        boolean addCommunityPermissions = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"addCommunityPermissions");
        boolean addGuestPermissions = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"addGuestPermissions");
        String[] communityPermissions = PortalUtil.getCommunityPermissions(portletRequest);
        String[] guestPermissions = PortalUtil.getGuestPermissions(portletRequest);
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setCommunityPermissions(communityPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        HttpServletRequest request = PortalUtil.getHttpServletRequest(portletRequest);
        String portletId = PortalUtil.getPortletId(portletRequest);
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(request, portletId);
        serviceContext.setPortletPreferencesIds(portletPreferencesIds);
        String[] tagsCategories = PortalUtil.getTagsCategories(portletRequest);
        String[] tagsEntries = PortalUtil.getTagsEntries(portletRequest);
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        return serviceContext;
    }
}

