/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class ServiceContextUtil {
    public static Object deserialize(JSONObject jsonObject) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(jsonObject.getLong("companyId"));
        serviceContext.setLayoutFullURL(jsonObject.getString("layoutFullURL"));
        serviceContext.setLayoutURL(jsonObject.getString("layoutURL"));
        serviceContext.setPathMain(jsonObject.getString("pathMain"));
        serviceContext.setPlid(jsonObject.getLong("plid"));
        serviceContext.setPortalURL(jsonObject.getString("portalURL"));
        serviceContext.setScopeGroupId(jsonObject.getLong("scopeGroupId"));
        serviceContext.setUserDisplayURL(jsonObject.getString("userDisplayURL"));
        String[] communityPermissions = StringUtil.split((String)jsonObject.getString("communityPermissions"));
        String[] guestPermissions = StringUtil.split((String)jsonObject.getString("guestPermissions"));
        serviceContext.setAddCommunityPermissions(jsonObject.getBoolean("addCommunityPermissions"));
        serviceContext.setAddGuestPermissions(jsonObject.getBoolean("addGuestPermissions"));
        serviceContext.setCommunityPermissions(communityPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        String[] tagsCategories = StringUtil.split((String)jsonObject.getString("tagsCategories"));
        String[] tagsEntries = StringUtil.split((String)jsonObject.getString("tagsEntries"));
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        return serviceContext;
    }

    public static Locale getLocale(ServiceContext serviceContext) {
        return LocaleUtil.fromLanguageId((String)serviceContext.getLanguageId());
    }

    public static PortletPreferences getPortletPreferences(ServiceContext serviceContext) throws SystemException {
        if (serviceContext == null) {
            return null;
        }
        PortletPreferencesIds portletPreferencesIds = serviceContext.getPortletPreferencesIds();
        if (portletPreferencesIds == null) {
            return null;
        }
        return PortletPreferencesLocalServiceUtil.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }
}

