/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util.comparator;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.messageboards.model.MBThread;
import java.util.Date;

public class ThreadLastPostDateComparator
extends OrderByComparator {
    public static String ORDER_BY_ASC = "lastPostDate ASC, threadId ASC";
    public static String ORDER_BY_DESC = "lastPostDate DESC, threadId DESC";
    public static String[] ORDER_BY_FIELDS = new String[]{"lastPostDate, threadId"};
    private boolean _asc;

    public ThreadLastPostDateComparator() {
        this(false);
    }

    public ThreadLastPostDateComparator(boolean asc) {
        this._asc = asc;
    }

    public int compare(Object obj1, Object obj2) {
        int value;
        MBThread thread1 = (MBThread)obj1;
        MBThread thread2 = (MBThread)obj2;
        Date lastPostDate1 = thread1.getLastPostDate();
        Date lastPostDate2 = thread2.getLastPostDate();
        boolean ignoreMilliseconds = false;
        DB db = DBFactoryUtil.getDB();
        if (!db.isSupportsDateMilliseconds()) {
            ignoreMilliseconds = true;
        }
        if ((value = DateUtil.compareTo((Date)lastPostDate1, (Date)lastPostDate2, (boolean)ignoreMilliseconds)) == 0) {
            if (thread1.getThreadId() < thread2.getThreadId()) {
                value = -1;
            } else if (thread1.getThreadId() > thread2.getThreadId()) {
                value = 1;
            }
        }
        if (this._asc) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._asc) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._asc;
    }
}

