/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.ContentFilter;
import com.efsol.friki.Renderer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.stringtree.factory.CachedStringFetcher;
import org.stringtree.factory.StringFetcher;
import org.stringtree.factory.memory.MapStringRepository;
import org.stringtree.template.TemplateEngine;
import org.stringtree.util.tract.Tract;

public class HTMLRenderer
implements Renderer {
    private TemplateEngine engine = new TemplateEngine('@');
    private ContentFilter filter;
    private StringFetcher templates;
    private String unknown;

    public HTMLRenderer(ContentFilter filter, StringFetcher templates, String unknown) {
        this.filter = filter;
        this.templates = new CachedStringFetcher(templates);
        this.unknown = unknown;
    }

    private String convert(String content) throws IOException {
        StringWriter out = new StringWriter();
        this.filter.filter(new StringReader(content), out);
        return out.toString();
    }

    private String splitTitle(String name) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                buf.append(' ');
                continue;
            }
            if (i > 0 && Character.isUpperCase(c)) {
                buf.append(' ');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private void putDefaultValues(Map map) {
        map.put("previous.version", "old/EmptyPage");
        map.put("page.name", "old/EmptyPage");
        map.put("last.edit", "never");
    }

    public void render(Tract page, String mode, Writer out, boolean isFiltered) throws IOException {
        String content = page.getContent();
        if (isFiltered) {
            content = this.convert(content);
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        this.putDefaultValues(tokens);
        tokens.putAll(page);
        tokens.put("CONTENT", content);
        tokens.put("TITLE", this.splitTitle((String)tokens.get("page.name")));
        String template = this.templates.get(mode);
        this.engine.expand(new StringReader(template), out, (StringFetcher)new MapStringRepository(tokens));
    }
}

