/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.regex;

import org.stringtree.factory.AbstractStringFetcher;
import org.stringtree.factory.StringFetcher;
import org.stringtree.regex.Matcher;
import org.stringtree.regex.Pattern;
import org.stringtree.util.IntegerNumberUtils;
import org.stringtree.util.NumericValidator;

public class MatcherStringFetcher
extends AbstractStringFetcher {
    private Matcher matcher;
    protected String prefix;
    private StringFetcher augment;

    public MatcherStringFetcher(Matcher matcher, String prefix, StringFetcher augment) {
        this.matcher = matcher;
        this.prefix = prefix;
        this.augment = augment;
    }

    public MatcherStringFetcher(Matcher matcher) {
        this(matcher, "&", null);
    }

    public MatcherStringFetcher(String pattern, String text) {
        this(Pattern.compile(pattern).matcher(text));
        this.matcher.find();
    }

    public String get(int group) {
        String ret = "";
        if (group <= this.matcher.groupCount()) {
            ret = this.matcher.group(group);
        }
        return ret;
    }

    public int count() {
        return this.matcher.groupCount();
    }

    public Object getObject(String key) {
        String ret = null;
        if (this.prefix.equals(key)) {
            ret = this.prefix;
        } else if ("0".equals(key)) {
            ret = this.matcher.group();
        } else if (NumericValidator.isValidNumber(key)) {
            int group = IntegerNumberUtils.intValue(key);
            ret = this.get(group);
        } else if (key.startsWith("~") && this.augment != null) {
            ret = this.augment.get(this.get(key.substring(1)));
        }
        return ret;
    }
}

