/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.tract;

import java.util.ArrayList;
import java.util.List;
import org.stringtree.factory.Fetcher;
import org.stringtree.juicer.formatter.Transformation;
import org.stringtree.juicer.string.IgnoreCommentLineStringFilter;
import org.stringtree.juicer.string.SplitLinesStringFilter;
import org.stringtree.juicer.string.SplitStringFilter;
import org.stringtree.juicer.string.StaticRegexReplaceStringFilter;
import org.stringtree.juicer.string.StringFilter;
import org.stringtree.juicer.string.StringPipeline;
import org.stringtree.juicer.string.StringSource;
import org.stringtree.juicer.string.StringStringSource;
import org.stringtree.juicer.tract.InitialisingTractPipeline;
import org.stringtree.juicer.tract.JoinTractFilter;
import org.stringtree.juicer.tract.TractFilter;
import org.stringtree.util.ClassUtils;

public class ExternalTractPipeline
extends InitialisingTractPipeline {
    public ExternalTractPipeline(StringSource spec, Fetcher context) {
        this.setList(this.getFilters(spec));
        this.init(context);
    }

    public ExternalTractPipeline(String spec, Fetcher context) {
        this(ExternalTractPipeline.createStringSource(spec), context);
    }

    public ExternalTractPipeline(StringSource spec) {
        this.setList(this.getFilters(spec));
    }

    public ExternalTractPipeline(String spec) {
        this(ExternalTractPipeline.createStringSource(spec));
    }

    private static StringSource createStringSource(String spec) {
        StringStringSource raw = new StringStringSource(spec);
        StringPipeline cooked = new StringPipeline(new StringFilter[]{new SplitLinesStringFilter(), new IgnoreCommentLineStringFilter(), new StaticRegexReplaceStringFilter("\\\\t", "\t"), new StaticRegexReplaceStringFilter("\\\\n", "\n"), new StaticRegexReplaceStringFilter("\\\\r", "\r")});
        cooked.connectSource(raw);
        return cooked;
    }

    private List getFilters(StringSource spec) {
        ArrayList<TractFilter> ret = new ArrayList<TractFilter>();
        if (spec != null) {
            String line = spec.nextString();
            while (line != null) {
                TractFilter filter = this.createFilter(line.trim());
                if (filter != null) {
                    ret.add(filter);
                }
                line = spec.nextString();
            }
            ret.add(new JoinTractFilter());
        }
        return ret;
    }

    private TractFilter createFilter(String line) {
        SplitStringFilter split = new SplitStringFilter();
        split.connectSource(new StringStringSource(line));
        split.setSeparator(' ');
        String filterClass = split.nextString();
        split.setSeparator('\u0000');
        String tail = split.nextString();
        TractFilter ret = (TractFilter)ClassUtils.createObject(filterClass, System.out);
        if (ret != null && ret instanceof Transformation) {
            ((Transformation)ret).init(tail);
        }
        return ret;
    }
}

