/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.tract;

import org.stringtree.factory.Fetcher;
import org.stringtree.juicer.Initialisable;
import org.stringtree.juicer.JuicerLockHelper;
import org.stringtree.juicer.string.PassStringFilter;
import org.stringtree.juicer.string.StringFilter;
import org.stringtree.juicer.string.StringStringSource;
import org.stringtree.juicer.tract.BasicTractFilter;
import org.stringtree.util.tract.Tract;

public class StringFilterTractFilter
extends BasicTractFilter
implements Initialisable {
    protected StringFilter filter;
    protected boolean polite;

    public StringFilterTractFilter(StringFilter filter, boolean polite) {
        this.setFilter(filter);
        this.setPolite(polite);
    }

    public StringFilterTractFilter(StringFilter filter) {
        this(filter, true);
    }

    public StringFilterTractFilter() {
        this(PassStringFilter.it, true);
    }

    public void setFilter(StringFilter filter) {
        this.filter = filter;
    }

    public void setPolite(boolean polite) {
        this.polite = polite;
    }

    public Tract filter(Tract input) {
        this.filter.connectSource(new StringStringSource(input.getContent()));
        if (!this.polite || !JuicerLockHelper.isLocked(input)) {
            input.setContent(this.filter.nextString());
        }
        return input;
    }

    public void init(Fetcher context) {
        if (this.filter instanceof Initialisable) {
            ((Initialisable)((Object)this.filter)).init(context);
        }
    }
}

