/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.template;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.stringtree.factory.StringFetcher;
import org.stringtree.template.AnnotatedCharacter;
import org.stringtree.template.AnnotatedCharacterFactory;
import org.stringtree.template.TemplateEnginePolicy;
import org.stringtree.util.tract.Tract;

public class TemplateEngine {
    protected TemplateEnginePolicy policy;
    protected AnnotatedCharacterFactory cf;

    public TemplateEngine(TemplateEnginePolicy policy) {
        this.policy = policy;
        this.cf = new AnnotatedCharacterFactory(policy.getEscape());
    }

    public TemplateEngine(char tagchar) {
        this(new TemplateEnginePolicy(tagchar));
    }

    private boolean isTag(AnnotatedCharacter c, char tagchar) {
        return c.c == tagchar && !c.escaped;
    }

    private String readTag(AnnotatedCharacter c, Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        char tagchar = this.policy.getEnd();
        this.cf.read(c, in);
        while (c.i != -1 && !this.isTag(c, tagchar)) {
            buf.append(c.c);
            this.cf.read(c, in);
        }
        return buf.toString();
    }

    public void expand(Reader in, Writer out, StringFetcher context) throws IOException {
        char tagchar = this.policy.getStart();
        AnnotatedCharacter c = new AnnotatedCharacter();
        this.cf.read(c, in);
        while (c.i != -1) {
            if (this.isTag(c, tagchar)) {
                String tag = this.readTag(c, in);
                if ("".equals(tag)) {
                    out.write(this.policy.getEnd());
                } else {
                    String result = context.get(tag);
                    out.write(result);
                }
            } else {
                out.write(c.c);
            }
            this.cf.read(c, in);
        }
    }

    public String expand(String template, StringFetcher context) {
        StringWriter out = new StringWriter();
        try {
            this.expand(new StringReader(template), (Writer)out, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public void expand(Tract template, Writer out, StringFetcher context) throws IOException {
        this.expand(new StringReader(template.getContent()), out, context);
    }

    public String expand(Tract template, StringFetcher context) {
        return this.expand(template.getContent(), context);
    }
}

