/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import org.stringtree.factory.AbstractStringFetcher;
import org.stringtree.juicer.string.RegexSplitStringFilter;
import org.stringtree.juicer.string.StringStringSource;
import org.stringtree.regex.Pattern;
import org.stringtree.util.StringUtils;

public class TableRow
extends AbstractStringFetcher {
    private static final Pattern bar = Pattern.compile("(?<!\\\\)\\|");

    private void renderCell(StringBuffer buf, String cell, int blanks) {
        buf.append("<td");
        if (blanks > 0) {
            buf.append(" colspan='");
            buf.append(blanks + 1);
            buf.append("'");
        }
        buf.append(">");
        buf.append(cell);
        buf.append("</td>");
    }

    public void renderRow(String row, StringBuffer buf) {
        if ((row = row.trim()).endsWith("|")) {
            row = row.substring(0, row.length() - 1);
        }
        String[] cells = bar.split(row);
        int blanks = 0;
        String lastCell = null;
        buf.append("\n<tr>");
        for (int i = 0; i < cells.length; ++i) {
            String cell = cells[i];
            if (StringUtils.isBlank(cell)) {
                ++blanks;
                continue;
            }
            if (lastCell != null) {
                this.renderCell(buf, lastCell, blanks);
                blanks = 0;
            }
            lastCell = cell;
        }
        if (lastCell != null) {
            this.renderCell(buf, lastCell, blanks);
        }
        buf.append("</tr>");
    }

    public Object getObject(String content) {
        StringBuffer buf = new StringBuffer();
        String prev = null;
        RegexSplitStringFilter rows = new RegexSplitStringFilter("(^|\n)\\|");
        rows.connectSource(new StringStringSource(content));
        String row = rows.nextString();
        while (row != null) {
            if (row.length() == 0) {
                prev = "|";
            } else {
                if (prev != null) {
                    row = prev + row;
                }
                this.renderRow(row, buf);
            }
            row = rows.nextString();
        }
        String ret = buf.toString();
        return ret;
    }
}

