/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.io.Serializable;

public class JavaParameter
implements Serializable {
    public static final JavaParameter[] EMPTY_ARRAY = new JavaParameter[0];
    private String name;
    private Type type;
    private JavaMethod parentMethod;
    private boolean varArgs;
    private String genericsName = "";

    public JavaParameter(Type type, String name) {
        this(type, name, false);
    }

    public JavaParameter(Type type, String name, boolean varArgs) {
        this.name = name;
        this.type = type;
        this.varArgs = varArgs;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        JavaParameter p = (JavaParameter)obj;
        return this.getType().equals(p.getType());
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public JavaMethod getParentMethod() {
        return this.parentMethod;
    }

    public void setParentMethod(JavaMethod parentMethod) {
        this.parentMethod = parentMethod;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public String toString() {
        return this.getResolvedValue() + " " + this.name;
    }

    public String getResolvedValue() {
        return this.type.getResolvedValue(this.getParentMethod().getTypeParameters());
    }

    public String getResolvedGenericValue() {
        return this.type.getResolvedGenericValue(this.getParentMethod().getTypeParameters());
    }

    public String getGenericsName() {
        return this.genericsName;
    }

    public void setGenericsName(String genericsName) {
        this.genericsName = genericsName;
    }
}

