/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.jspwiki.filters;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.filters.FilterException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.wikiwizard.jspwiki.filters.CreoleToJSPWikiTranslator;

public class CreoleFilter
extends BasicPageFilter {
    private static final Logger log = Logger.getLogger((Class)CreoleFilter.class);

    public void initialize(WikiEngine engine, Properties props) throws FilterException {
        log.info((Object)("CreoleFilter " + CreoleToJSPWikiTranslator.VAR_VERSION + " initialized. We now speak a common language!"));
    }

    public String preSave(WikiContext wikiContext, String content) throws FilterException {
        try {
            String username = wikiContext.getCurrentUser().getName();
            Properties prop = wikiContext.getEngine().getWikiProperties();
            return new CreoleToJSPWikiTranslator().translateSignature(prop, content, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String preTranslate(WikiContext wikiContext, String content) throws FilterException {
        try {
            Properties prop = wikiContext.getEngine().getWikiProperties();
            String jspwiki_markup = new CreoleToJSPWikiTranslator().translate(prop, content);
            return jspwiki_markup;
        }
        catch (Exception e) {
            e.printStackTrace();
            return content + "\n \n %%error \n" + "[CreoleFilterError]: This page was not translated by the CreoleFilter due to " + "the following error: " + e.getMessage() + "\n \n" + "%%\n \n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stackTraceToString(Throwable e) {
        String retValue = null;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            retValue = sw.toString();
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException ignore) {}
        }
        return retValue;
    }
}

