/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.bridges.mvc.ActionCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCommandCache {
    public static final String ACTION_PACKAGE_NAME = "action.package.prefix";
    public static final ActionCommand EMPTY = new ActionCommand(){

        public boolean processCommand(PortletRequest portletRequest, PortletResponse portletResponse) {
            return false;
        }
    };
    private static final String _ACTION_COMMAND_POSTFIX = "ActionCommand";
    private static final Log _log = LogFactoryUtil.getLog(ActionCommandCache.class);
    private Map<String, ActionCommand> _actionCommandCache = new ConcurrentHashMap<String, ActionCommand>();
    private Map<String, List<ActionCommand>> _actionCommandChainCache = new ConcurrentHashMap<String, List<ActionCommand>>();
    private String _packagePrefix;

    public ActionCommandCache(String packagePrefix) {
        if (!packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        this._packagePrefix = packagePrefix;
    }

    public ActionCommand getActionCommand(String actionCommandName) {
        String className = null;
        try {
            ActionCommand actionCommand = this._actionCommandCache.get(actionCommandName);
            if (actionCommand == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this._packagePrefix);
                sb.append(Character.toUpperCase(actionCommandName.charAt(0)));
                sb.append(actionCommandName.substring(1, actionCommandName.length()));
                sb.append(_ACTION_COMMAND_POSTFIX);
                className = sb.toString();
                actionCommand = (ActionCommand)Class.forName(className).newInstance();
                this._actionCommandCache.put(actionCommandName, actionCommand);
            }
            return actionCommand;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to instantiate ActionCommand " + className));
            }
            this._actionCommandCache.put(actionCommandName, EMPTY);
            return EMPTY;
        }
    }

    public List<ActionCommand> getActionCommandChain(String actionCommandChain) {
        List<ActionCommand> actionCommands = this._actionCommandChainCache.get(actionCommandChain);
        if (actionCommands == null) {
            actionCommands = new ArrayList<ActionCommand>();
            int nextSeparator = actionCommandChain.indexOf(",");
            int currentIndex = 0;
            while (currentIndex < actionCommandChain.length()) {
                String parsedName = actionCommandChain.substring(currentIndex, nextSeparator);
                ActionCommand actionCommand = this.getActionCommand(parsedName);
                if (actionCommand != EMPTY) {
                    actionCommands.add(actionCommand);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to find ActionCommand " + actionCommandChain));
                }
                if ((nextSeparator = actionCommandChain.indexOf(",", currentIndex = nextSeparator + 1)) != -1) continue;
                break;
            }
            this._actionCommandChainCache.put(actionCommandChain, actionCommands);
        }
        return actionCommands;
    }

    public boolean isEmpty() {
        return this._actionCommandCache.isEmpty();
    }
}

