/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.ruby;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.bridges.bsf.BaseBSFPortlet;
import org.apache.bsf.BSFException;
import org.jruby.RubyException;
import org.jruby.exceptions.RaiseException;

public class RubyPortlet
extends BaseBSFPortlet {
    private static final String _FILE_PARAM = "rubyFile";
    private static final String _SCRIPTING_ENGINE_CLASS_NAME = "org.jruby.javasupport.bsf.JRubyEngine";
    private static final String _SCRIPTING_ENGINE_EXTENSION = "rb";
    private static final String _SCRIPTING_ENGINE_LANGUAGE = "ruby";
    private static Log _log = LogFactoryUtil.getLog(RubyPortlet.class);

    protected String getFileParam() {
        return _FILE_PARAM;
    }

    protected String getScriptingEngineClassName() {
        return _SCRIPTING_ENGINE_CLASS_NAME;
    }

    protected String getScriptingEngineExtension() {
        return _SCRIPTING_ENGINE_EXTENSION;
    }

    protected String getScriptingEngineLanguage() {
        return _SCRIPTING_ENGINE_LANGUAGE;
    }

    protected void logBSFException(BSFException bsfe, String path) {
        String message = "The script at " + path + " or one of the global files has errors.";
        Throwable t = bsfe.getTargetException();
        if (t instanceof RaiseException) {
            RubyException re = ((RaiseException)t).getException();
            message = message + re.message + " (" + re.getMetaClass().toString() + ")";
            _log.error((Object)message);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)t, t);
            }
        } else {
            _log.error((Object)message, t);
        }
    }
}

