/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.wai;

import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAIFriendlyURLMapper
implements FriendlyURLMapper {
    private static final boolean _CHECK_MAPPING_WITH_PREFIX = true;
    private static final String _MAPPING = "waiapp";
    private static final String[] _BINARY_EXTENSIONS = new String[]{".css", ".doc", ".gif", ".jpeg", ".jpg", ".js", ".odp", ".png", ".ppt", ".tgz", ".xls", ".zip"};

    public String buildPath(LiferayPortletURL portletURL) {
        String portletId;
        String prefix = portletId = portletURL.getPortletId();
        int pos = portletId.indexOf("_WAR_");
        if (pos != -1) {
            prefix = portletId.substring(0, pos);
        }
        String appUrl = GetterUtil.getString((String)portletURL.getParameter("appURL"));
        portletURL.addParameterIncludedInPath("p_p_id");
        return "/waiapp/" + prefix + "/" + appUrl;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public boolean isCheckMappingWithPrefix() {
        return true;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        int x = friendlyURLPath.indexOf(_MAPPING);
        int y = friendlyURLPath.indexOf("/", x + _MAPPING.length() + 1);
        if (x == -1) {
            return;
        }
        String prefix = friendlyURLPath.substring(x + _MAPPING.length() + 1, y);
        String portletId = prefix + "_WAR_" + prefix;
        params.put("p_p_id", new String[]{portletId});
        params.put("p_p_lifecycle", new String[]{"0"});
        if (this.hasBinaryExtension(friendlyURLPath)) {
            params.put("p_p_state", new String[]{LiferayWindowState.EXCLUSIVE.toString()});
        } else {
            params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        }
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        String path = friendlyURLPath.substring(y);
        params.put(namespace + "appURL", new String[]{path});
    }

    protected boolean hasBinaryExtension(String friendlyURLPath) {
        for (int i = 0; i < _BINARY_EXTENSIONS.length; ++i) {
            String binaryExtension = _BINARY_EXTENSIONS[i];
            if (!friendlyURLPath.endsWith(binaryExtension)) continue;
            return true;
        }
        return false;
    }
}

