/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.wai;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAIHttpServletRequest
extends HttpServletRequestWrapper {
    private String _contextPath;
    private String _pathInfo;
    private String _queryString;
    private Map<String, String[]> _params;

    public WAIHttpServletRequest(HttpServletRequest request, String contextPath, String pathInfo, String queryString, Map<String, String[]> params) {
        super(request);
        this._contextPath = contextPath;
        this._pathInfo = pathInfo;
        this._queryString = queryString;
        this._params = params;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getPathInfo() {
        return super.getPathInfo();
    }

    public String getQueryString() {
        return this._queryString;
    }

    public String getRequestURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContextPath());
        sb.append(this._pathInfo);
        if (this.getQueryString().trim().length() > 0) {
            sb.append("?");
            sb.append(this.getQueryString());
        }
        return sb.toString();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public Map<String, String[]> getParameterMap() {
        return this._params;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this._params.keySet());
    }

    public String getParameter(String key) {
        String[] values = this._params.get(key);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String key) {
        return this._params.get(key);
    }
}

