/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.wai;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.util.bridges.wai.WAIHttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WAIPortlet
extends GenericPortlet {
    public static final String CONNECTOR_IFRAME = "iframe";
    public static final String CONNECTOR_INCLUDE = "include";
    private static final String _MAPPING = "waiapp";
    private static final String _APP_URL = "appURL";
    private static final String _JSP_DIR = "/WEB-INF/jsp/liferay/wai";
    private static final String _JSP_IFRAME = "/WEB-INF/jsp/liferay/wai/iframe.jsp";
    private static final String _JSP_NORMAL_WINDOW_STATE = "/WEB-INF/jsp/liferay/wai/normal_window_state.jsp";
    private static Log _log = LogFactoryUtil.getLog(WAIPortlet.class);
    private String _connector;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this._connector = GetterUtil.getString((String)portletConfig.getInitParameter("wai.connector"), (String)CONNECTOR_IFRAME);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (this._connector.equals(CONNECTOR_IFRAME) || renderRequest.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            this.invokeApplication(renderRequest, renderResponse);
        } else {
            this.renderNormalWindowState(renderRequest, renderResponse);
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String path) throws PortletException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(path);
        try {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        catch (ServletException se) {
            throw new PortletException((Throwable)se);
        }
    }

    protected void invokeApplication(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        HttpServletRequest request = (HttpServletRequest)renderRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        HttpServletResponse response = (HttpServletResponse)renderRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletResponse");
        String portletName = this.getPortletConfig().getPortletName();
        String friendlyURL = (String)request.getAttribute("FRIENDLY_URL");
        int pos = friendlyURL.indexOf(_MAPPING);
        StringBuilder contextPath = new StringBuilder();
        contextPath.append(friendlyURL.substring(0, pos + _MAPPING.length()));
        contextPath.append("/");
        contextPath.append(portletName);
        pos = friendlyURL.indexOf(portletName);
        String pathInfo = friendlyURL.substring(pos + portletName.length());
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        params.remove(_APP_URL);
        String queryString = HttpUtil.parameterMapToString(params, (boolean)false);
        String appUrl = ParamUtil.getString((PortletRequest)renderRequest, (String)_APP_URL, (String)"/");
        if (this._connector.equals(CONNECTOR_IFRAME)) {
            request.setAttribute(_APP_URL, (Object)(renderRequest.getContextPath() + appUrl));
            String iframeExtraHeight = GetterUtil.getString((String)this.getPortletConfig().getInitParameter("wai.connector.iframe.height.extra"), (String)"40");
            renderRequest.setAttribute("wai.connector.iframe.height.extra", (Object)iframeExtraHeight);
            this.forward(request, response, _JSP_IFRAME);
        } else if (this._connector.equals(CONNECTOR_INCLUDE)) {
            WAIHttpServletRequest waiRequest = new WAIHttpServletRequest(request, contextPath.toString(), pathInfo, queryString, params);
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(appUrl);
            try {
                requestDispatcher.forward((ServletRequest)waiRequest, (ServletResponse)response);
            }
            catch (ServletException se) {
                throw new PortletException((Throwable)se);
            }
        }
    }

    protected void renderNormalWindowState(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        HttpServletRequest request = (HttpServletRequest)renderRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        HttpServletResponse response = (HttpServletResponse)renderRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletResponse");
        PortletURL renderURL = renderResponse.createRenderURL();
        renderURL.setWindowState(WindowState.MAXIMIZED);
        renderRequest.setAttribute("renderURL", (Object)renderURL.toString());
        this.forward(request, response, _JSP_NORMAL_WINDOW_STATE);
    }
}

