/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpUtil;

public class Jdk14RegexpMatcher
implements RegexpMatcher {
    private String pattern;

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected Pattern getCompiledPattern(int n) throws BuildException {
        int n2 = this.getCompilerOptions(n);
        try {
            Pattern pattern = Pattern.compile(this.pattern, n2);
            return pattern;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new BuildException((Throwable)patternSyntaxException);
        }
    }

    public boolean matches(String string) throws BuildException {
        return this.matches(string, 0);
    }

    public boolean matches(String string, int n) throws BuildException {
        try {
            Pattern pattern = this.getCompiledPattern(n);
            return pattern.matcher(string).find();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    public Vector getGroups(String string) throws BuildException {
        return this.getGroups(string, 0);
    }

    public Vector getGroups(String string, int n) throws BuildException {
        Pattern pattern = this.getCompiledPattern(n);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = matcher.groupCount();
        for (int i = 0; i <= n2; ++i) {
            String string2 = matcher.group(i);
            if (string2 == null) {
                string2 = "";
            }
            vector.addElement(string2);
        }
        return vector;
    }

    protected int getCompilerOptions(int n) {
        int n2 = 1;
        if (RegexpUtil.hasFlag((int)n, (int)256)) {
            n2 |= 2;
        }
        if (RegexpUtil.hasFlag((int)n, (int)4096)) {
            n2 |= 8;
        }
        if (RegexpUtil.hasFlag((int)n, (int)65536)) {
            n2 |= 0x20;
        }
        return n2;
    }
}

