/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.InputField;

public class ValidatedTextInput
extends InputField {
    private String regex;
    private Pattern pattern;

    public void setValue(String string) {
        this.setInputResult(string);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String string) {
        this.regex = string;
        try {
            this.pattern = Pattern.compile(string);
        }
        catch (BuildException buildException) {
            throw new InputException("Invalid regex in Validated text input");
        }
    }

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        try {
            if (this.getInputResult() == null) {
                return false;
            }
            String string = this.getInputResult();
            Matcher matcher = this.pattern.matcher(string);
            boolean bl = matcher.matches();
            return bl;
        }
        catch (Throwable throwable) {
            installerContext.log(throwable);
            return false;
        }
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Validated:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Validated:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Validated:defaultValue must be set");
            return false;
        }
        if (this.getRegex() == null) {
            System.out.println("Validated:regex must be set");
            return false;
        }
        return true;
    }
}

