/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.swing.AICheckBox;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class TargetInputRenderer
extends SwingOutputFieldRenderer {
    protected TargetInput outputField;
    protected AILabel fieldLabel = new AILabel();
    protected AICheckBox targetCheckBox = new AICheckBox();

    public void initComponent(JPanel jPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.outputField = (TargetInput)outputField;
    }

    public void updateInputField() {
        String string = this.outputField.getTarget();
        int n = this.outputField.getIdx();
        boolean bl = this.targetCheckBox.isSelected();
        if (bl && !this.ctx.getCurrentPage().getTargets().contains(string)) {
            this.ctx.getCurrentPage().addTarget(n, string);
        } else if (!bl && this.ctx.getCurrentPage().isTarget(string)) {
            this.ctx.getCurrentPage().removeTarget(n, string);
        }
    }

    public void updateDefaultValue() {
        if (!this.outputField.isEditted()) {
            this.targetCheckBox.setSelected(InputField.isTrue(this.outputField.getDefaultValue()));
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.outputField.getDisplayText());
        this.targetCheckBox.setSelected(InputField.isTrue(this.outputField.getDefaultValue()));
        if (InputField.isTrue(this.outputField.getForce())) {
            this.targetCheckBox.setEnabled(false);
        }
        this.targetCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetInputRenderer.this.updateInputField();
                TargetInputRenderer.this.outputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.targetCheckBox, gBCF.getCell(n, 1));
        if (bl) {
            this.targetCheckBox.setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
    }
}

