/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AITextfield;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class ValidatedTextInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected ValidatedTextInput inputField;
    protected AILabel fieldLabel = new AILabel();
    protected JTextField jTextField = new AITextfield();
    protected Color origFore = this.jTextField.getForeground();

    public void initComponent(JPanel jPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (ValidatedTextInput)outputField;
        this.inputField.setValue(this.inputField.getDefaultValue());
    }

    public void updateInputField() {
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue());
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue());
        this.jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ValidatedTextInputRenderer.this.jTextField.setForeground(ValidatedTextInputRenderer.this.origFore);
            }
        });
        this.jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '\t') {
                    ValidatedTextInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.jTextField, gBCF.getCell(n, 1));
        if (bl) {
            ((AITextfield)this.jTextField).setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
        MessageRenderer messageRenderer = this.ctx.getMessageRenderer();
        messageRenderer.printMessage(res.getString("notCorrectFormat") + "\n\n e.g. " + this.inputField.getDefaultValue());
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
    }
}

