/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.tp23.antinstaller.runtime.Logger;

public class SimpleLogger
implements Logger {
    BufferedWriter fos;

    public void setFileName(String string) {
        try {
            this.fos = new BufferedWriter(new FileWriter(string, true));
            this.fos.write("Logger initialized");
            this.fos.newLine();
        }
        catch (IOException iOException) {
            this.fos = null;
        }
    }

    public void log(String string) {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.write(string);
            this.fos.newLine();
            this.fos.flush();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not write to logs");
        }
    }

    public void log(Throwable throwable) {
        if (this.fos == null) {
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.fos.write(stringWriter.getBuffer().toString());
            this.fos.newLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can not write to logs");
        }
    }

    public void close() {
        try {
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't close logger");
        }
    }

    protected void finalize() throws Throwable {
        if (this.fos != null) {
            this.fos.flush();
            this.fos.close();
        }
    }
}

