/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.text.TextMessageRenderer;
import org.tp23.antinstaller.renderer.text.TextPageRenderer;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class TextRunner
implements Runner {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private List targets = new ArrayList();
    private final InstallerContext ctx;
    private final Installer installer;
    private final Logger logger;
    private final IfPropertyHelper ifHelper;

    public TextRunner(InstallerContext installerContext) throws IOException {
        this.ctx = installerContext;
        this.installer = installerContext.getInstaller();
        this.logger = installerContext.getLogger();
        installerContext.setMessageRenderer(new TextMessageRenderer());
        installerContext.setAntOutputRenderer(new AntOutputRenderer(){

            public PrintStream getErr() {
                return System.err;
            }

            public PrintStream getOut() {
                return System.out;
            }
        });
        this.ifHelper = new IfPropertyHelper(installerContext);
    }

    public boolean runInstaller() throws InstallException {
        try {
            return this.renderPages(this.installer.getPages());
        }
        catch (Exception exception) {
            this.logger.log("FATAL exception during installation:" + exception.getMessage());
            if (this.installer.isVerbose()) {
                this.logger.log(exception);
            }
            this.ctx.getMessageRenderer().printMessage(res.getString("installationFailed") + ":" + exception.getMessage());
            throw new InstallException("Installation failed", exception);
        }
    }

    private boolean renderPages(Page[] pageArray) throws ClassNotFoundException, InstallException {
        Page page = null;
        for (int i = 0; i < pageArray.length; ++i) {
            Object object;
            page = pageArray[i];
            if (page instanceof SimpleInputPage) {
                object = (SimpleInputPage)page;
                String string = ((SimpleInputPage)object).getIfTarget();
                if (string != null) {
                    boolean bl = false;
                    for (int j = 0; j < pageArray.length; ++j) {
                        bl |= pageArray[j].isTarget(string);
                    }
                    if (!bl) continue;
                }
                if (!this.ifHelper.ifProperty(page)) continue;
            }
            object = RendererFactory.getTextPageRenderer(page);
            ((TextPageRenderer)object).setContext(this.ctx);
            ((TextPageRenderer)object).init(System.in, System.out);
            this.ctx.setCurrentPage(page);
            ((TextPageRenderer)object).renderPage(page);
            if (!page.isAbort()) continue;
            return false;
        }
        return true;
    }

    public InstallerContext getInstallerContext() {
        return this.ctx;
    }

    public void antFinished() {
        System.out.println(res.getString("finished"));
    }

    public void fatalError() {
        System.out.println(res.getString("failed"));
    }

    public String toString() {
        return "TextRunner";
    }
}

