/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.InterruptableInputStream;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.signedurl.SignedUrlAndObject;
import org.jets3t.service.utils.signedurl.SignedUrlHandler;

public class S3ServiceMulti
implements Serializable {
    private static final long serialVersionUID = -1031831146656816336L;
    private final Log log = LogFactory.getLog((Class)S3ServiceMulti.class);
    private S3Service s3Service = null;
    private ArrayList serviceEventListeners = new ArrayList();
    private final long sleepTime;
    static /* synthetic */ Class class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager;

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener) {
        this(s3Service, listener, 500L);
    }

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener, long threadSleepTimeMS) {
        this.s3Service = s3Service;
        this.addServiceEventListener(listener);
        this.sleepTime = threadSleepTimeMS;
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        int maxConnectionCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("httpclient.max-connections", 4);
        if (maxConnectionCount < maxThreadCount) {
            this.log.warn((Object)("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + maxThreadCount + " simultaneous threads (s3service.max-thread-count) - please adjust JetS3t settings"));
        }
        if (maxConnectionCount < adminMaxThreadCount) {
            this.log.warn((Object)("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + adminMaxThreadCount + " simultaneous admin threads (s3service.admin-max-thread-count) - please adjust JetS3t settings"));
        }
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    public void addServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.add(listener);
        }
    }

    public void removeServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.remove(listener);
        }
    }

    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0) {
            this.log.warn((Object)"S3ServiceMulti invoked without any S3ServiceEventListener objects, this is dangerous!");
        }
        Iterator listenerIter = this.serviceEventListeners.iterator();
        while (listenerIter.hasNext()) {
            S3ServiceEventListener listener = (S3ServiceEventListener)listenerIter.next();
            if (event instanceof CreateObjectsEvent) {
                listener.s3ServiceEventPerformed((CreateObjectsEvent)event);
                continue;
            }
            if (event instanceof CreateBucketsEvent) {
                listener.s3ServiceEventPerformed((CreateBucketsEvent)event);
                continue;
            }
            if (event instanceof DeleteObjectsEvent) {
                listener.s3ServiceEventPerformed((DeleteObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectsEvent) {
                listener.s3ServiceEventPerformed((GetObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectHeadsEvent) {
                listener.s3ServiceEventPerformed((GetObjectHeadsEvent)event);
                continue;
            }
            if (event instanceof LookupACLEvent) {
                listener.s3ServiceEventPerformed((LookupACLEvent)event);
                continue;
            }
            if (event instanceof UpdateACLEvent) {
                listener.s3ServiceEventPerformed((UpdateACLEvent)event);
                continue;
            }
            if (event instanceof DownloadObjectsEvent) {
                listener.s3ServiceEventPerformed((DownloadObjectsEvent)event);
                continue;
            }
            throw new IllegalArgumentException("Listener not invoked for event class: " + event.getClass());
        }
    }

    public boolean isAuthenticatedConnection() {
        return this.s3Service.isAuthenticatedConnection();
    }

    public AWSCredentials getAWSCredentials() {
        return this.s3Service.getAWSCredentials();
    }

    public void createBuckets(S3Bucket[] buckets) {
        final ArrayList<S3Bucket> incompletedBucketList = new ArrayList<S3Bucket>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new CreateBucketRunnable[buckets.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedBucketList.add(buckets[i]);
            runnables[i] = new CreateBucketRunnable(buckets[i]);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedBucketList.removeAll(completedResults);
                S3Bucket[] completedBuckets = completedResults.toArray(new S3Bucket[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newInProgressEvent(threadWatcher, completedBuckets, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Bucket[] incompletedBuckets = incompletedBucketList.toArray(new S3Bucket[incompletedBucketList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCancelledEvent(incompletedBuckets, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void putObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new CreateObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(objects[i]);
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            runnables[i] = new CreateObjectRunnable(bucket, objects[i], progressMonitor);
            progressWatchers.add(progressMonitor);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void deleteObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new DeleteObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            objectsToDeleteList.add(objects[i]);
            runnables[i] = new DeleteObjectRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjects(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        this.getObjects(bucket, objectKeys);
    }

    public void getObjects(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], false);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjectsHeads(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        this.getObjectsHeads(bucket, objectKeys);
    }

    public void getObjectsHeads(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], true);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjectACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new GetACLRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void putACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new PutACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new PutACLRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void downloadObjects(S3Bucket bucket, DownloadPackage[] downloadPackages) {
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompleteObjectDownloadList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        boolean restoreLastModifiedDate = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("downloads.restoreLastModifiedDate", false);
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        S3Object[] objects = new S3Object[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            objects[i] = downloadPackages[i].getObject();
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            incompleteObjectDownloadList.add(objects[i]);
            progressWatchers.add(progressMonitor);
            runnables[i] = new DownloadObjectRunnable(bucket, objects[i].getKey(), downloadPackages[i], progressMonitor, restoreLastModifiedDate);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompleteObjects = incompleteObjectDownloadList.toArray(new S3Object[incompleteObjectDownloadList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void downloadObjectsWithSignedURLs(DownloadPackage[] downloadPackages) {
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompleteObjectDownloadList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        boolean restoreLastModifiedDate = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("downloads.restoreLastModifiedDate", false);
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        S3Object[] objects = new S3Object[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            objects[i] = downloadPackages[i].getObject();
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            incompleteObjectDownloadList.add(objects[i]);
            progressWatchers.add(progressMonitor);
            runnables[i] = new DownloadObjectRunnable(downloadPackages[i], progressMonitor, restoreLastModifiedDate);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompleteObjects = incompleteObjectDownloadList.toArray(new S3Object[incompleteObjectDownloadList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjects(String[] signedGetURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetObjectRunnable[signedGetURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedGetURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedGetURLs[i], false);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjectsHeads(String[] signedHeadURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjectsHeads(String[] signedHeadURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetObjectRunnable[signedHeadURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedHeadURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedHeadURLs[i], true);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void putObjectsACLs(String[] signedURLs, AccessControlList acl) throws MalformedURLException, UnsupportedEncodingException {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new PutACLRunnable[signedURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectsList.add(object);
            runnables[i] = new PutACLRunnable(signedURLs[i], acl);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void deleteObjects(String[] signedDeleteUrls) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method deleteObjects(String[] signedDeleteURLs) available");
        }
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new DeleteObjectRunnable[signedDeleteUrls.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedDeleteUrls[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            objectsToDeleteList.add(object);
            runnables[i] = new DeleteObjectRunnable(signedDeleteUrls[i]);
        }
        int adminMaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.admin-max-thread-count", 4);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) available");
        }
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        S3Object[] objects = new S3Object[signedPutUrlAndObjects.length];
        for (int i = 0; i < signedPutUrlAndObjects.length; ++i) {
            objects[i] = signedPutUrlAndObjects[i].getObject();
        }
        AbstractRunnable[] runnables = new SignedPutRunnable[signedPutUrlAndObjects.length];
        for (int i = 0; i < runnables.length; ++i) {
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            progressWatchers.add(progressMonitor);
            incompletedObjectsList.add(signedPutUrlAndObjects[i].getObject());
            runnables[i] = new SignedPutRunnable(signedPutUrlAndObjects[i], progressMonitor);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    public void getObjectsACLs(String[] signedAclURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        AbstractRunnable[] runnables = new GetACLRunnable[signedAclURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedAclURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetACLRunnable(signedAclURLs[i]);
        }
        int maxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length)){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList cancelledObjectsList = new ArrayList();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    cancelledObjectsList.add(iter.next());
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }
        }.run();
    }

    private abstract class ThreadGroupManager {
        private final Log log = LogFactory.getLog((Class)(class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager == null ? (class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager = S3ServiceMulti.class$("org.jets3t.service.multithread.S3ServiceMulti$ThreadGroupManager")) : class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager));
        private int maxThreadCount = 1;
        private AbstractRunnable[] runnables = null;
        private Thread[] threads = null;
        private boolean[] started = null;
        private boolean[] alreadyFired = null;
        private ThreadWatcher threadWatcher = null;
        private long lastProgressEventFiredTime = 0L;

        public ThreadGroupManager(AbstractRunnable[] runnables, int maxThreadCount, ThreadWatcher threadWatcher) {
            this.runnables = runnables;
            this.maxThreadCount = maxThreadCount;
            this.threadWatcher = threadWatcher;
            this.threads = new Thread[runnables.length];
            this.started = new boolean[runnables.length];
            this.alreadyFired = new boolean[runnables.length];
        }

        private List getNewlyCompletedResults() throws Throwable {
            ArrayList<Object> completedResults = new ArrayList<Object>();
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.alreadyFired[i] || !this.started[i] || this.threads[i].isAlive()) continue;
                this.alreadyFired[i] = true;
                this.log.debug((Object)("Thread " + (i + 1) + " of " + this.threads.length + " has recently completed, releasing resources"));
                if (this.runnables[i].getResult() instanceof Throwable) {
                    Throwable throwable = (Throwable)this.runnables[i].getResult();
                    this.runnables[i] = null;
                    this.threads[i] = null;
                    boolean ignoreExceptions = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("s3service.ignore-exceptions-in-multi", false);
                    if (ignoreExceptions) {
                        this.log.warn((Object)"Ignoring exception (property s3service.ignore-exceptions-in-multi is set to true)", throwable);
                        continue;
                    }
                    throw throwable;
                }
                completedResults.add(this.runnables[i].getResult());
                this.runnables[i] = null;
                this.threads[i] = null;
            }
            return completedResults;
        }

        private void startPendingThreads() throws Throwable {
            int i;
            int runningThreadCount = 0;
            for (i = 0; i < this.runnables.length; ++i) {
                if (!this.started[i] || this.alreadyFired[i]) continue;
                ++runningThreadCount;
            }
            for (i = 0; runningThreadCount < this.maxThreadCount && i < this.started.length; ++i) {
                if (this.started[i]) continue;
                this.threads[i] = new Thread(this.runnables[i]);
                this.threads[i].start();
                this.started[i] = true;
                ++runningThreadCount;
                this.log.debug((Object)("Thread " + (i + 1) + " of " + this.runnables.length + " has started"));
            }
        }

        private int getPendingThreadCount() {
            int pendingThreadCount = 0;
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.alreadyFired[i]) continue;
                ++pendingThreadCount;
            }
            return pendingThreadCount;
        }

        private void forceInterruptAllRunnables() {
            this.log.debug((Object)"Setting force interrupt flag on all runnables");
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.runnables[i] == null) continue;
                this.runnables[i].forceInterrupt();
                this.runnables[i] = null;
            }
        }

        public void run() {
            this.log.debug((Object)"Started ThreadManager");
            final boolean[] interrupted = new boolean[]{false};
            CancelEventTrigger cancelEventTrigger = new CancelEventTrigger(){
                private static final long serialVersionUID = 6328417466929608235L;

                public void cancelTask(Object eventSource) {
                    ThreadGroupManager.this.log.debug((Object)"Cancel task invoked on ThreadManager");
                    interrupted[0] = true;
                    ThreadGroupManager.this.forceInterruptAllRunnables();
                }
            };
            try {
                List completedResults;
                int completedThreads;
                this.startPendingThreads();
                this.threadWatcher.updateThreadsCompletedCount(0L, cancelEventTrigger);
                this.fireStartEvent(this.threadWatcher);
                while (!interrupted[0] && this.getPendingThreadCount() > 0) {
                    try {
                        Thread.sleep(100L);
                        if (interrupted[0]) continue;
                        if (System.currentTimeMillis() - this.lastProgressEventFiredTime > S3ServiceMulti.this.sleepTime) {
                            completedThreads = this.runnables.length - this.getPendingThreadCount();
                            this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                            completedResults = this.getNewlyCompletedResults();
                            this.lastProgressEventFiredTime = System.currentTimeMillis();
                            this.fireProgressEvent(this.threadWatcher, completedResults);
                        }
                        this.startPendingThreads();
                    }
                    catch (InterruptedException e) {
                        interrupted[0] = true;
                        this.forceInterruptAllRunnables();
                    }
                }
                if (interrupted[0]) {
                    this.fireCancelEvent();
                } else {
                    completedThreads = this.runnables.length - this.getPendingThreadCount();
                    this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                    completedResults = this.getNewlyCompletedResults();
                    this.fireProgressEvent(this.threadWatcher, completedResults);
                    if (completedResults.size() > 0) {
                        this.log.debug((Object)(completedResults.size() + " threads have recently completed"));
                    }
                    this.fireCompletedEvent();
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"A thread failed with an exception. Firing ERROR event and cancelling all threads", t);
                this.forceInterruptAllRunnables();
                this.fireErrorEvent(t);
            }
        }

        public abstract void fireStartEvent(ThreadWatcher var1);

        public abstract void fireProgressEvent(ThreadWatcher var1, List var2);

        public abstract void fireCompletedEvent();

        public abstract void fireCancelEvent();

        public abstract void fireErrorEvent(Throwable var1);
    }

    private class SignedPutRunnable
    extends AbstractRunnable {
        private SignedUrlAndObject signedUrlAndObject;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private Object result;

        public SignedPutRunnable(SignedUrlAndObject signedUrlAndObject, BytesProgressWatcher progressMonitor) {
            this.signedUrlAndObject = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.result = null;
            this.signedUrlAndObject = signedUrlAndObject;
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.signedUrlAndObject.getObject().getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.signedUrlAndObject.getObject().getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.signedUrlAndObject.getObject().setDataInputStream(pmInputStream);
                }
                SignedUrlHandler signedPutUploader = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                this.result = signedPutUploader.putObjectWithSignedUrl(this.signedUrlAndObject.getSignedUrl(), this.signedUrlAndObject.getObject());
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
            finally {
                try {
                    this.signedUrlAndObject.getObject().closeDataInputStream();
                }
                catch (IOException e) {
                    S3ServiceMulti.this.log.error((Object)"Unable to close Object's input stream", (Throwable)e);
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class DownloadObjectRunnable
    extends AbstractRunnable {
        private String objectKey;
        private S3Bucket bucket;
        private DownloadPackage downloadPackage;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private boolean restoreLastModifiedDate;
        private Object result;

        public DownloadObjectRunnable(S3Bucket bucket, String objectKey, DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucket = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        public DownloadObjectRunnable(DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucket = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream bufferedOutputStream = null;
            S3Object object = null;
            try {
                if (!this.downloadPackage.isSignedDownload()) {
                    object = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    object = handler.getObjectWithSignedUrl(this.downloadPackage.getSignedUrl());
                }
                this.interruptableInputStream = new InterruptableInputStream(object.getDataInputStream());
                bufferedInputStream = new BufferedInputStream(new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor));
                bufferedOutputStream = new BufferedOutputStream(this.downloadPackage.getOutputStream());
                try {
                    byte[] buffer = new byte[1024];
                    int byteCount = -1;
                    while ((byteCount = bufferedInputStream.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                    }
                }
                finally {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                object.setDataInputStream(null);
                object.setDataInputFile(this.downloadPackage.getDataFile());
                if (this.restoreLastModifiedDate && this.downloadPackage.getDataFile() != null) {
                    String metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso8601");
                    if (metadataLocalFileDate == null) {
                        metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso860");
                    }
                    if (metadataLocalFileDate != null) {
                        S3ServiceMulti.this.log.debug((Object)("Restoring original Last Modified date for object '" + object.getKey() + "' to file '" + this.downloadPackage.getDataFile() + "': " + metadataLocalFileDate));
                        this.downloadPackage.getDataFile().setLastModified(ServiceUtils.parseIso8601Date(metadataLocalFileDate).getTime());
                    }
                }
                this.result = object;
            }
            catch (Throwable t) {
                this.result = t;
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception e) {
                        S3ServiceMulti.this.log.error((Object)"Unable to close Object input stream", (Throwable)e);
                    }
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Exception e) {
                        S3ServiceMulti.this.log.error((Object)"Unable to close download output stream", (Throwable)e);
                    }
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class GetObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private String objectKey;
        private String signedGetOrHeadUrl;
        private boolean headOnly;
        private Object result;

        public GetObjectRunnable(S3Bucket bucket, String objectKey, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.headOnly = headOnly;
        }

        public GetObjectRunnable(String signedGetOrHeadUrl, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = signedGetOrHeadUrl;
            this.bucket = null;
            this.objectKey = null;
            this.headOnly = headOnly;
        }

        public void run() {
            try {
                if (this.headOnly) {
                    if (this.signedGetOrHeadUrl == null) {
                        this.result = S3ServiceMulti.this.s3Service.getObjectDetails(this.bucket, this.objectKey);
                    } else {
                        SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                        this.result = handler.getObjectDetailsWithSignedUrl(this.signedGetOrHeadUrl);
                    }
                } else if (this.signedGetOrHeadUrl == null) {
                    this.result = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    this.result = handler.getObjectWithSignedUrl(this.signedGetOrHeadUrl);
                }
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CreateObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private Object result;

        public CreateObjectRunnable(S3Bucket bucket, S3Object s3Object, BytesProgressWatcher progressMonitor) {
            this.bucket = null;
            this.s3Object = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
            this.progressMonitor = progressMonitor;
        }

        public void run() {
            try {
                if (this.s3Object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.s3Object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.s3Object.setDataInputStream(pmInputStream);
                }
                this.result = S3ServiceMulti.this.s3Service.putObject(this.bucket, this.s3Object);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class CreateBucketRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private Object result;

        public CreateBucketRunnable(S3Bucket bucket) {
            this.bucket = null;
            this.result = null;
            this.bucket = bucket;
        }

        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.createBucket(this.bucket);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class DeleteObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private String signedDeleteUrl;
        private Object result;

        public DeleteObjectRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = null;
            this.bucket = bucket;
            this.object = object;
        }

        public DeleteObjectRunnable(String signedDeleteUrl) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = signedDeleteUrl;
            this.bucket = null;
            this.object = null;
        }

        public void run() {
            try {
                if (this.signedDeleteUrl == null) {
                    S3ServiceMulti.this.s3Service.deleteObject(this.bucket, this.object.getKey());
                    this.result = this.object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    handler.deleteObjectWithSignedUrl(this.signedDeleteUrl);
                    URL url = new URL(this.signedDeleteUrl);
                    this.result = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class GetACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private String signedAclUrl;
        private Object result;

        public GetACLRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.signedAclUrl = null;
            this.result = null;
            this.bucket = bucket;
            this.object = object;
        }

        public GetACLRunnable(String signedAclUrl) {
            this.bucket = null;
            this.object = null;
            this.signedAclUrl = null;
            this.result = null;
            this.signedAclUrl = signedAclUrl;
            this.bucket = null;
            this.object = null;
        }

        public void run() {
            try {
                if (this.signedAclUrl == null) {
                    AccessControlList acl = S3ServiceMulti.this.s3Service.getObjectAcl(this.bucket, this.object.getKey());
                    this.object.setAcl(acl);
                    this.result = this.object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    AccessControlList acl = handler.getObjectAclWithSignedUrl(this.signedAclUrl);
                    URL url = new URL(this.signedAclUrl);
                    this.object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                    this.object.setAcl(acl);
                    this.result = this.object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class PutACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private String signedUrl;
        private AccessControlList signedUrlAcl;
        private Object result;

        public PutACLRunnable(S3Bucket bucket, S3Object s3Object) {
            this.bucket = null;
            this.s3Object = null;
            this.signedUrl = null;
            this.signedUrlAcl = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
        }

        public PutACLRunnable(String signedAclUrl, AccessControlList signedUrlAcl) {
            this.bucket = null;
            this.s3Object = null;
            this.signedUrl = null;
            this.signedUrlAcl = null;
            this.result = null;
            this.signedUrl = signedAclUrl;
            this.signedUrlAcl = signedUrlAcl;
            this.bucket = null;
            this.s3Object = null;
        }

        public void run() {
            try {
                if (this.signedUrl == null) {
                    if (this.s3Object == null) {
                        S3ServiceMulti.this.s3Service.putBucketAcl(this.bucket);
                    } else {
                        S3ServiceMulti.this.s3Service.putObjectAcl(this.bucket, this.s3Object);
                    }
                    this.result = this.s3Object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    handler.putObjectAclWithSignedUrl(this.signedUrl, this.signedUrlAcl);
                    URL url = new URL(this.signedUrl);
                    S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                    object.setAcl(this.signedUrlAcl);
                    this.result = object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private abstract class AbstractRunnable
    implements Runnable {
        private boolean forceInterrupt = false;

        private AbstractRunnable() {
        }

        public abstract Object getResult();

        public abstract void forceInterruptCalled();

        protected void forceInterrupt() {
            this.forceInterrupt = true;
            this.forceInterruptCalled();
        }

        protected boolean notInterrupted() throws InterruptedException {
            if (this.forceInterrupt || Thread.interrupted()) {
                throw new InterruptedException("Interrupted by JAMES");
            }
            return true;
        }
    }
}

