/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.faces.converter;

import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class PhoneNumberConverter
implements Converter,
StateHolder {
    private boolean _transient;
    private String _unitedStatesFormat;

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean value) {
        this._transient = value;
    }

    public String getUnitedStatesFormat() {
        return this._unitedStatesFormat;
    }

    public void setUnitedStatesFormat(String unitedStatesFormat) {
        this._unitedStatesFormat = unitedStatesFormat;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (value != null) {
            StringBuilder integerChars = new StringBuilder();
            StringBuilder invalidChars = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char curChar = value.charAt(i);
                if (Character.isDigit(curChar)) {
                    integerChars.append(curChar);
                    continue;
                }
                if (curChar == '-' || curChar == '(' || curChar == ')' || curChar == '.' || curChar == '+' || curChar == ' ') continue;
                invalidChars.append(curChar);
            }
            if (invalidChars.length() > 0) {
                ExternalContext externalContext = facesContext.getExternalContext();
                Locale locale = externalContext.getRequestLocale();
                String summary = LanguageUtil.get((Locale)locale, (String)"the-following-are-invalid-characters");
                summary = summary + " " + invalidChars.toString();
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null);
                throw new ConverterException(facesMessage);
            }
            if (integerChars.length() == 10) {
                StringBuilder unitedStatesPhoneNumber = new StringBuilder();
                int integerDigitIndex = 0;
                for (int i = 0; i < this._unitedStatesFormat.length(); ++i) {
                    char curChar = this._unitedStatesFormat.charAt(i);
                    if (curChar == '#') {
                        unitedStatesPhoneNumber.append(integerChars.charAt(integerDigitIndex++));
                        continue;
                    }
                    unitedStatesPhoneNumber.append(curChar);
                }
                return unitedStatesPhoneNumber.toString();
            }
        }
        return value;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) throws ConverterException {
        return (String)value;
    }

    public void restoreState(FacesContext facesContext, Object obj) {
        Object[] values = (Object[])obj;
        this._unitedStatesFormat = (String)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._unitedStatesFormat};
        return values;
    }
}

