/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.model.Theme;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.velocity.VelocityContextPool;
import com.liferay.portal.velocity.VelocityVariables;
import com.liferay.taglib.util.VelocityTaglib;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.struts.tiles.ComponentContext;

public class ThemeUtil {
    private static final String _TEMPLATE_EXTENSION_VM = "vm";
    private static Log _log = LogFactoryUtil.getLog(ThemeUtil.class);

    public static void include(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String page, Theme theme) throws Exception {
        String extension = theme.getTemplateExtension();
        if (extension.equals(_TEMPLATE_EXTENSION_VM)) {
            ThemeUtil.includeVM(servletContext, request, pageContext, page, theme, true);
        } else {
            String path = theme.getTemplatesPath() + "/" + page;
            ThemeUtil.includeJSP(servletContext, request, response, path, theme);
        }
    }

    public static void includeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        String tilesTitle = ThemeUtil._getTilesVariables(request, "title");
        String tilesContent = ThemeUtil._getTilesVariables(request, "content");
        boolean tilesSelectable = GetterUtil.getBoolean((String)ThemeUtil._getTilesVariables(request, "selectable"));
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        themeDisplay.setTilesTitle(tilesTitle);
        themeDisplay.setTilesContent(tilesContent);
        themeDisplay.setTilesSelectable(tilesSelectable);
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            if (themeServletContext == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " cannot find its " + "servlet context at " + theme.getServletContextName()));
            } else {
                RequestDispatcher requestDispatcher = themeServletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
                } else {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
            }
        } else {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
            } else {
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public static String includeVM(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String page, Theme theme, boolean write) throws Exception {
        String ctxName = GetterUtil.getString((String)theme.getServletContextName());
        if (VelocityContextPool.get((String)ctxName) == null) {
            VelocityContextPool.put((String)ctxName, (ServletContext)servletContext);
        }
        int pos = page.lastIndexOf(".");
        StringBuilder sb = new StringBuilder();
        sb.append(ctxName);
        sb.append(theme.getVelocityResourceListener());
        sb.append(theme.getTemplatesPath());
        sb.append("/");
        sb.append(page.substring(0, pos));
        sb.append(".");
        sb.append(_TEMPLATE_EXTENSION_VM);
        String source = sb.toString();
        if (!VelocityEngineUtil.resourceExists((String)source)) {
            _log.error((Object)(source + " does not exist"));
            return null;
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        VelocityVariables.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        ServletContext themeServletContext = VelocityContextPool.get((String)ctxName);
        StringServletResponse stringResponse = new StringServletResponse((HttpServletResponse)pageContext.getResponse());
        VelocityTaglib velocityTaglib = new VelocityTaglib(servletContext, request, stringResponse, pageContext);
        request.setAttribute("VELOCITY_TAGLIB", (Object)velocityTaglib);
        velocityContext.put("themeServletContext", (Object)themeServletContext);
        velocityContext.put("taglibLiferay", (Object)velocityTaglib);
        velocityContext.put("theme", (Object)velocityTaglib);
        VelocityEngineUtil.mergeTemplate((String)source, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        String output = unsyncStringWriter.toString();
        if (write) {
            pageContext.getOut().print(output);
            return null;
        }
        return output;
    }

    private static String _getTilesVariables(HttpServletRequest request, String attributeName) {
        ComponentContext componentContext = (ComponentContext)request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
        String value = null;
        if (componentContext != null) {
            value = (String)componentContext.getAttribute(attributeName);
        }
        return value;
    }
}

