/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.RefVar;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayValue
extends Value {
    private static final Logger log = Logger.getLogger(ArrayValue.class.getName());
    protected static final StringValue KEY = new StringBuilderValue("key");
    protected static final StringValue VALUE = new StringBuilderValue("value");
    public static final GetKey GET_KEY = new GetKey();
    public static final GetValue GET_VALUE = new GetValue();
    protected Entry _current;

    protected ArrayValue() {
    }

    @Override
    public String getType() {
        return "array";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.ARRAY;
    }

    @Override
    public boolean toBoolean() {
        return this.getSize() != 0;
    }

    public String toString() {
        return "Array";
    }

    public Object toObject() {
        return null;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Value toArray() {
        return this;
    }

    @Override
    public ArrayValue toArrayValue(Env env) {
        return this;
    }

    @Override
    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        Entry entry = this.getHead();
        while (entry != null) {
            Value key = entry.getKey();
            if (key instanceof StringValue) {
                obj.putField(env, key.toString(), entry.getValue());
            }
            entry = entry._next;
        }
        return obj;
    }

    @Override
    public Collection toJavaCollection(Env env, Class type) {
        Collection<Object> coll = null;
        if (type.isAssignableFrom(HashSet.class)) {
            coll = new HashSet();
        } else if (type.isAssignableFrom(TreeSet.class)) {
            coll = new TreeSet();
        } else {
            try {
                coll = (Collection)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            coll.add(entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return coll;
    }

    @Override
    public List toJavaList(Env env, Class type) {
        List list = null;
        if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (type.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else if (type.isAssignableFrom(Vector.class)) {
            list = new Vector();
        } else {
            try {
                list = (List)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            list.add(entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return list;
    }

    @Override
    public Map toJavaMap(Env env, Class type) {
        Map<Object, Object> map = null;
        if (type.isAssignableFrom(TreeMap.class)) {
            map = new TreeMap();
        } else if (type.isAssignableFrom(LinkedHashMap.class)) {
            map = new LinkedHashMap();
        } else {
            try {
                map = (Map)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            map.put(entry.getKey().toJavaObject(), entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return map;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Value copyReturn() {
        return this.copy();
    }

    @Override
    public abstract Value copy();

    @Override
    public abstract Value copy(Env var1, IdentityHashMap<Value, Value> var2);

    @Override
    public abstract int getSize();

    @Override
    public int getCount(Env env) {
        return this.getSize();
    }

    @Override
    public int getCountRecursive(Env env) {
        env.stub("recursive count of array unimplemented");
        return this.getSize();
    }

    public abstract void clear();

    @Override
    public int cmp(Value rValue) {
        return this.cmpImpl(rValue, 1);
    }

    private int cmpImpl(Value rValue, int resultIfKeyMissing) {
        int rSize;
        if (!rValue.isArray()) {
            return 1;
        }
        int lSize = this.getSize();
        if (lSize != (rSize = rValue.toArray().getSize())) {
            return lSize < rSize ? -1 : 1;
        }
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value lElementValue = entry.getValue();
            Value rElementValue = rValue.get(entry.getKey());
            if (!rElementValue.isset()) {
                return resultIfKeyMissing;
            }
            int cmp = lElementValue.cmp(rElementValue);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean lt(Value rValue) {
        return this.cmpImpl(rValue, 1) < 0;
    }

    @Override
    public boolean leq(Value rValue) {
        return this.cmpImpl(rValue, 1) <= 0;
    }

    @Override
    public boolean gt(Value rValue) {
        return this.cmpImpl(rValue, -1) > 0;
    }

    @Override
    public boolean geq(Value rValue) {
        return this.cmpImpl(rValue, -1) >= 0;
    }

    @Override
    public abstract Value put(Value var1, Value var2);

    @Override
    public abstract Value put(Value var1);

    public abstract ArrayValue unshift(Value var1);

    public abstract ArrayValue splice(int var1, int var2, ArrayValue var3);

    @Override
    public Value getArray(Value index) {
        Value array;
        Value value = this.get(index);
        if (value != (array = value.toAutoArray())) {
            value = array;
            this.put(index, value);
        }
        return value;
    }

    @Override
    public abstract Value getArg(Value var1);

    @Override
    public Value getObject(Env env, Value fieldName) {
        Value object;
        Value value = this.get(fieldName);
        if (value != (object = value.toAutoObject(env))) {
            value = object;
            this.put(fieldName, value);
        }
        return value;
    }

    @Override
    public abstract Value putRef();

    public abstract Value createTailKey();

    @Override
    public Value add(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof ArrayValue)) {
            return this.copy();
        }
        ArrayValue rArray = (ArrayValue)rValue;
        ArrayValueImpl result = new ArrayValueImpl(rArray);
        Entry entry = this.getHead();
        while (entry != null) {
            ((ArrayValue)result).put(entry.getKey(), entry.getValue());
            entry = entry._next;
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return new EntryIterator(this.getHead());
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return new KeyIterator(this.getHead());
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return new ValueIterator(this.getHead());
    }

    @Override
    public abstract Value get(Value var1);

    public Value getRaw(Value key) {
        return this.get(key);
    }

    @Override
    public abstract Value remove(Value var1);

    @Override
    public abstract Var getRef(Value var1);

    public Set<Value> keySet() {
        return new KeySet();
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return new EntrySet();
    }

    public Collection<Value> values() {
        return new ValueCollection();
    }

    public void put(String key, String value) {
        this.put(StringValue.create(key), StringValue.create(value));
    }

    public void put(Env env, String key, String value) {
        this.put(env.createString(key), env.createString(value));
    }

    public void put(String key, char value) {
        this.put(StringValue.create(key), StringValue.create(value));
    }

    public void put(String key, long value) {
        this.put(StringValue.create(key), new LongValue(value));
    }

    public void put(Env env, String key, long value) {
        this.put(env.createString(key), new LongValue(value));
    }

    public void put(String key, double value) {
        this.put(StringValue.create(key), new DoubleValue(value));
    }

    public void put(String key, boolean value) {
        this.put(StringValue.create(key), value ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    public void put(Env env, String key, boolean value) {
        this.put(env.createString(key), value ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    public void put(String value) {
        this.put(StringValue.create(value));
    }

    public void put(long value) {
        this.put(new LongValue(value));
    }

    public ArrayValue append(Value key, Value value) {
        this.put(key, value);
        return this;
    }

    public ArrayValue append(Value value) {
        this.put(value);
        return this;
    }

    public void putAll(ArrayValue array) {
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public static Value toArray(Value value) {
        if ((value = value.toValue()) instanceof ArrayValue) {
            return value;
        }
        return new ArrayValueImpl().put(value);
    }

    @Override
    public void print(Env env) {
        env.print("Array");
    }

    public abstract Value pop();

    public abstract void shuffle();

    public abstract Entry getHead();

    protected abstract Entry getTail();

    @Override
    public Value current() {
        if (this._current != null) {
            return this._current.getValue();
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Value key() {
        if (this._current != null) {
            return this._current.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public boolean hasCurrent() {
        return this._current != null;
    }

    @Override
    public Value next() {
        if (this._current != null) {
            this._current = this._current._next;
        }
        return this.current();
    }

    public Value prev() {
        if (this._current != null) {
            this._current = this._current._prev;
        }
        return this.current();
    }

    public Value each() {
        if (this._current == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl result = new ArrayValueImpl();
        ((ArrayValue)result).put(LongValue.ZERO, this._current.getKey());
        ((ArrayValue)result).put(KEY, this._current.getKey());
        ((ArrayValue)result).put(LongValue.ONE, this._current.getValue());
        ((ArrayValue)result).put(VALUE, this._current.getValue());
        this._current = this._current._next;
        return result;
    }

    public Value reset() {
        this._current = this.getHead();
        return this.current();
    }

    public Value end() {
        this._current = this.getTail();
        return this.current();
    }

    public Value contains(Value value) {
        Entry entry = this.getHead();
        while (entry != null) {
            if (entry.getValue().eq(value)) {
                return entry.getKey();
            }
            entry = entry._next;
        }
        return NullValue.NULL;
    }

    public Value containsStrict(Value value) {
        Entry entry = this.getHead();
        while (entry != null) {
            if (entry.getValue().eql(value)) {
                return entry.getKey();
            }
            entry = entry._next;
        }
        return NullValue.NULL;
    }

    public abstract Value containsKey(Value var1);

    public Map.Entry<Value, Value>[] toEntryArray() {
        ArrayList<Entry> array = new ArrayList<Entry>(this.getSize());
        Entry entry = this.getHead();
        while (entry != null) {
            array.add(entry);
            entry = entry._next;
        }
        Entry[] result = new Entry[array.size()];
        return array.toArray(result);
    }

    public void sort(Comparator<Map.Entry<Value, Value>> comparator, boolean resetKeys, boolean strict) {
        Entry[] entries = new Entry[this.getSize()];
        int i = 0;
        Entry entry = this.getHead();
        while (entry != null) {
            entries[i++] = entry;
            entry = entry._next;
        }
        Arrays.sort(entries, comparator);
        this.clear();
        long base = 0L;
        if (!resetKeys) {
            strict = false;
        }
        for (int j = 0; j < entries.length; ++j) {
            Value key = entries[j].getKey();
            if (resetKeys && (!(key instanceof StringValue) || strict)) {
                this.put(LongValue.create(base++), entries[j].getValue());
                continue;
            }
            this.put(entries[j].getKey(), entries[j].getValue());
        }
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("a:");
        sb.append(this.getSize());
        sb.append(":{");
        Entry entry = this.getHead();
        while (entry != null) {
            entry.getKey().serialize(sb);
            entry.getValue().serialize(sb);
            entry = entry._next;
        }
        sb.append("}");
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append("array(");
        boolean isFirst = true;
        Entry entry = this.getHead();
        while (entry != null) {
            entry.getKey().varExport(sb);
            sb.append(" => ");
            entry.getValue().varExport(sb);
            sb.append(", ");
            entry = entry._next;
        }
        sb.append(")");
    }

    public boolean keyReset(long base, boolean strict) {
        Entry[] entries = new Entry[this.getSize()];
        int i = 0;
        Entry entry = this.getHead();
        while (entry != null) {
            entries[i++] = entry;
            entry = entry._next;
        }
        this.clear();
        for (int j = 0; j < entries.length; ++j) {
            Value key = entries[j].getKey();
            if (!(key instanceof StringValue) || strict) {
                this.put(LongValue.create(base++), entries[j].getValue());
                continue;
            }
            this.put(entries[j].getKey(), entries[j].getValue());
        }
        return true;
    }

    @Override
    public boolean eq(Value rValue) {
        if (rValue == null) {
            return false;
        }
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            Value rEntryValue = rValue.get(entryKey);
            if (rEntryValue instanceof ArrayValue && !entryValue.eq((ArrayValue)rEntryValue)) {
                return false;
            }
            if (entryValue.eq(rEntryValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eql(Value rValue) {
        if (rValue == null) {
            return false;
        }
        if (this.getSize() != rValue.getSize()) {
            return false;
        }
        if (!((rValue = rValue.toValue()) instanceof ArrayValue)) {
            return false;
        }
        ArrayValue rArray = (ArrayValue)rValue;
        Iterator<Map.Entry<Value, Value>> iterA = this.entrySet().iterator();
        Iterator<Map.Entry<Value, Value>> iterB = rArray.entrySet().iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Map.Entry<Value, Value> entryA = iterA.next();
            Map.Entry<Value, Value> entryB = iterB.next();
            if (!entryA.getKey().eql(entryB.getKey())) {
                return false;
            }
            if (entryA.getValue().eql(entryB.getValue())) continue;
            return false;
        }
        return !iterA.hasNext() && !iterB.hasNext();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("array(" + this.getSize() + ") {");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            Entry entry = (Entry)mapEntry;
            entry.varDumpImpl(env, out, depth + 1, valueSet);
            out.println();
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("Array");
        this.printDepth(out, 8 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            Entry entry = (Entry)mapEntry;
            entry.printRImpl(env, out, depth, valueSet);
        }
        this.printDepth(out, 8 * depth);
        out.println(")");
    }

    @Override
    public Value[] getKeyArray(Env env) {
        int len = this.getSize();
        Value[] keys = new Value[len];
        Iterator<Value> iter = this.getKeyIterator(env);
        for (int i = 0; i < len; ++i) {
            keys[i] = iter.next();
        }
        return keys;
    }

    @Override
    public Value[] getValueArray(Env env) {
        int len = this.getSize();
        Value[] values = new Value[len];
        Iterator<Value> iter = this.getValueIterator(env);
        for (int i = 0; i < len; ++i) {
            values[i] = iter.next();
        }
        return values;
    }

    public Value[] valuesToArray() {
        Value[] values = new Value[this.getSize()];
        int i = 0;
        for (Entry ptr = this.getHead(); ptr != null; ptr = ptr.getNext()) {
            values[i++] = ptr.getValue();
        }
        return values;
    }

    @Override
    public Object valuesToArray(Env env, Class elementType) {
        int size = this.getSize();
        Object array = Array.newInstance(elementType, size);
        MarshalFactory factory = env.getModuleContext().getMarshalFactory();
        Marshal elementMarshal = factory.create(elementType);
        int i = 0;
        for (Entry ptr = this.getHead(); ptr != null; ptr = ptr.getNext()) {
            Array.set(array, i++, elementMarshal.marshal(env, ptr.getValue(), elementType));
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetValue
    extends AbstractGet {
        public static final GetValue GET = new GetValue();

        private GetValue() {
        }

        @Override
        public Value get(Map.Entry<Value, Value> entry) {
            return entry.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetKey
    extends AbstractGet {
        public static final GetKey GET = new GetKey();

        private GetKey() {
        }

        @Override
        public Value get(Map.Entry<Value, Value> entry) {
            return entry.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractGet {
        public abstract Value get(Map.Entry<Value, Value> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyComparator
    implements Comparator<Map.Entry<Value, Value>> {
        public static final KeyComparator CMP = new KeyComparator();

        private KeyComparator() {
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aKey = aEntry.getKey();
                Value bKey = bEntry.getKey();
                if (aKey.eq(bKey)) {
                    return 0;
                }
                if (aKey.lt(bKey)) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueComparator
    implements Comparator<Map.Entry<Value, Value>> {
        public static final ValueComparator CMP = new ValueComparator();

        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aValue = aEntry.getValue();
                Value bValue = bEntry.getValue();
                if (aValue.eq(bValue)) {
                    return 0;
                }
                if (aValue.lt(bValue)) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator
    implements Iterator<Value> {
        private Entry _current;

        ValueIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Value next() {
            if (this._current != null) {
                Value next = this._current.getValue();
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator
    implements Iterator<Value> {
        private Entry _current;

        KeyIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Value next() {
            if (this._current != null) {
                Value next = this._current.getKey();
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Entry _current;

        EntryIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            if (this._current != null) {
                Entry next = this._current;
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueCollection
    extends AbstractCollection<Value> {
        ValueCollection() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(ArrayValue.this.getHead());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeySet
    extends AbstractSet<Value> {
        KeySet() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new KeyIterator(ArrayValue.this.getHead());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new EntryIterator(ArrayValue.this.getHead());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Map.Entry<Value, Value>,
    Serializable {
        final Value _key;
        Value _value;
        Entry _prev;
        Entry _next;
        Entry _prevHash;
        Entry _nextHash;
        int _index;

        public Entry(Value key) {
            this._key = key;
            this._value = NullValue.NULL;
        }

        public Entry(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        public Entry getNext() {
            return this._next;
        }

        public Value getRawValue() {
            return this._value;
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toRefVar() {
            Value val = this._value;
            if (val instanceof Var) {
                return (Var)val;
            }
            Var var = new Var(val);
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public Value toRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            this._value = new Var(value);
            return new RefVar((Var)this._value);
        }

        public Value toArgRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            this._value = new Var(this._value);
            return new RefVar((Var)this._value);
        }

        public Value toArg() {
            Value value = this._value;
            if (value instanceof Var) {
                return value;
            }
            this._value = new Var(value);
            return this._value;
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 2 * depth);
            out.print("[");
            if (this._key instanceof StringValue) {
                out.print("\"" + this._key + "\"");
            } else {
                out.print((Object)this._key);
            }
            out.println("]=>");
            this.printDepth(out, 2 * depth);
            this._value.varDump(env, out, depth, valueSet);
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 8 * depth);
            out.print("    [");
            out.print((Object)this._key);
            out.print("] => ");
            if (this._value != null) {
                this._value.printR(env, out, depth + 1, valueSet);
            }
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = depth; i > 0; --i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ArrayValue.Entry[" + this.getKey() + "]";
        }
    }
}

