/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanValue
extends Value
implements Serializable {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private final boolean _value;

    protected BooleanValue(boolean value) {
        this._value = value;
    }

    public static BooleanValue create(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Value create(Boolean value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (Boolean.TRUE.equals(value)) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public String getType() {
        return "boolean";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        return this._value;
    }

    @Override
    public long toLong() {
        return this._value ? 1L : 0L;
    }

    @Override
    public double toDouble() {
        return this._value ? 1.0 : 0.0;
    }

    public String toString() {
        return this._value ? "1" : "";
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().append(this._value);
    }

    public Object toObject() {
        return this._value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object toJavaObject() {
        return this._value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Value toAutoArray() {
        if (!this._value) {
            return new ArrayValueImpl();
        }
        return this;
    }

    @Override
    public Value toAutoObject(Env env) {
        if (!this._value) {
            return env.createObject();
        }
        return this;
    }

    @Override
    public Value toKey() {
        return this._value ? LongValue.ONE : LongValue.ZERO;
    }

    @Override
    public boolean eq(Value rValue) {
        return this._value == rValue.toBoolean();
    }

    @Override
    public int cmp(Value rValue) {
        double r;
        double l = this._value ? 1.0 : 0.0;
        if (l == (r = rValue.toDouble())) {
            return 0;
        }
        if (l < r) {
            return -1;
        }
        return 1;
    }

    @Override
    public void print(Env env) {
        env.print(this._value ? "1" : "");
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        if (this._value) {
            out.print("com.caucho.quercus.env.BooleanValue.TRUE");
        } else {
            out.print("com.caucho.quercus.env.BooleanValue.FALSE");
        }
    }

    public void generateBoolean(PrintWriter out) throws IOException {
        if (this._value) {
            out.print("true");
        } else {
            out.print("false");
        }
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("b:");
        sb.append(this._value ? 1 : 0);
        sb.append(';');
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append(this._value ? "true" : "false");
    }

    public int hashCode() {
        return this._value ? 17 : 37;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        BooleanValue value = (BooleanValue)o;
        return this._value == value._value;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this.toBoolean()) {
            out.print("bool(true)");
        } else {
            out.print("bool(false)");
        }
    }

    private Object readResolve() {
        if (this._value) {
            return TRUE;
        }
        return FALSE;
    }
}

