/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class BytesBuilderValue
extends BytesValue
implements Serializable {
    protected byte[] _buffer;
    protected int _length;
    private String _value;

    public BytesBuilderValue() {
        this._buffer = new byte[128];
    }

    public BytesBuilderValue(int capacity) {
        capacity = capacity < 64 ? 128 : 2 * capacity;
        this._buffer = new byte[capacity];
    }

    public BytesBuilderValue(byte[] buffer, int offset, int length) {
        this._buffer = new byte[length];
        this._length = length;
        System.arraycopy(buffer, offset, this._buffer, 0, length);
    }

    public BytesBuilderValue(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BytesBuilderValue(Byte[] buffer) {
        int length = buffer.length;
        this._buffer = new byte[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = buffer[i];
        }
    }

    public BytesBuilderValue(String string, String encoding) {
        int length = string.length();
        this._buffer = new byte[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = (byte)string.charAt(i);
        }
    }

    protected BytesValue copy(byte[] buffer, int offset, int length) {
        return new BytesBuilderValue(buffer, offset, length);
    }

    public String getValue() {
        return this.toString();
    }

    public String getType() {
        return "string";
    }

    public boolean isLongConvertible() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            byte ch = this._buffer[i];
            if (48 <= ch && ch <= 57) continue;
            return false;
        }
        return true;
    }

    public boolean isDouble() {
        return this.getNumericType() == 2;
    }

    public boolean isNumber() {
        return this.getNumericType() != 0;
    }

    public boolean isScalar() {
        return true;
    }

    protected int getNumericType() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return 0;
        }
        int i = 0;
        byte ch = 0;
        boolean hasPoint = false;
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        if (len <= i) {
            return 0;
        }
        ch = buffer[i];
        if (ch == 46) {
            if (++i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                return 2;
            }
            return 0;
        }
        if (48 > ch || ch > 57) {
            return 0;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (len <= i) {
            return 1;
        }
        if (ch == 46 || ch == 101 || ch == 69) {
            ++i;
            while (i < len && (48 <= (ch = buffer[i]) && ch <= 57 || ch == 43 || ch == 45 || ch == 101 || ch == 69)) {
                ++i;
            }
            if (i < len) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._buffer[0] != 48;
    }

    public long toLong() {
        return BytesBuilderValue.toLong(this._buffer, 0, this._length);
    }

    public double toDouble() {
        byte[] buffer = this._buffer;
        int len = this._length;
        int i = 0;
        byte ch = 0;
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (ch == 46) {
            ++i;
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == 1) {
                return 0.0;
            }
        }
        if (ch == 101 || ch == 69) {
            int e = i++;
            if (i < len && (ch = buffer[i]) == 43 || ch == 45) {
                ++i;
            }
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        try {
            if (i == len) {
                return Double.parseDouble(this.toString());
            }
            return Double.parseDouble(new String(this._buffer, 0, i));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public InputStream toInputStream() {
        return new BuilderInputStream();
    }

    public String toString() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    public Object toJavaObject() {
        if (this._value == null) {
            this._value = new String(this._buffer, 0, this._length);
        }
        return this._value;
    }

    public StringValue toStringBuilder() {
        return this.copy(this._buffer, 0, this._length);
    }

    public void appendTo(BytesBuilderValue bb) {
        bb.append(this._buffer, 0, this._length);
    }

    public Value toKey() {
        byte[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        byte ch = buffer[i];
        if (ch == 45) {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = buffer[i];
            if (48 > ch || ch > 57) {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return new LongValue((long)sign * value);
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        System.arraycopy(this._buffer, 0, bytes, 0, this._length);
        return bytes;
    }

    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    public Value getRef(Value key) {
        return this.charValueAt(key.toLong());
    }

    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        return StringValue.create((char)(this._buffer[(int)index] & 0xFF));
    }

    public int length() {
        return this._length;
    }

    public char charAt(int index) {
        return (char)(this._buffer[index] & 0xFF);
    }

    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return StringValue.EMPTY;
        }
        return this.copy(this._buffer, start, end - start);
    }

    public void print(Env env) {
        env.write(this._buffer, 0, this._length);
    }

    public void serialize(StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    public final StringValue append(String s) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s);
        return sb;
    }

    public final StringValue append(String s, int start, int end) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s, start, end);
        return sb;
    }

    public final StringValue append(char ch) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(ch);
        return sb;
    }

    public final StringValue append(char[] buf, int offset, int length) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(buf, offset, length);
        return sb;
    }

    public final StringValue append(CharSequence buf, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        if (buf instanceof BytesBuilderValue) {
            BytesBuilderValue sb = (BytesBuilderValue)buf;
            System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
            this._length += tail - head;
            return this;
        }
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(buf, head, tail);
        return sb;
    }

    public final StringValue append(BytesBuilderValue sb, int head, int tail) {
        int length = tail - head;
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(sb._buffer, head, this._buffer, this._length, tail - head);
        this._length += tail - head;
        return this;
    }

    public final StringValue append(Value v) {
        if (v.length() == 0) {
            return this;
        }
        if (v.isBinary()) {
            v.appendTo(this);
            return this;
        }
        if (v.isUnicode()) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue();
            this.appendTo(sb);
            v.appendTo(sb);
            return sb;
        }
        if (this._length == 0) {
            return v.toStringBuilder();
        }
        v.appendTo(this);
        return this;
    }

    public final StringValue append(byte[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(buf, offset, this._buffer, this._length, length);
        this._length += length;
        return this;
    }

    public final StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public final StringValue append(byte v) {
        int length = this._length + 1;
        if (this._buffer.length < length) {
            this.ensureCapacity(length);
        }
        this._buffer[this._length++] = v;
        return this;
    }

    public final StringValue appendByte(int v) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)v;
        return this;
    }

    public final StringValue append(boolean v) {
        return this.appendBytes(v ? "true" : "false");
    }

    public StringValue append(long v) {
        return this.appendBytes(String.valueOf(v));
    }

    public StringValue append(double v) {
        return this.appendBytes(String.valueOf(v));
    }

    public StringValue appendBytes(String s) {
        int sublen = s.length();
        if (this._buffer.length < this._length + sublen) {
            this.ensureCapacity(this._length + sublen);
        }
        for (int i = 0; i < sublen; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
        return this;
    }

    public void prepareReadBuffer() {
        this.ensureCapacity(this._buffer.length + 1);
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public int getOffset() {
        return this._length;
    }

    public void setOffset(int offset) {
        this._length = offset;
    }

    public int getLength() {
        return this._buffer.length;
    }

    public OutputStream getOutputStream() {
        return new BuilderOutputStream();
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity <= this._buffer.length) {
            return;
        }
        newCapacity = newCapacity < 4096 ? 4 * newCapacity : (newCapacity += 4096);
        byte[] buffer = new byte[newCapacity];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
    }

    public int hashCode() {
        int hash = 37;
        int length = this._length;
        byte[] buffer = this._buffer;
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + (buffer[i] & 0xFF);
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof BytesBuilderValue) {
            BytesBuilderValue value = (BytesBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            byte[] bufferA = this._buffer;
            byte[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void generate(PrintWriter out) throws IOException {
        out.print("new InternBytesValue(\"");
        this.printJavaString(out, this);
        out.print("\", \"UTF-8\")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._length);
        out.write(this._buffer, 0, this._length);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._length = in.readInt();
        this._buffer = new byte[this._length];
        in.read(this._buffer, 0, this._length);
    }

    class BuilderOutputStream
    extends OutputStream {
        BuilderOutputStream() {
        }

        public void write(int ch) {
            BytesBuilderValue.this.append(ch);
        }

        public void write(byte[] buffer, int offset, int length) {
            BytesBuilderValue.this.append(buffer, offset, length);
        }
    }

    class BuilderInputStream
    extends InputStream {
        private int _index;

        BuilderInputStream() {
        }

        public int read() {
            if (this._index < BytesBuilderValue.this._length) {
                return BytesBuilderValue.this._buffer[this._index++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = BytesBuilderValue.this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(BytesBuilderValue.this._buffer, this._index, buffer, offset, sublen);
            this._index += sublen;
            return sublen;
        }
    }

    class BinaryInputStream
    extends InputStream {
        private int _offset;

        BinaryInputStream() {
        }

        public int read() {
            if (this._offset < BytesBuilderValue.this._length) {
                return BytesBuilderValue.this._buffer[this._offset++];
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = BytesBuilderValue.this._length - this._offset;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            System.arraycopy(BytesBuilderValue.this._buffer, this._offset, buffer, offset, sublen);
            this._offset += sublen;
            return sublen;
        }
    }
}

