/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledObjectValue
extends ObjectValue
implements Serializable {
    private static final StringValue TO_STRING = new UnicodeValueImpl("__toString");
    private static final Value[] NULL_FIELDS = new Value[0];
    public Value[] _fields;
    private ObjectExtValue _object;

    public CompiledObjectValue(QuercusClass cl) {
        super(cl);
        int size = cl.getFieldSize();
        this._fields = size != 0 ? new Value[cl.getFieldSize()] : NULL_FIELDS;
    }

    @Override
    public CompiledObjectValue toObjectValue() {
        return this;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int i = 0; i < this._fields.length; ++i) {
            if (this._fields[i] == UnsetValue.UNSET) continue;
            ++size;
        }
        if (this._object != null) {
            size += this._object.getSize();
        }
        return size;
    }

    @Override
    public Value getField(Env env, String key, boolean create) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            return this._fields[index].toValue();
        }
        if (this._object != null) {
            return this._object.getField(env, key, create);
        }
        if (create) {
            this._object = new ObjectExtValue(this._quercusClass);
            return this._object.getField(env, key, create);
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Var getFieldRef(Env env, String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toRefVar();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldRef(env, key);
    }

    @Override
    public Value getFieldArg(Env env, String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toRefVar();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArg(env, key);
    }

    @Override
    public Value getFieldArgRef(Env env, String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toRefVar();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArgRef(env, key);
    }

    @Override
    public Value getFieldArray(Env env, String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].toAutoArray();
            return this._fields[index];
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArray(env, key);
    }

    @Override
    public Value getFieldObject(Env env, String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].toAutoObject(env);
            return this._fields[index];
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldObject(env, key);
    }

    @Override
    public Value putField(Env env, String key, Value value) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].set(value);
            return value;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.putField(env, key, value);
    }

    @Override
    public Value putField(String key, String value) {
        return this.putField(null, key, new StringBuilderValue(value));
    }

    @Override
    public Value putField(String key, long value) {
        return this.putField(null, key, LongValue.create(value));
    }

    @Override
    public Value putField(String key, double value) {
        return this.putField(null, key, DoubleValue.create(value));
    }

    @Override
    public void removeField(String key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = UnsetValue.UNSET;
            return;
        }
        if (this._object != null) {
            this._object.removeField(key);
        }
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    public Value callMethod(Env env, String methodName, Expr[] args) {
        return this._quercusClass.getFunction(methodName).callMethod(env, (Value)this, args);
    }

    public Value callMethod(Env env, String methodName, Value[] args) {
        AbstractFunction fun = this._quercusClass.findFunction(methodName);
        if (fun != null) {
            return fun.callMethod(env, (Value)this, args);
        }
        return env.error(L.l("Call to undefined method {0}::{1}()", (Object)this._quercusClass.getName(), (Object)methodName));
    }

    public Value callMethod(Env env, String methodName) {
        return this._quercusClass.getFunction(methodName).callMethod(env, this);
    }

    public Value callMethod(Env env, String methodName, Value a0) {
        return this._quercusClass.getFunction(methodName).callMethod(env, (Value)this, a0);
    }

    public Value callMethod(Env env, String methodName, Value a0, Value a1) {
        return this._quercusClass.getFunction(methodName).callMethod(env, this, a0, a1);
    }

    public Value callMethod(Env env, String methodName, Value a0, Value a1, Value a2) {
        return this._quercusClass.getFunction(methodName).callMethod(env, this, a0, a1, a2);
    }

    public Value callMethod(Env env, String methodName, Value a0, Value a1, Value a2, Value a3) {
        return this._quercusClass.getFunction(methodName).callMethod(env, this, a0, a1, a2, a3);
    }

    public Value callMethod(Env env, String methodName, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this._quercusClass.getFunction(methodName).callMethod(env, this, a0, a1, a2, a3, a4);
    }

    public Value callMethodRef(Env env, String methodName, Expr[] args) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, (Value)this, args);
    }

    public Value callMethodRef(Env env, String methodName, Value[] args) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, (Value)this, args);
    }

    public Value callMethodRef(Env env, String methodName) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, this);
    }

    public Value callMethodRef(Env env, String methodName, Value a0) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, (Value)this, a0);
    }

    public Value callMethodRef(Env env, String methodName, Value a0, Value a1) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, this, a0, a1);
    }

    public Value callMethodRef(Env env, String methodName, Value a0, Value a1, Value a2) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, this, a0, a1, a2);
    }

    public Value callMethodRef(Env env, String methodName, Value a0, Value a1, Value a2, Value a3) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, this, a0, a1, a2, a3);
    }

    public Value callMethodRef(Env env, String methodName, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this._quercusClass.getFunction(methodName).callMethodRef(env, this, a0, a1, a2, a3, a4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callClassMethod(Env env, AbstractFunction fun, Value[] args) {
        Value oldThis = env.getThis();
        try {
            env.setThis(this);
            Value value = fun.call(env, args);
            return value;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Value clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("O:");
        sb.append(this._quercusClass.getName().length());
        sb.append(":\"");
        sb.append(this._quercusClass.getName());
        sb.append("\":");
        sb.append(this.getSize());
        sb.append(":{");
        ArrayList<String> names = this._quercusClass.getFieldNames();
        if (names != null) {
            boolean index = false;
            for (int i = 0; i < names.size(); ++i) {
                String key = names.get(i);
                if (this._fields[i] == UnsetValue.UNSET) continue;
                sb.append("s:");
                sb.append(key.length());
                sb.append(":\"");
                sb.append(key);
                sb.append("\";");
                this._fields[i].serialize(sb);
            }
        }
        if (this._object != null) {
            for (Map.Entry<String, Value> mapEntry : this._object.sortedEntrySet()) {
                ObjectExtValue.Entry entry = (ObjectExtValue.Entry)mapEntry;
                String key = entry.getKey();
                sb.append("s:");
                sb.append(key.length());
                sb.append(":\"");
                sb.append(key);
                sb.append("\";");
                entry.getValue().serialize(sb);
            }
        }
        sb.append("}");
    }

    @Override
    public StringValue toString(Env env) {
        AbstractFunction fun = this._quercusClass.findFunction("__toString");
        if (fun != null) {
            return fun.callMethod(env, (Value)this, new Expr[0]).toString(env);
        }
        return env.createUnicodeBuilder().append(this._quercusClass.getName()).append("[]");
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public Value toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<String, Value> entry : this.entrySet()) {
            ((ArrayValue)array).put(new StringBuilderValue(entry.getKey()), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<Map.Entry<String, Value>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<String, Value>> sortedEntrySet() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CompiledObjectValue@" + System.identityHashCode(this) + "[" + this._quercusClass.getName() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._fields);
        out.writeObject(this._object);
        out.writeObject(this._quercusClass.getName());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        String name;
        this._fields = (Value[])in.readObject();
        this._object = (ObjectExtValue)in.readObject();
        Env env = Env.getInstance();
        QuercusClass cl = env.findClass(name = (String)in.readObject());
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.putField(env, "__Quercus_Class_Definition_Not_Found", new StringBuilderValue(name));
        }
    }
}

