/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.CallbackObjectMethod;
import com.caucho.quercus.env.DefinitionKey;
import com.caucho.quercus.env.DefinitionState;
import com.caucho.quercus.env.GlobalArrayValue;
import com.caucho.quercus.env.ImportMap;
import com.caucho.quercus.env.IncludeCache;
import com.caucho.quercus.env.IncludeKey;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.OutputBuffer;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.ServerArrayValue;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.SessionCallback;
import com.caucho.quercus.env.SessionVar;
import com.caucho.quercus.env.Shutdown;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.lib.ErrorModule;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.util.Alarm;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.i18n.EncodingReader;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Env {
    private static final L10N L = new L10N(Env.class);
    private static final Logger log = Logger.getLogger(Env.class.getName());
    public static final int B_ERROR = 0;
    public static final int B_WARNING = 1;
    public static final int B_PARSE = 2;
    public static final int B_NOTICE = 3;
    public static final int B_CORE_ERROR = 4;
    public static final int B_CORE_WARNING = 5;
    public static final int B_COMPILE_ERROR = 6;
    public static final int B_COMPILE_WARNING = 7;
    public static final int B_USER_ERROR = 8;
    public static final int B_USER_WARNING = 9;
    public static final int B_USER_NOTICE = 10;
    public static final int B_STRICT = 11;
    public static final int E_ERROR = 1;
    public static final int E_WARNING = 2;
    public static final int E_PARSE = 4;
    public static final int E_NOTICE = 8;
    public static final int E_CORE_ERROR = 16;
    public static final int E_CORE_WARNING = 32;
    public static final int E_COMPILE_ERROR = 64;
    public static final int E_COMPILE_WARNING = 128;
    public static final int E_USER_ERROR = 256;
    public static final int E_USER_WARNING = 512;
    public static final int E_USER_NOTICE = 1024;
    public static final int E_ALL = 2047;
    public static final int E_STRICT = 2048;
    public static final int E_DEFAULT = 2039;
    private static final int _SERVER = 1;
    private static final int _GET = 2;
    private static final int _POST = 3;
    private static final int _COOKIE = 4;
    private static final int _GLOBAL = 5;
    private static final int _REQUEST = 6;
    private static final int _SESSION = 7;
    private static final int HTTP_GET_VARS = 8;
    private static final int HTTP_POST_VARS = 9;
    private static final int HTTP_COOKIE_VARS = 10;
    private static final int PHP_SELF = 11;
    private static final int _FILES = 12;
    private static final int HTTP_POST_FILES = 13;
    private static final int _ENV = 14;
    private static final int HTTP_SERVER_VARS = 15;
    private static final IntMap SPECIAL_VARS = new IntMap();
    private static final StringValue PHP_SELF_STRING = new StringBuilderValue("PHP_SELF");
    private static final StringValue UTF8_STRING = new StringBuilderValue("utf-8");
    private static final LruCache<ClassKey, SoftReference<QuercusClass>> _classCache = new LruCache(4096);
    private static final LruCache<IncludeKey, SoftReference<IncludeCache>> _includeCache = new LruCache(4096);
    private static ThreadLocal<Env> _threadEnv = new ThreadLocal();
    protected final Quercus _quercus;
    private final boolean _isUnicodeSemantics;
    private QuercusPage _page;
    private Value _this = NullThisValue.NULL;
    private ArrayList<SoftReference<Closeable>> _closeList = new ArrayList();
    private ArrayList<Shutdown> _shutdownList = new ArrayList();
    private HashMap<String, Var> _globalMap = new HashMap(1024);
    private HashMap<String, Var> _staticMap = new HashMap();
    private HashMap<String, Var> _map = this._globalMap;
    private DefinitionState _defState;
    private HashMap<String, Value> _constMap = new HashMap(1024);
    private HashMap<String, Value> _lowerConstMap = new HashMap(1024);
    private HashMap<String, QuercusClass> _classMap = new HashMap();
    private HashMap<String, QuercusClass> _lowerClassMap = new HashMap();
    private HashSet<String> _initializedClassSet = new HashSet();
    private IdentityHashMap<String, Value> _iniMap;
    private HashMap<String, Object> _specialMap = new HashMap();
    private String _prevIncludePath = ".";
    private String _includePath;
    private ArrayList<String> _includePathList;
    private HashMap<Path, ArrayList<Path>> _includePathMap;
    private HashSet<Path> _includeSet = new HashSet();
    private HashMap<StringValue, Path> _lookupCache = new HashMap();
    private HashMap<ConnectionEntry, ConnectionEntry> _connMap = new HashMap();
    private AbstractFunction _autoload;
    private long _startTime;
    private long _timeLimit = 600000L;
    private Expr[] _callStack = new Expr[256];
    private Value[] _callThisStack = new Value[256];
    private int _callStackTop;
    private Value[] _functionArgs;
    private Path _selfPath;
    private Path _pwd;
    private Path _uploadPath;
    private ArrayList<Path> _removePaths;
    private final boolean _isStrict;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ArrayValue _post;
    private ArrayValue _files;
    private SessionArrayValue _session;
    private HttpSession _javaSession;
    private ScriptContext _scriptContext;
    private WriteStream _originalOut;
    private OutputBuffer _outputBuffer;
    private WriteStream _out;
    private LocaleInfo _locale;
    private Callback[] _prevErrorHandlers = new Callback[12];
    private Callback[] _errorHandlers = new Callback[12];
    private Callback _prevExceptionHandler;
    private Callback _exceptionHandler;
    private SessionCallback _sessionCallback;
    private StreamContextResource _defaultStreamContext;
    private int _errorMask = 2039;
    private int _objectId = 0;
    private Logger _logger;
    private ImportMap _importMap;
    private TimeZone _defaultTimeZone;
    private Env _oldThreadEnv;

    public Env(Quercus quercus, QuercusPage page, WriteStream out, HttpServletRequest request, HttpServletResponse response) {
        this._quercus = quercus;
        this._isStrict = quercus.isStrict();
        this._isUnicodeSemantics = quercus.isUnicodeSemantics();
        this._page = page;
        this._defState = new DefinitionState(quercus);
        this._originalOut = out;
        this._out = out;
        this._request = request;
        this._response = response;
        if (page != null) {
            this._page.init(this);
            this.importPage(this._page);
        }
        this.setPwd(this._quercus.getPwd());
        if (this._page != null) {
            this._selfPath = this._page.getSelfPath(null);
            this._includeSet.add(this._selfPath);
        }
        if (this._request != null && this._request.getMethod().equals("POST")) {
            this._post = new ArrayValueImpl();
            this._files = new ArrayValueImpl();
            Post.fillPost(this, this._post, this._files, this._request, this.getIniBoolean("magic_quotes_gpc"));
        }
    }

    public Env(Quercus quercus) {
        this(quercus, null, null, null, null);
    }

    public static Env getInstance() {
        return _threadEnv.get();
    }

    public boolean isUnicodeSemantics() {
        return this._isUnicodeSemantics;
    }

    public String getScriptEncoding() {
        StringValue encoding = this.getIni("unicode.script_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            return this.getQuercus().getScriptEncoding();
        }
        return encoding.toString();
    }

    public StringValue getRuntimeEncoding() {
        StringValue encoding = this.getIni("unicode.runtime_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            encoding = UTF8_STRING;
        }
        return encoding;
    }

    public Value setRuntimeEncoding(String encoding) {
        return this.setIni("unicode.runtime_encoding", encoding);
    }

    public EncodingReader getRuntimeEncodingFactory() throws IOException {
        return Encoding.getReadFactory((String)this.getRuntimeEncoding().toString());
    }

    public StringValue getHttpInputEncoding() {
        StringValue encoding = this.getIni("unicode.http_input_encoding");
        if (encoding.length() == 0 && (encoding = this.getIni("unicode.fallback_encoding")).length() == 0) {
            encoding = UTF8_STRING;
        }
        return encoding;
    }

    public String getOutputEncoding() {
        if (!this._isUnicodeSemantics) {
            return null;
        }
        String encoding = Quercus.INI_UNICODE_OUTPUT_ENCODING.getAsString(this);
        if (encoding == null) {
            encoding = Quercus.INI_UNICODE_FALLBACK_ENCODING.getAsString(this);
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        return encoding;
    }

    public StringValue createBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createLargeBinaryBuilder() {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue();
        }
        return new StringBuilderValue();
    }

    public StringValue createBinaryBuilder(int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(length);
        }
        return new StringBuilderValue(length);
    }

    public StringValue createBinaryBuilder(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, offset, length);
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createBinaryBuilder(byte[] buffer) {
        if (this._isUnicodeSemantics) {
            return new BinaryBuilderValue(buffer, 0, buffer.length);
        }
        return new StringBuilderValue(buffer, 0, buffer.length);
    }

    public StringValue createUnicodeBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public TimeZone getDefaultTimeZone() {
        return this._defaultTimeZone;
    }

    public void setDefaultTimeZone(String id) {
        this._defaultTimeZone = TimeZone.getTimeZone(id);
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
    }

    public ServletContext getServletContext() {
        return this._quercus.getServletContext();
    }

    public void setScriptContext(ScriptContext context) {
        this._scriptContext = context;
    }

    public final boolean isStrict() {
        return this._isStrict;
    }

    public void start() {
        this._startTime = Alarm.getCurrentTime();
        Env oldThreadEnv = _threadEnv.get();
        _threadEnv.set(this);
        String encoding = this.getOutputEncoding();
        String type = this.getIniString("default_mimetype");
        if (!"".equals(type) && this._response != null) {
            if (encoding != null) {
                this._response.setContentType(type + "; charset=" + encoding);
            } else {
                this._response.setContentType(type);
            }
        }
        if (this._out != null && encoding != null) {
            try {
                this._out.setEncoding(encoding);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        HashSet<ModuleStartupListener> listeners = this._quercus.getModuleStartupListeners();
        for (ModuleStartupListener listener : listeners) {
            listener.startup(this);
        }
    }

    public void addClose(Closeable closeable) {
        this._closeList.add(new SoftReference<Closeable>(closeable));
    }

    public void removeClose(Closeable closeable) {
        for (int i = this._closeList.size() - 1; i >= 0; --i) {
            SoftReference<Closeable> ref = this._closeList.get(i);
            Closeable res = ref.get();
            if (!closeable.equals(res)) continue;
            this._closeList.remove(i);
            break;
        }
    }

    public Quercus getQuercus() {
        return this._quercus;
    }

    public ModuleContext getModuleContext() {
        return this._quercus.getModuleContext();
    }

    public DataSource getDatabase() {
        return this._quercus.getDatabase();
    }

    protected DataSource findDatabase(String driver, String url) throws Exception {
        return this._quercus.findDatabase(driver, url);
    }

    public Connection getConnection(String driver, String url, String userName, String password) throws Exception {
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            ConnectionEntry entry = new ConnectionEntry();
            entry.init(database, null, null);
            ConnectionEntry oldEntry = this._connMap.get(entry);
            if (oldEntry != null) {
                return oldEntry.getConnection();
            }
            entry.setConnection(database.getConnection());
            this._connMap.put(entry, entry);
            return entry.getConnection();
        }
        database = this.findDatabase(driver, url);
        ConnectionEntry entry = new ConnectionEntry();
        entry.init(database, userName, password);
        ConnectionEntry oldEntry = this._connMap.get(entry);
        if (oldEntry != null) {
            return oldEntry.getConnection();
        }
        if (userName == null || userName.equals("")) {
            entry.setConnection(database.getConnection());
        } else {
            entry.setConnection(database.getConnection(userName, password));
        }
        this._connMap.put(entry, entry);
        return entry.getConnection();
    }

    public DataSource getDataSource(String driver, String url) throws Exception {
        DataSource database = this._quercus.getDatabase();
        if (database != null) {
            return database;
        }
        return this.findDatabase(driver, url);
    }

    public void setTimeLimit(long ms) {
        if (ms <= 0L) {
            ms = 0x3FFFFFFFFFFFFFFFL;
        }
        this._timeLimit = ms;
    }

    public final void checkTimeout() {
        long now = Alarm.getCurrentTime();
        if (this._startTime + this._timeLimit < now) {
            throw new QuercusRuntimeException(L.l("script timed out"));
        }
    }

    public WriteStream getOut() {
        return this._out;
    }

    public WriteStream getOriginalOut() {
        return this._originalOut;
    }

    public final void flush() {
        try {
            this.getOut().flush();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(String v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char[] buffer, int offset, int length) {
        try {
            this.getOut().print(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(char v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(long v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(double v) {
        try {
            long longV = (long)v;
            if (v == (double)longV) {
                this.getOut().print(longV);
            } else {
                this.getOut().print(v);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Object v) {
        try {
            this.getOut().print(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void print(Value v) {
        v.print(this);
    }

    public final void println() {
        try {
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(String v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Value v) {
        try {
            v.print(this);
            this.getOut().println();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void println(Object v) {
        try {
            this.getOut().println(v);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public final void write(byte[] buffer, int offset, int length) {
        try {
            this.getOut().write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public OutputBuffer getOutputBuffer() {
        return this._outputBuffer;
    }

    public void pushOutputBuffer(Callback callback, int chunkSize, boolean erase) {
        this._outputBuffer = this._outputBuffer == null ? new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase) : new OutputBuffer(this._outputBuffer, this, callback, chunkSize, erase);
        this._out = this._outputBuffer.getOut();
    }

    public boolean popOutputBuffer() {
        OutputBuffer outputBuffer = this._outputBuffer;
        if (outputBuffer == null) {
            return false;
        }
        outputBuffer.close();
        this._outputBuffer = outputBuffer.getNext();
        this._out = this._outputBuffer != null ? this._outputBuffer.getOut() : this._originalOut;
        return true;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public Path getWorkDir() {
        return this._quercus.getWorkDir();
    }

    public void setPwd(Path path) {
        this._pwd = path;
        this._lookupCache.clear();
    }

    public Path getSelfPath() {
        return this._selfPath;
    }

    public Path getSelfDirectory() {
        return this._selfPath.getParent();
    }

    public void setSelfPath(Path path) {
        this._selfPath = path;
    }

    public Path getUploadDirectory() {
        if (this._uploadPath == null) {
            String realPath = this.getIniString("upload_tmp_dir");
            if (realPath == null) {
                realPath = this.getRequest().getRealPath("/WEB-INF/upload");
            }
            this._uploadPath = this._quercus.getPwd().lookup(realPath);
            try {
                if (!this._uploadPath.isDirectory()) {
                    this._uploadPath.mkdirs();
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this._uploadPath = this._uploadPath.createRoot();
        }
        return this._uploadPath;
    }

    public void addRemovePath(Path path) {
        if (this._removePaths == null) {
            this._removePaths = new ArrayList();
        }
        this._removePaths.add(path);
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    public void setSessionCallback(SessionCallback callback) {
        this._sessionCallback = callback;
    }

    public SessionCallback getSessionCallback() {
        return this._sessionCallback;
    }

    public SessionArrayValue getSession() {
        return this._session;
    }

    public HttpSession getJavaSession() {
        return this._javaSession;
    }

    public void setSession(SessionArrayValue session) {
        this._session = session;
        if (session != null) {
            Var var = this.getGlobalVar("_SESSION");
            if (!(var instanceof SessionVar)) {
                var = new SessionVar();
                this.setGlobalValue("_SESSION", var);
            }
            ((Value)var).set(session);
            this.setGlobalValue("HTTP_SESSION_VARS", session);
            session.addUse();
        } else {
            Var v = this.getGlobalVar("_SESSION");
            if (v != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
            if ((v = this.getGlobalVar("HTTP_SESSION_VARS")) != null) {
                ((Value)v).set(UnsetValue.UNSET);
            }
        }
    }

    public String generateSessionId() {
        String sessionId = this._quercus.getQuercusSessionManager().createSessionId(this);
        if (this._javaSession != null) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        return sessionId;
    }

    public SessionArrayValue createSession(String sessionId, boolean create) {
        Value unserialize;
        StringValue value;
        long now = Alarm.getCurrentTime();
        SessionCallback callback = this.getSessionCallback();
        this._javaSession = this._request.getSession(true);
        if (create && this._javaSession.getId().length() >= 3 && sessionId.length() >= 3) {
            sessionId = this._javaSession.getId().substring(0, 3) + sessionId.substring(3);
        }
        SessionArrayValue session = this._quercus.loadSession(this, sessionId);
        if (callback != null && (value = callback.read(this, sessionId)) != null && value.length() != 0 && (unserialize = VariableModule.unserialize(this, value)) instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)unserialize;
            session.reset(now);
            session.putAll(arrayValue);
        }
        this.setSession(session);
        return session;
    }

    public void destroySession(String sessionId) {
        SessionCallback callback = this.getSessionCallback();
        if (callback != null) {
            callback.destroy(this, sessionId);
        } else {
            this._quercus.destroySession(sessionId);
        }
        this.setSession(null);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("quercus.quercus");
        }
        return this._logger;
    }

    public Value getConfigVar(String name) {
        return this.getIniDefinition(name).getValue(this._quercus);
    }

    public IdentityHashMap<String, Value> getIniMap(boolean create) {
        if (this._iniMap == null && create) {
            this._iniMap = new IdentityHashMap();
        }
        return this._iniMap;
    }

    public StringValue setIni(String name, Value value) {
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue setIni(String name, String value) {
        StringValue oldValue = this.getIni(name);
        this.getIniDefinition(name).set(this, value);
        return oldValue;
    }

    public StringValue getIni(String name) {
        return this.getIniDefinition(name).getAsStringValue(this);
    }

    private IniDefinition getIniDefinition(String name) {
        return this._quercus.getIniDefinitions().get(name);
    }

    public boolean getIniBoolean(String name) {
        return this.getIniDefinition(name).getAsBoolean(this);
    }

    public long getIniLong(String name) {
        return this.getIniDefinition(name).getAsLong(this);
    }

    public String getIniString(String name) {
        return this.getIniDefinition(name).getAsString(this);
    }

    public long getIniBytes(String name, long deflt) {
        return this.getIniDefinition(name).getAsLongBytes(this, deflt);
    }

    public ByteToChar getByteToChar() {
        return ByteToChar.create();
    }

    public Value getThis() {
        return this._this;
    }

    public Value setThis(Value value) {
        Value oldThis = this._this;
        this._this = value.toValue();
        return oldThis;
    }

    public Value getValue(String name) {
        Var var = this.getRef(name);
        if (var != null) {
            return var.toValue();
        }
        return NullValue.NULL;
    }

    public <T> T getSpecialValue(String name) {
        return (T)this._specialMap.get(name);
    }

    public Value getGlobalValue(String name) {
        Var var = this.getGlobalRef(name);
        if (var != null) {
            return var.toValue();
        }
        return NullValue.NULL;
    }

    public final Var getVar(String name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        Var var = this._map.get(name);
        if (var != null) {
            return var;
        }
        var = this.getRef(name);
        if (var == null) {
            var = new Var();
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
            this._map.put(name, var);
        }
        return var;
    }

    public final Var getGlobalVar(String name, Value value) {
        if (value != null) {
            return (Var)value;
        }
        Var var = this._globalMap.get(name);
        if (var != null) {
            return var;
        }
        var = this.getSpecialRef(name);
        if (var == null) {
            var = new Var();
            var.setGlobal();
        }
        this._globalMap.put(name, var);
        return var;
    }

    public final String createStaticName() {
        return this._quercus.createStaticName();
    }

    public final Var getStaticVar(String name) {
        Var var = this._staticMap.get(name);
        if (var == null) {
            var = new Var();
            var.setGlobal();
            this._staticMap.put(name, var);
        }
        return var;
    }

    public final Var unsetVar(String name) {
        this._map.remove(name);
        return null;
    }

    public final Var setVar(String name, Value value) {
        Var var;
        if (value instanceof Var) {
            var = (Var)value;
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
        } else {
            var = new Var(value.toValue());
        }
        this._map.put(name, var);
        return var;
    }

    public final Var unsetLocalVar(String name) {
        this._map.remove(name);
        return null;
    }

    public final Var unsetGlobalVar(String name) {
        this._globalMap.remove(name);
        return null;
    }

    public static final Value getLocalVar(Value var) {
        if (var == null) {
            var = new Var();
        }
        return var;
    }

    public static final Value getLocalValue(Value var) {
        if (var != null) {
            return var;
        }
        return NullValue.NULL;
    }

    public static final Value setLocalVar(Value var, Value value) {
        value = value.toValue();
        if (var instanceof Var) {
            var.set(value);
        }
        return value;
    }

    public Var getRef(String name) {
        Var var = this._map.get(name);
        if (var == null && (var = this.getSpecialRef(name)) != null) {
            var.setGlobal();
            this._globalMap.put(name, var);
            var = this._map.get(name);
        }
        return var;
    }

    public Var getGlobalRef(String name) {
        Var var = this._globalMap.get(name);
        if (var == null) {
            var = this.getSpecialRef(name);
            if (var == null) {
                var = new Var();
            }
            this._globalMap.put(name, var);
        }
        return var;
    }

    /*
     * WARNING - void declaration
     */
    public Var getSpecialRef(String name) {
        Var var = null;
        switch (SPECIAL_VARS.get((Object)name)) {
            case 14: {
                var = new Var();
                this._globalMap.put(name, var);
                var.set(new ArrayValueImpl());
                return var;
            }
            case 9: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 3: {
                var = new Var();
                this._globalMap.put(name, var);
                ArrayValueImpl post = new ArrayValueImpl();
                var.set(post);
                if (this._request == null) {
                    return null;
                }
                if (!"POST".equals(this._request.getMethod())) {
                    return var;
                }
                if (this._post == null) break;
                for (Map.Entry<Value, Value> entry : this._post.entrySet()) {
                    ((ArrayValue)post).put(entry.getKey(), entry.getValue());
                }
                break;
            }
            case 13: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 12: {
                var = new Var();
                this._globalMap.put(name, var);
                ArrayValueImpl files = new ArrayValueImpl();
                if (this._files != null) {
                    for (Map.Entry<Value, Value> entry : this._files.entrySet()) {
                        ((ArrayValue)files).put(entry.getKey(), entry.getValue());
                    }
                }
                var.set(files);
                break;
            }
            case 8: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 2: {
                var = new Var();
                ArrayValueImpl array = new ArrayValueImpl();
                var.set(array);
                this._globalMap.put(name, var);
                String queryString = this._request.getQueryString();
                if (queryString == null) {
                    return var;
                }
                StringUtility.parseStr(this, queryString, array, true, this.getHttpInputEncoding().toString());
                return var;
            }
            case 6: {
                void var7_26;
                var = new Var();
                ArrayValueImpl array = new ArrayValueImpl();
                var.set(array);
                this._globalMap.put(name, var);
                if (this._request == null) {
                    return var;
                }
                try {
                    this._request.setCharacterEncoding(this.getHttpInputEncoding().toString());
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                ArrayList keys = new ArrayList();
                keys.addAll(this._request.getParameterMap().keySet());
                Collections.sort(keys);
                boolean isMagicQuotes = this.getIniBoolean("magic_quotes_gpc");
                for (String string : keys) {
                    String[] value = this._request.getParameterValues(string);
                    Post.addFormValue(this, array, string, value, isMagicQuotes);
                }
                if (name.equals("_REQUEST") && this._post != null) {
                    for (Map.Entry entry : this._post.entrySet()) {
                        ((ArrayValue)array).put((Value)entry.getKey(), ((Value)entry.getValue()).copy());
                    }
                }
                Cookie[] cookies = this._request.getCookies();
                boolean bl = false;
                while (cookies != null && var7_26 < cookies.length) {
                    Post.addFormValue(this, array, cookies[var7_26].getName(), new String[]{cookies[var7_26].getValue()}, isMagicQuotes);
                    ++var7_26;
                }
                return var;
            }
            case 15: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 1: {
                var = new Var();
                this._globalMap.put(name, var);
                var.set(new ServerArrayValue(this));
                return var;
            }
            case 5: {
                var = new Var();
                this._globalMap.put(name, var);
                var.set(new GlobalArrayValue(this));
                return var;
            }
            case 10: {
                if (!Quercus.INI_REGISTER_LONG_ARRAYS.getAsBoolean(this)) {
                    return null;
                }
            }
            case 4: {
                var = new Var();
                this._globalMap.put(name, var);
                if (this._request == null) {
                    return var;
                }
                ArrayValueImpl array = new ArrayValueImpl();
                Cookie[] cookies = this._request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        Cookie cookie = cookies[i];
                        String string = Env.decodeValue(cookie.getValue());
                        StringValue valueAsValue = this.createString(string);
                        if (this.getIniBoolean("magic_quotes_gpc")) {
                            valueAsValue = StringModule.addslashes(valueAsValue);
                        }
                        array.append(this.createString(cookie.getName()), valueAsValue);
                    }
                }
                var.set(array);
                return var;
            }
            case 11: {
                var = new Var();
                this._globalMap.put(name, var);
                var.set(this.getGlobalVar("_SERVER").get(PHP_SELF_STRING));
                return var;
            }
            default: {
                Bindings bindings;
                if (this._scriptContext == null) break;
                Object value = this._scriptContext.getAttribute(name);
                if (value == null && (bindings = this._scriptContext.getBindings(100)) != null) {
                    value = bindings.get(name);
                }
                if (value == null && (bindings = this._scriptContext.getBindings(200)) != null) {
                    value = bindings.get(name);
                }
                if (value == null) break;
                var = new Var();
                this._globalMap.put(name, var);
                var.set(this.wrapJava(value));
                return var;
            }
        }
        return var;
    }

    private static String decodeValue(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public Var getVar(String name) {
        Var var = this._map.get(name);
        if (var != null) {
            return var;
        }
        var = this.getRef(name);
        if (var == null) {
            var = new Var();
            if (this._map == this._globalMap) {
                var.setGlobal();
            }
            this._map.put(name, var);
        }
        return var;
    }

    public Var getGlobalVar(String name) {
        Var var = this.getGlobalRef(name);
        if (var == null) {
            var = new Var();
            var.setGlobal();
            this._globalMap.put(name, var);
        }
        return var;
    }

    public boolean isGlobalEnv() {
        return this._map == this._globalMap;
    }

    public Value setValue(String name, Value value) {
        if (value instanceof Var) {
            this._map.put(name, (Var)value);
        } else {
            Var var = this.getVar(name);
            var.set(value);
        }
        return value;
    }

    public Object setSpecialValue(String name, Object value) {
        this._specialMap.put(name, value);
        return value;
    }

    public Value setGlobalValue(String name, Value value) {
        if (value instanceof Var) {
            this._globalMap.put(name, (Var)value);
        } else {
            Var var = this.getGlobalVar(name);
            var.set(value);
        }
        return value;
    }

    public Value getStaticClassFieldValue(String className, String name) {
        Var var = this.getStaticClassFieldVar(className, name);
        if (var != null) {
            Value val = var.toValue();
            return val;
        }
        return NullValue.NULL;
    }

    public final Var getStaticClassFieldVar(String className, String name) {
        QuercusClass cl = this.findAbstractClass(className);
        Var var = cl.getStaticField(name);
        if (var == null) {
            this.error(L.l("{0}::${1} is an undeclared static property", (Object)className, (Object)name));
        }
        return var;
    }

    public void pushCall(Expr call, Value obj) {
        if (this._callStack.length <= this._callStackTop) {
            Expr[] newStack = new Expr[2 * this._callStack.length];
            System.arraycopy(this._callStack, 0, newStack, 0, this._callStack.length);
            this._callStack = newStack;
            Value[] newThisStack = new Value[2 * this._callThisStack.length];
            System.arraycopy(this._callThisStack, 0, newThisStack, 0, this._callThisStack.length);
            this._callThisStack = newThisStack;
        }
        this._callStack[this._callStackTop] = call;
        this._callThisStack[this._callStackTop] = obj;
        ++this._callStackTop;
    }

    public Expr popCall() {
        return this._callStack[--this._callStackTop];
    }

    public int getCallDepth() {
        return this._callStackTop;
    }

    public Expr peekCall(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public Value peekCallThis(int depth) {
        if (this._callStackTop - depth > 0) {
            return this._callThisStack[this._callStackTop - depth - 1];
        }
        return null;
    }

    public HashMap<String, Var> pushEnv(HashMap<String, Var> map) {
        HashMap<String, Var> oldEnv = this._map;
        this._map = map;
        return oldEnv;
    }

    public void popEnv(HashMap<String, Var> oldEnv) {
        this._map = oldEnv;
    }

    public HashMap<String, Var> getEnv() {
        return this._map;
    }

    public HashMap<String, Var> getGlobalEnv() {
        return this._globalMap;
    }

    public final Value[] setFunctionArgs(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        Value[] newArgs = new Value[args.length];
        for (int i = 0; args != null && i < args.length; ++i) {
            newArgs[i] = args[i].toValue().toArgValue();
        }
        this._functionArgs = newArgs;
        return oldArgs;
    }

    public final Value[] setFunctionArgsNoCopy(Value[] args) {
        Value[] oldArgs = this._functionArgs;
        for (int i = 0; args != null && i < args.length; ++i) {
            args[i] = args[i].toValue();
        }
        this._functionArgs = args;
        return oldArgs;
    }

    public final void restoreFunctionArgs(Value[] args) {
        this._functionArgs = args;
    }

    public final Value[] getFunctionArgs() {
        return this._functionArgs;
    }

    public Object removeSpecialValue(String name) {
        return this._specialMap.remove(name);
    }

    public Value getConstant(String name) {
        Value value = this.getConstantImpl(name);
        if (value != null) {
            return value;
        }
        value = this.createString(name);
        return value;
    }

    public boolean isDefined(String name) {
        return this.getConstantImpl(name) != null;
    }

    private Value getConstantImpl(String name) {
        Value value = this._constMap.get(name);
        if (value != null) {
            return value;
        }
        value = this._quercus.getConstant(name);
        if (value != null) {
            return value;
        }
        if (this._lowerConstMap != null && (value = this._lowerConstMap.get(name.toLowerCase())) != null) {
            return value;
        }
        return null;
    }

    public Value removeConstant(String name) {
        return this._constMap.remove(name);
    }

    public Value addConstant(String name, Value value, boolean isCaseInsensitive) {
        Value oldValue = this._constMap.get(name);
        if (oldValue != null) {
            return oldValue;
        }
        this._constMap.put(name, value);
        if (this._lowerConstMap != null && isCaseInsensitive) {
            this._lowerConstMap.put(name.toLowerCase(), value);
        }
        return value;
    }

    public ArrayValue getDefinedConstants() {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Map.Entry<String, Value> entry : this._quercus.getConstMap().entrySet()) {
            ((ArrayValue)result).put(this.createString(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, Value> entry : this._constMap.entrySet()) {
            ((ArrayValue)result).put(this.createString(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public boolean isExtensionLoaded(String name) {
        return this.getQuercus().isExtensionLoaded(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this.getQuercus().getLoadedExtensions();
    }

    public Value getExtensionFuncs(String name) {
        return this.getQuercus().getExtensionFuncs(name);
    }

    public StreamContextResource getDefaultStreamContext() {
        if (this._defaultStreamContext == null) {
            this._defaultStreamContext = new StreamContextResource();
        }
        return this._defaultStreamContext;
    }

    public ArrayValue getDefinedFunctions() {
        return this._defState.getDefinedFunctions();
    }

    public AbstractFunction findFunction(String name) {
        return this._defState.findFunction(name);
    }

    public AbstractFunction getFunction(String name) {
        AbstractFunction fun = this._defState.findFunction(name);
        if (fun != null) {
            return fun;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown function", (Object)name));
    }

    public AbstractFunction getFunction(Value name) {
        if ((name = name.toValue()) instanceof CallbackFunction) {
            return ((CallbackFunction)name).getFunction();
        }
        AbstractFunction fun = this._defState.findFunction(name.toString());
        if (fun != null) {
            return fun;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown function.", (Object)name));
    }

    public DefinitionState getDefinitionState() {
        return this._defState;
    }

    public Value addFunction(String name, AbstractFunction fun) {
        return this._defState.addFunction(name, fun);
    }

    public Value addFunctionFromPage(String name, String lowerName, AbstractFunction fun) {
        return BooleanValue.TRUE;
    }

    public AbstractFunction findMethod(String className, String methodName) {
        QuercusClass cl = this.findClass(className);
        if (cl == null) {
            this.error(L.l("'{0}' is an unknown class.", (Object)className));
            return null;
        }
        AbstractFunction fun = cl.findFunction(methodName);
        if (fun == null && !this.isStrict()) {
            fun = cl.findFunctionLowerCase(methodName.toLowerCase());
        }
        if (fun == null) {
            this.error(L.l("'{0}::{1}' is an unknown method.", (Object)className, (Object)methodName));
            return null;
        }
        return fun;
    }

    public Value evalCode(String code) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(code);
        }
        Quercus quercus = this.getQuercus();
        QuercusProgram program = quercus.parseEvalExpr(code);
        Value value = program.execute(this);
        return value;
    }

    public Value call(String name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this);
    }

    public Value call(String name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.call(this, a0);
    }

    public Value call(String name, Value a0, Value a1) {
        return this.getFunction(name).call(this, a0, a1);
    }

    public Value call(String name, Value a0, Value a1, Value a2) {
        return this.getFunction(name).call(this, a0, a1, a2);
    }

    public Value call(String name, Value a0, Value a1, Value a2, Value a3) {
        return this.getFunction(name).call(this, a0, a1, a2, a3);
    }

    public Value call(String name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this.getFunction(name).call(this, a0, a1, a2, a3, a4);
    }

    public Value call(String name, Value[] args) {
        return this.getFunction(name).call(this, args);
    }

    public Value callRef(String name) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this);
    }

    public Value callRef(String name, Value a0) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0);
    }

    public Value callRef(String name, Value a0, Value a1) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3);
    }

    public Value callRef(String name, Value a0, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, a0, a1, a2, a3, a4);
    }

    public Value callRef(String name, Value[] args) {
        AbstractFunction fun = this.findFunction(name);
        if (fun == null) {
            return this.error(L.l("'{0}' is an unknown function.", (Object)name));
        }
        return fun.callRef(this, args);
    }

    public void addClassDef(String name, ClassDef cl) {
        this._defState.addClassDef(name, cl);
    }

    public ClassDef findClassDef(String name) {
        return this._defState.findClassDef(name);
    }

    public ObjectValue createObject() {
        try {
            return this._quercus.getStdClass().newInstance(this);
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue createEmptyString() {
        if (this._isUnicodeSemantics) {
            return UnicodeBuilderValue.EMPTY;
        }
        return StringBuilderValue.EMPTY;
    }

    public StringValue createString(byte[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeValueImpl(new String(buffer, offset, length));
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createString(char[] buffer, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, length);
        }
        return new StringBuilderValue(buffer, 0, length);
    }

    public StringValue createString(char[] buffer, int offset, int length) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(buffer, offset, length);
        }
        return new StringBuilderValue(buffer, offset, length);
    }

    public StringValue createString(String s) {
        if (s == null) {
            return this._isUnicodeSemantics ? UnicodeBuilderValue.EMPTY : StringBuilderValue.EMPTY;
        }
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(s);
        }
        return new StringBuilderValue(s);
    }

    public StringValue createString(char ch) {
        if (this._isUnicodeSemantics) {
            return new UnicodeValueImpl(String.valueOf(ch));
        }
        return new StringBuilderValue(String.valueOf(ch));
    }

    public StringValue createBinaryString(TempBuffer head) {
        StringValue string = this._isUnicodeSemantics ? new BinaryBuilderValue() : new StringBuilderValue();
        while (head != null) {
            string.append(head.getBuffer(), 0, head.getLength());
            head = head.getNext();
        }
        return string;
    }

    public Value createException(Exception e) {
        QuercusClass cls = this.findClass("Exception");
        StringValue message = this.createString(e.getMessage());
        Value[] args = new Value[]{message};
        Value value = cls.callNew(this, args);
        StackTraceElement elt = e.getStackTrace()[0];
        value.putField(this, "file", this.createString(elt.getFileName()));
        value.putField(this, "line", LongValue.create(elt.getLineNumber()));
        value.putField(this, "trace", ErrorModule.debug_backtrace(this));
        return value;
    }

    public int generateId() {
        return ++this._objectId;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        JavaClassDef def = this.getJavaClassDefinition(className, true);
        if (def != null) {
            return def;
        }
        throw this.createErrorException(L.l("'{0}' class definition not found", (Object)className));
    }

    public JavaClassDef getJavaClassDefinition(Class type) {
        JavaClassDef def = this._quercus.getJavaClassDefinition(type, type.getName());
        def.init();
        return def;
    }

    private JavaClassDef getJavaClassDefinition(String className, boolean useImport) {
        JavaClassDef def = null;
        try {
            def = this._quercus.getJavaClassDefinition(className);
        }
        catch (Throwable e) {
            if (useImport) {
                def = this.importJavaClass(className);
            }
            log.log(Level.FINER, e.toString(), e);
        }
        if (def != null) {
            def.init();
        }
        return def;
    }

    public JavaClassDef importJavaClass(String className) {
        if (this._importMap == null) {
            return null;
        }
        String fullName = this._importMap.getQualified(className);
        if (fullName != null) {
            return this.getJavaClassDefinition(fullName, false);
        }
        ArrayList<String> wildcardList = this._importMap.getWildcardList();
        for (String entry : wildcardList) {
            fullName = entry + '.' + className;
            JavaClassDef def = this.getJavaClassDefinition(fullName, false);
            if (def == null) continue;
            this._importMap.putQualified(className, fullName);
            return def;
        }
        return null;
    }

    public void putQualifiedImport(String javaName) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        String phpName = this._importMap.putQualified(javaName);
    }

    public void addWildcardImport(String name) {
        if (this._importMap == null) {
            this._importMap = new ImportMap();
        }
        this._importMap.addWildcardImport(name);
    }

    public Value wrapJava(Object obj) {
        return this.wrapJava(obj, null, false);
    }

    public Value wrapJava(Object obj, boolean isNullAsFalse) {
        return this.wrapJava(obj, null, isNullAsFalse);
    }

    public Value wrapJava(Object obj, JavaClassDef def, boolean isNullAsFalse) {
        if (obj == null) {
            if (isNullAsFalse) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (def == null) {
            def = this.getJavaClassDefinition(obj.getClass());
        } else if (def.getType() != obj.getClass()) {
            def = this.getJavaClassDefinition(obj.getClass());
        }
        if (def.isArray()) {
            ArrayValueImpl arrayValueImpl = new ArrayValueImpl();
            Class<?> componentClass = def.getType().getComponentType();
            MarshalFactory factory = this._quercus.getModuleContext().getMarshalFactory();
            Marshal componentClassMarshal = factory.create(componentClass);
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                arrayValueImpl.put(componentClassMarshal.unmarshal(this, Array.get(obj, i)));
            }
            return arrayValueImpl;
        }
        return def.wrap(this, obj);
    }

    public QuercusClass findClass(String name) {
        return this.findClass(name, true);
    }

    public QuercusClass findClass(String name, boolean useAutoload) {
        QuercusClass cl = this._classMap.get(name);
        if (cl != null) {
            return cl;
        }
        cl = this._lowerClassMap.get(name.toLowerCase());
        if (cl != null) {
            return cl;
        }
        cl = this.createClassImpl(name, useAutoload, true);
        if (cl != null) {
            this._classMap.put(cl.getName(), cl);
            this._lowerClassMap.put(cl.getName().toLowerCase(), cl);
            cl.init(this);
            return cl;
        }
        return null;
    }

    private QuercusClass createClassImpl(String name, boolean useAutoload, boolean useImport) {
        ClassDef classDef = this._defState.findClassDef(name);
        if (classDef != null) {
            String parentName = classDef.getParentName();
            QuercusClass parent = null;
            if (parentName != null) {
                parent = this.findClass(parentName);
            }
            if (parentName == null || parent instanceof QuercusClass) {
                return this.createQuercusClass(classDef, parent);
            }
            return null;
        }
        ClassDef staticClass = this._quercus.findClass(name);
        if (staticClass != null) {
            return this.createQuercusClass(staticClass, null);
        }
        if (useAutoload) {
            if (this._autoload == null) {
                this._autoload = this.findFunction("__autoload");
            }
            if (this._autoload != null) {
                this._autoload.call(this, new StringBuilderValue(name));
                return this.createClassImpl(name, false, useImport);
            }
        }
        if (useImport) {
            if (this.importPhpClass(name)) {
                return this.createClassImpl(name, false, false);
            }
            try {
                JavaClassDef javaClassDef = this.getJavaClassDefinition(name, true);
                if (javaClassDef != null) {
                    return this.createQuercusClass(javaClassDef, null);
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    public boolean importPhpClass(String name) {
        if (this._importMap == null) {
            return false;
        }
        String fullName = this._importMap.getQualifiedPhp(name);
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (fullName != null) {
            url = loader.getResource(fullName);
        } else {
            String entry;
            Iterator<String> i$ = this._importMap.getWildcardPhpList().iterator();
            while (i$.hasNext() && (url = loader.getResource((entry = i$.next()) + '/' + name + ".php")) == null) {
            }
        }
        if (url != null) {
            this.include_once(url.toString());
            return true;
        }
        return false;
    }

    public Value getDeclaredClasses() {
        return this._defState.getDeclaredClasses(this);
    }

    public QuercusClass findAbstractClass(String name) {
        QuercusClass cl = this.findClass(name, true);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class name.", (Object)name));
    }

    public QuercusClass getClass(String name) {
        QuercusClass cl = this.findClass(name);
        if (cl != null) {
            return cl;
        }
        throw this.createErrorException(L.l("'{0}' is an unknown class.", (Object)name));
    }

    QuercusClass createQuercusClass(ClassDef def, QuercusClass parent) {
        QuercusClass qClass;
        ClassKey key = new ClassKey(def, parent);
        SoftReference qClassRef = (SoftReference)_classCache.get((Object)key);
        if (qClassRef != null && (qClass = (QuercusClass)qClassRef.get()) != null) {
            return qClass;
        }
        qClass = new QuercusClass(this.getModuleContext(), def, parent);
        qClass.validate(this);
        _classCache.put((Object)key, new SoftReference<QuercusClass>(qClass));
        return qClass;
    }

    public boolean isInitializedClass(String name) {
        return this._initializedClassSet.contains(name);
    }

    public void addInitializedClass(String name) {
        this._initializedClassSet.add(name);
    }

    public AbstractFunction findFunction(String className, String methodName) {
        QuercusClass cl = this.findClass(className);
        if (cl == null) {
            throw new QuercusRuntimeException(L.l("'{0}' is an unknown class", (Object)className));
        }
        return cl.findFunction(methodName);
    }

    public Callback createCallback(Value value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if ((value = value.toValue()) instanceof Callback) {
            return (Callback)value;
        }
        if (value instanceof StringValue) {
            return new CallbackFunction(this, value.toString());
        }
        if (value instanceof ArrayValue) {
            Value obj = value.get(LongValue.ZERO);
            Value name = value.get(LongValue.ONE);
            if (!(name instanceof StringValue)) {
                throw new IllegalStateException(L.l("unknown callback name {0}", (Object)name));
            }
            if (obj instanceof StringValue) {
                QuercusClass cl = this.findClass(obj.toString());
                if (cl == null) {
                    throw new IllegalStateException(L.l("can't find class {0}", (Object)obj.toString()));
                }
                return new CallbackFunction(cl.getFunction(name.toString()));
            }
            return new CallbackObjectMethod(this, obj, name.toString());
        }
        return null;
    }

    public Value require_once(String include) {
        return this.include(this.getSelfDirectory(), include, true, true);
    }

    public Value require(String include) {
        return this.include(this.getSelfDirectory(), include, true, false);
    }

    public Value include(String include) {
        return this.include(this.getSelfDirectory(), include, false, false);
    }

    public Value include_once(String include) {
        return this.include(this.getSelfDirectory(), include, false, true);
    }

    public Value include(Path scriptPwd, String include, boolean isRequire, boolean isOnce) {
        try {
            Path pwd = this.getPwd();
            Path path = this.lookupInclude(include, pwd, scriptPwd);
            if (path == null) {
                if (isRequire) {
                    this.error(L.l("'{0}' is not a valid path", (Object)include));
                    return NullValue.NULL;
                }
                this.warning(L.l("'{0}' is not a valid path", (Object)include));
                return NullValue.NULL;
            }
            if (isOnce && this._includeSet.contains(path)) {
                return NullValue.NULL;
            }
            this._includeSet.add(path);
            QuercusPage page = this._quercus.parse(path);
            this.importPage(page);
            return page.execute(this);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private void importPage(QuercusPage page) {
        long crc = this._defState.getCrc();
        DefinitionKey key = new DefinitionKey(crc, page);
        DefinitionState defState = this._quercus.getDefinitionCache(key);
        if (defState != null) {
            this._defState = defState;
        } else {
            page.importDefinitions(this);
            this._quercus.putDefinitionCache(key, this._defState);
        }
    }

    public Path lookupPwd(Value relPathV) {
        if (!relPathV.isset()) {
            return null;
        }
        StringValue relPath = relPathV.toStringValue();
        if (relPath.length() == 0) {
            return null;
        }
        Path path = this._lookupCache.get(relPath);
        if (path == null) {
            path = this.getPwd().lookup(relPath.toString());
            this._lookupCache.put(relPath, path);
        }
        return path;
    }

    public Path lookup(String relPath) {
        return this.lookupInclude(this.getSelfDirectory(), relPath);
    }

    public Path lookupInclude(String relPath) {
        return this.lookupInclude(relPath, this.getPwd(), this.getSelfDirectory());
    }

    private Path lookupInclude(String include, Path pwd, Path scriptPwd) {
        Path path;
        String includePath = Quercus.INI_INCLUDE_PATH.getAsString(this);
        if (includePath == null) {
            includePath = ".";
        }
        if ((path = this._quercus.getIncludeCache(include, includePath, pwd, scriptPwd)) == null && (path = this.lookupIncludeImpl(include, pwd, scriptPwd)) != null) {
            this._quercus.putIncludeCache(include, includePath, pwd, scriptPwd, path);
        }
        return path;
    }

    private Path lookupIncludeImpl(String include, Path pwd, Path scriptPwd) {
        Path path = this.lookupInclude(pwd, include);
        if (path == null) {
            path = this.lookupInclude(scriptPwd, include);
        }
        if (path == null && (!(path = scriptPwd.lookup(include)).canRead() || path.isDirectory())) {
            path = null;
        }
        return path;
    }

    private Path lookupInclude(Path pwd, String relPath) {
        ArrayList<Path> pathList = this.getIncludePath(pwd);
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i).lookup(relPath);
            if (!path.canRead() || path.isDirectory()) continue;
            return path;
        }
        return null;
    }

    private ArrayList<Path> getIncludePath(Path pwd) {
        ArrayList<Object> pathList;
        String includePath = Quercus.INI_INCLUDE_PATH.getAsString(this);
        if (includePath == null) {
            includePath = ".";
        }
        if (!includePath.equals(this._includePath)) {
            String subpath;
            int tail;
            this._includePathList = new ArrayList();
            this._includePathMap = new HashMap();
            int head = 0;
            String pathSeparator = FileModule.PATH_SEPARATOR;
            int length = pathSeparator.length();
            while ((tail = includePath.indexOf(pathSeparator, head)) >= 0) {
                subpath = includePath.substring(head, tail);
                this._includePathList.add(subpath);
                head = tail + length;
            }
            subpath = includePath.substring(head);
            this._includePathList.add(subpath);
            this._includePath = includePath;
        }
        if ((pathList = this._includePathMap.get(pwd)) == null) {
            pathList = new ArrayList();
            for (int i = 0; i < this._includePathList.size(); ++i) {
                pathList.add(pwd.lookup(this._includePathList.get(i)));
            }
            this._includePathMap.put(pwd, pathList);
        }
        return pathList;
    }

    public String setIncludePath(String path) {
        this._prevIncludePath = Quercus.INI_INCLUDE_PATH.getAsString(this);
        if (this._prevIncludePath == null) {
            this._prevIncludePath = "";
        }
        Quercus.INI_INCLUDE_PATH.set(this, path);
        return this._prevIncludePath;
    }

    public void restoreIncludePath() {
        String path = Quercus.INI_INCLUDE_PATH.getAsString(this);
        Quercus.INI_INCLUDE_PATH.set(this, this._prevIncludePath);
        this._prevIncludePath = path;
    }

    public ArrayValue getIncludedFiles() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Path path : this._includeSet) {
            array.put(path.toString());
        }
        return array;
    }

    public Value suppress(int errorMask, Value value) {
        this.setErrorMask(errorMask);
        return value;
    }

    public Value exit(Value msg) {
        if (msg.isNull() || msg instanceof LongValue) {
            return this.exit();
        }
        try {
            this.getOut().print(msg.toString());
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusExitException(msg.toString());
    }

    public Value exit() {
        throw new QuercusExitException();
    }

    public Value die(String msg) {
        try {
            this.getOut().print(msg);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        throw new QuercusDieException(msg);
    }

    public Value die() {
        throw new QuercusDieException();
    }

    public Value cast(Class cl, Value value) {
        if ((value = value.toValue()).isNull()) {
            return null;
        }
        if (cl.isAssignableFrom(value.getClass())) {
            return value;
        }
        this.error(L.l("{0} ({1}) is not assignable to {2}", (Object)value, (Object)value.getClass().getName(), (Object)cl.getName()));
        return value;
    }

    public static Value first(Value value) {
        return value;
    }

    public static Value first(Value value, Value a1) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4) {
        return value;
    }

    public static Value first(Value value, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return value;
    }

    public Value error(String msg) {
        return this.error(0, "", msg + this.getFunctionLocation());
    }

    public Value error(Location location, String msg) {
        return this.error(0, location, msg + this.getFunctionLocation());
    }

    public Value error(String loc, String msg) {
        return this.error(0, loc, msg + this.getFunctionLocation());
    }

    public Value error(String msg, Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(msg);
    }

    public Value error(Throwable e) {
        log.log(Level.WARNING, e.toString(), e);
        return this.error(e.toString());
    }

    public QuercusRuntimeException createErrorException(String msg) throws QuercusRuntimeException {
        return this.createErrorException(null, msg);
    }

    public QuercusRuntimeException createErrorException(Location location, String msg) throws QuercusRuntimeException {
        if (location == null) {
            location = this.getLocation();
        }
        String prefix = location.getMessagePrefix();
        String fullMsg = msg + this.getFunctionLocation();
        this.error(0, location, fullMsg);
        String exMsg = prefix + fullMsg;
        return new QuercusRuntimeException(fullMsg);
    }

    public Value warning(String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, "", msg + this.getFunctionLocation());
    }

    public Value warning(Location location, String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(1, location, "", msg + this.getFunctionLocation());
    }

    public Value warning(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(msg);
    }

    public Value warning(Location location, String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.warning(location, msg);
    }

    public Value warning(Throwable e) {
        return this.warning(e.toString(), e);
    }

    public Value warning(Location location, Throwable e) {
        return this.warning(location, e.toString(), e);
    }

    public Value strict(String msg) {
        if (log.isLoggable(Level.FINER)) {
            QuercusException e = new QuercusException(msg);
            log.log(Level.FINER, e.toString(), e);
        }
        return this.error(11, "", msg + this.getFunctionLocation());
    }

    public Value invalidArgument(String name, Object value) {
        return this.warning(L.l("invalid value `{0}' for `{1}'", value, (Object)name));
    }

    public Value deprecatedArgument(String name) {
        return this.strict(L.l("argument `{1}' is deprecated", (Object)name));
    }

    public Value notice(String msg) {
        return this.error(3, "", msg + this.getFunctionLocation());
    }

    public Value notice(String msg, Throwable e) {
        log.log(Level.FINE, e.toString(), e);
        return this.notice(msg);
    }

    public Value stub(String msg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getLocation().getMessagePrefix() + msg);
        }
        return NullValue.NULL;
    }

    public static Value nullAsFalse(Value value) {
        return value == null || value.isNull() ? BooleanValue.FALSE : value;
    }

    public Value parse(String msg) throws Exception {
        return this.error(2, "", msg);
    }

    public Value compileError(String msg) {
        return this.error(6, "", msg);
    }

    public Value compileWarning(String msg) {
        return this.error(7, "", msg);
    }

    public int getErrorMask() {
        return this._errorMask;
    }

    public int setErrorMask(int mask) {
        int oldMask = this._errorMask;
        this._errorMask = mask;
        return oldMask;
    }

    public void setErrorHandler(int mask, Callback fun) {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._prevErrorHandlers[i] = this._errorHandlers[i];
        }
        if ((mask & 1) != 0) {
            this._errorHandlers[0] = fun;
        }
        if ((mask & 2) != 0) {
            this._errorHandlers[1] = fun;
        }
        if ((mask & 4) != 0) {
            this._errorHandlers[2] = fun;
        }
        if ((mask & 8) != 0) {
            this._errorHandlers[3] = fun;
        }
        if ((mask & 0x100) != 0) {
            this._errorHandlers[8] = fun;
        }
        if ((mask & 0x200) != 0) {
            this._errorHandlers[9] = fun;
        }
        if ((mask & 0x400) != 0) {
            this._errorHandlers[10] = fun;
        }
        if ((mask & 0x800) != 0) {
            this._errorHandlers[11] = fun;
        }
    }

    public void restoreErrorHandler() {
        for (int i = 0; i < this._errorHandlers.length; ++i) {
            this._errorHandlers[i] = this._prevErrorHandlers[i];
        }
    }

    public Callback getExceptionHandler() {
        return this._exceptionHandler;
    }

    public Value setExceptionHandler(Callback fun) {
        this._prevExceptionHandler = this._exceptionHandler;
        this._exceptionHandler = fun;
        if (this._prevExceptionHandler != null) {
            return this._prevExceptionHandler.toStringValue();
        }
        return NullValue.NULL;
    }

    public void restoreExceptionHandler() {
        this._exceptionHandler = this._prevExceptionHandler;
    }

    public Value error(int code, String locString, String msg) {
        return this.error(code, null, locString, msg);
    }

    public Value error(int code, Location location, String msg) {
        return this.error(code, location, "", msg);
    }

    public Value error(int code, Location location, String loc, String msg) {
        int mask = 1 << code;
        if (location == null) {
            location = this.getLocation();
        }
        String locationMessagePrefix = loc;
        if (loc.equals("")) {
            locationMessagePrefix = location.getMessagePrefix();
        }
        if (code >= 0 && code < this._errorHandlers.length && this._errorHandlers[code] != null) {
            Callback handler = this._errorHandlers[code];
            try {
                this._errorHandlers[code] = null;
                Value fileNameV = NullValue.NULL;
                String fileName = location.getFileName();
                if (fileName != null) {
                    fileNameV = this.createString(fileName);
                }
                Value lineV = NullValue.NULL;
                int line = location.getLineNumber();
                if (line > 0) {
                    lineV = new LongValue(line);
                }
                NullValue context = NullValue.NULL;
                handler.call(this, new LongValue(mask), (Value)this.createString(msg), fileNameV, lineV, (Value)context);
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                this._errorHandlers[code] = handler;
            }
        }
        if ((this._errorMask & mask) != 0) {
            try {
                String fullMsg = locationMessagePrefix + this.getCodeName(mask) + msg;
                if (this.getIniBoolean("track_errors")) {
                    this.setGlobalValue("php_errormsg", this.createString(fullMsg));
                }
                if (this.getIniBoolean("display_errors")) {
                    this.getOut().println(fullMsg);
                }
                if (this.getIniBoolean("log_errors")) {
                    log.info(fullMsg);
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if ((mask & 0x151) != 0) {
            if (!"".equals(locationMessagePrefix)) {
                throw new QuercusErrorException(locationMessagePrefix + this.getCodeName(mask) + msg);
            }
            throw new QuercusErrorException(msg);
        }
        return NullValue.NULL;
    }

    private String getCodeName(int code) {
        switch (code) {
            case 1: {
                return "Fatal Error: ";
            }
            case 2: {
                return "Warning: ";
            }
            case 4: {
                return "Parse Error: ";
            }
            case 8: {
                return "Notice: ";
            }
            case 16: {
                return "Fatal Error: ";
            }
            case 32: {
                return "Warning: ";
            }
            case 64: {
                return "Fatal Error: ";
            }
            case 128: {
                return "Warning : ";
            }
            case 256: {
                return "Fatal Error: ";
            }
            case 512: {
                return "Warning: ";
            }
            case 1024: {
                return "Notice: ";
            }
            case 2048: {
                return "Notice: ";
            }
        }
        return String.valueOf("ErrorCode(" + code + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSourceLine(Path path, int sourceLine, int length) {
        if (path == null) {
            return null;
        }
        ReadStream is = null;
        try {
            int ch;
            is = path.openRead();
            boolean hasCr = false;
            int line = 1;
            while (line < sourceLine) {
                ch = is.read();
                if (ch < 0) {
                    String[] stringArray = null;
                    return stringArray;
                }
                if (ch == 13) {
                    hasCr = true;
                    ++line;
                    continue;
                }
                if (ch == 10) {
                    if (!hasCr) {
                        ++line;
                    }
                    hasCr = false;
                    continue;
                }
                hasCr = false;
            }
            String[] result = new String[length];
            int i = 0;
            StringBuilder sb = new StringBuilder();
            while (i < length && (ch = is.read()) > 0) {
                if (ch == 10 && hasCr) {
                    hasCr = false;
                    continue;
                }
                if (ch == 13) {
                    hasCr = true;
                    result[i++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                if (ch == 10) {
                    hasCr = false;
                    result[i++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                hasCr = false;
                sb.append((char)ch);
            }
            if (i < length) {
                result[i] = sb.toString();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return null;
    }

    public Location getLocation() {
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getLocation();
        }
        return Location.UNKNOWN;
    }

    public int getSourceLine(String className, int javaLine) {
        return javaLine;
    }

    public String getFunctionLocation() {
        Expr call = this.peekCall(0);
        if (call != null) {
            return call.getFunctionLocation();
        }
        return "";
    }

    public static Value toValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static Value toValue(long value) {
        return new LongValue(value);
    }

    public static Var toVar(Value value) {
        if (value instanceof Var) {
            return (Var)value;
        }
        if (value == null) {
            return new Var();
        }
        return new Var(value);
    }

    public static Value setFieldVar(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        if (oldValue instanceof Var) {
            return new Var(value);
        }
        return value;
    }

    public static Value setRef(Value oldValue, Value value) {
        if (value instanceof Var) {
            return value;
        }
        return new Var(value);
    }

    public static Value comma(Value a0, Value a1) {
        return a1;
    }

    public static Value comma(Value a0, Value a1, Value a2) {
        return a2;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3) {
        return a3;
    }

    public static Value comma(Value a0, Value a1, Value a2, Value a3, Value a4) {
        return a4;
    }

    public String toString() {
        return "Env[]";
    }

    public Value ifNull(Value condition, Value ifNull, Value ifNotNull) {
        return condition.isNull() ? ifNull : ifNotNull;
    }

    public LocaleInfo getLocaleInfo() {
        if (this._locale == null) {
            this._locale = new LocaleInfo();
        }
        return this._locale;
    }

    public void addShutdown(Callback callback, Value[] args) {
        this._shutdownList.add(new Shutdown(callback, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block19: {
            Throwable e32;
            while (this._outputBuffer != null) {
                this.popOutputBuffer();
            }
            Object var2_1 = null;
            try {
                for (int i = 0; i < this._shutdownList.size(); ++i) {
                    this._shutdownList.get(i).call(this);
                }
            }
            catch (Throwable e2) {
                log.log(Level.FINE, e2.toString(), e2);
            }
            this.sessionWriteClose();
            ArrayList<SoftReference<Closeable>> closeList = new ArrayList<SoftReference<Closeable>>(this._closeList);
            for (SoftReference<Closeable> ref : closeList) {
                try {
                    Closeable close = ref.get();
                    if (close == null) continue;
                    close.close();
                }
                catch (Throwable e32) {
                    log.log(Level.FINER, e32.toString(), e32);
                }
            }
            for (int i = 0; this._removePaths != null && i < this._removePaths.size(); ++i) {
                Path path = this._removePaths.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (IOException e32) {
                    log.log(Level.FINER, e32.toString(), e32);
                }
            }
            break block19;
            catch (Throwable throwable) {
                Throwable e32;
                Object var2_2 = null;
                try {
                    for (int i = 0; i < this._shutdownList.size(); ++i) {
                        this._shutdownList.get(i).call(this);
                    }
                }
                catch (Throwable e2) {
                    log.log(Level.FINE, e2.toString(), e2);
                }
                this.sessionWriteClose();
                closeList = new ArrayList<SoftReference<Closeable>>(this._closeList);
                for (SoftReference<Closeable> ref : closeList) {
                    try {
                        Closeable close = ref.get();
                        if (close == null) continue;
                        close.close();
                    }
                    catch (Throwable e32) {
                        log.log(Level.FINER, e32.toString(), e32);
                    }
                }
                for (int i = 0; this._removePaths != null && i < this._removePaths.size(); ++i) {
                    Path path = this._removePaths.get(i);
                    try {
                        path.remove();
                        continue;
                    }
                    catch (IOException e32) {
                        log.log(Level.FINER, e32.toString(), e32);
                    }
                }
                throw throwable;
            }
        }
    }

    public void sessionWriteClose() {
        SessionArrayValue session = this._session;
        this._session = null;
        if (session != null) {
            SessionCallback callback = this.getSessionCallback();
            if (callback != null) {
                String value = session.getSize() > 0 ? VariableModule.serialize(session.getArray()) : "";
                callback.write(this, session.getId(), value);
                callback.close(this);
            } else {
                this._quercus.saveSession(this, session);
                this.setGlobalValue("_SESSION", session.copy(this));
                this.setGlobalValue("HTTP_SESSION_VARS", session.copy(this));
            }
            _threadEnv.set(this._oldThreadEnv);
        }
    }

    static {
        SPECIAL_VARS.put((Object)"GLOBALS", 5);
        SPECIAL_VARS.put((Object)"_SERVER", 1);
        SPECIAL_VARS.put((Object)"_GET", 2);
        SPECIAL_VARS.put((Object)"_POST", 3);
        SPECIAL_VARS.put((Object)"_FILES", 12);
        SPECIAL_VARS.put((Object)"_REQUEST", 6);
        SPECIAL_VARS.put((Object)"_COOKIE", 4);
        SPECIAL_VARS.put((Object)"_SESSION", 7);
        SPECIAL_VARS.put((Object)"_ENV", 14);
        SPECIAL_VARS.put((Object)"HTTP_GET_VARS", 8);
        SPECIAL_VARS.put((Object)"HTTP_POST_VARS", 9);
        SPECIAL_VARS.put((Object)"HTTP_POST_FILES", 13);
        SPECIAL_VARS.put((Object)"HTTP_COOKIE_VARS", 10);
        SPECIAL_VARS.put((Object)"HTTP_SERVER_VARS", 15);
        SPECIAL_VARS.put((Object)"PHP_SELF", 11);
    }

    static class ConnectionEntry {
        private DataSource _ds;
        private String _user;
        private String _password;
        private Connection _conn;

        ConnectionEntry() {
        }

        public void init(DataSource ds, String user, String password) {
            this._ds = ds;
            this._user = user;
            this._password = password;
        }

        public void setConnection(Connection conn) {
            this._conn = conn;
        }

        public Connection getConnection() {
            return this._conn;
        }

        public int hashCode() {
            int hash = this._ds.hashCode();
            if (this._user == null) {
                return hash;
            }
            return 65521 * hash + this._user.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionEntry)) {
                return false;
            }
            ConnectionEntry entry = (ConnectionEntry)o;
            if (this._ds != entry._ds) {
                return false;
            }
            if (this._user == null) {
                return entry._user == null;
            }
            return this._user.equals(entry._user);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[ds=" + this._ds + ", user=" + this._user + "]";
        }
    }

    static class ClassKey {
        private final WeakReference<ClassDef> _defRef;
        private final WeakReference<QuercusClass> _parentRef;
        private final int _hash;

        ClassKey(ClassDef def, QuercusClass parent) {
            this._defRef = new WeakReference<ClassDef>(def);
            this._parentRef = parent != null ? new WeakReference<QuercusClass>(parent) : null;
            int hash = 37;
            if (def != null) {
                hash = 65521 * hash + def.hashCode();
            }
            if (parent != null) {
                hash = 65521 * hash + parent.hashCode();
            }
            this._hash = hash;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            ClassDef bDef;
            ClassKey key = (ClassKey)o;
            ClassDef aDef = (ClassDef)this._defRef.get();
            if (aDef != (bDef = (ClassDef)key._defRef.get())) {
                return false;
            }
            if (this._parentRef == key._parentRef) {
                return true;
            }
            if (this._parentRef != null && key._parentRef != null) {
                return this._parentRef.get() == key._parentRef.get();
            }
            return false;
        }
    }
}

