/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaAdapterVar;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaAdapter
extends ArrayValue
implements Serializable {
    private static final Logger log = Logger.getLogger(JavaAdapter.class.getName());
    private Object _object;
    private JavaClassDef _classDef;
    private Env _env;
    private HashMap<Value, Value> _refs;

    protected JavaAdapter(Env env, Object object, JavaClassDef def) {
        this._env = env;
        this._object = object;
        this._classDef = def;
    }

    public Env getEnv() {
        return this._env;
    }

    public JavaClassDef getClassDef() {
        return this._classDef;
    }

    public Value wrapJava(Object obj) {
        return this._env.wrapJava(obj);
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Object toJavaObject() {
        return this._object;
    }

    @Override
    public Object toJavaObjectNotNull(Env env, Class type) {
        if (type.isAssignableFrom(this._object.getClass())) {
            return this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._object.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value key = entry.getKey();
            if (!(key instanceof StringValue)) continue;
            obj.putField(env, key.toString(), entry.getValue());
        }
        return obj;
    }

    @Override
    public Collection toJavaCollection(Env env, Class type) {
        Collection<Object> coll = null;
        if (type.isAssignableFrom(HashSet.class)) {
            coll = new HashSet();
        } else if (type.isAssignableFrom(TreeSet.class)) {
            coll = new TreeSet();
        } else {
            try {
                coll = (Collection)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            coll.add(entry.getValue());
        }
        return coll;
    }

    @Override
    public List toJavaList(Env env, Class type) {
        List<Object> list = null;
        if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (type.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else if (type.isAssignableFrom(Vector.class)) {
            list = new Vector();
        } else {
            try {
                list = (List)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    @Override
    public Map toJavaMap(Env env, Class type) {
        Map<Object, Object> map = null;
        if (type.isAssignableFrom(TreeMap.class)) {
            map = new TreeMap();
        } else if (type.isAssignableFrom(LinkedHashMap.class)) {
            map = new LinkedHashMap();
        } else {
            try {
                map = (Map)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.objectEntrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public abstract Value copy();

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract void clear();

    @Override
    public final Value put(Value value) {
        return this.put(this.createTailKey(), value);
    }

    @Override
    public final Value put(Value key, Value value) {
        Value retValue = this.putImpl(key, value);
        if (this._refs == null) {
            this._refs = new HashMap();
        }
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            this._refs.put(key, var);
        } else {
            Value ref = this._refs.get(key);
            if (ref != null) {
                ref.set(value);
            }
        }
        return retValue;
    }

    public abstract Value putImpl(Value var1, Value var2);

    @Override
    public ArrayValue unshift(Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayValue splice(int begin, int end, ArrayValue replace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getArg(Value index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value putRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Value createTailKey();

    @Override
    public Value add(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof ArrayValue)) {
            return this.copy();
        }
        ArrayValue rArray = (ArrayValue)rValue;
        ArrayValueImpl result = new ArrayValueImpl(rArray);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            ((ArrayValue)result).put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Collection<Value> getIndices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Value get(Value var1);

    @Override
    public abstract Value remove(Value var1);

    @Override
    public Var getRef(Value index) {
        JavaAdapterVar var = new JavaAdapterVar(this, index);
        if (this._refs == null) {
            this._refs = new HashMap();
        }
        this._refs.put(index, var);
        return var;
    }

    @Override
    public Set<Value> keySet() {
        return new KeySet(this._env);
    }

    @Override
    public abstract Set<Map.Entry<Value, Value>> entrySet();

    public abstract Set<Map.Entry<Object, Object>> objectEntrySet();

    @Override
    public Collection<Value> values() {
        throw new UnimplementedException();
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        this.put(key, value);
        return this;
    }

    @Override
    public Value pop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shuffle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayValue.Entry getHead() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ArrayValue.Entry getTail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value current() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value key() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value prev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value each() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value end() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value contains(Value value) {
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value containsStrict(Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value containsKey(Value key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Value, Value>[] toEntryArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<Map.Entry<Value, Value>> comparator, boolean resetKeys, boolean strict) {
        Map.Entry[] entries = new Map.Entry[this.getSize()];
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            entries[i++] = entry;
        }
        Arrays.sort(entries, comparator);
        this.clear();
        long base = 0L;
        if (!resetKeys) {
            strict = false;
        }
        for (int j = 0; j < entries.length; ++j) {
            Value key = (Value)entries[j].getKey();
            if (resetKeys && (!(key instanceof StringValue) || strict)) {
                this.put(LongValue.create(base++), (Value)entries[j].getValue());
                continue;
            }
            this.put((Value)entries[j].getKey(), (Value)entries[j].getValue());
        }
    }

    @Override
    public void serialize(StringBuilder sb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void varExport(StringBuilder sb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean keyReset(long base, boolean strict) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value[] valuesToArray() {
        Value[] values = new Value[this.getSize()];
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            values[i++] = entry.getValue();
        }
        return values;
    }

    @Override
    public Object valuesToArray(Env env, Class elementType) {
        int size = this.getSize();
        Object array = Array.newInstance(elementType, size);
        MarshalFactory factory = env.getModuleContext().getMarshalFactory();
        Marshal elementMarshal = factory.create(elementType);
        int i = 0;
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Array.set(array, i++, elementMarshal.marshal(env, entry.getValue(), elementType));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getField(Env env, String name, boolean create) {
        Value oldThis = env.setThis(this);
        try {
            Value value = this._classDef.getField(env, this._object, name, create);
            return value;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value putField(Env env, String name, Value value) {
        Value oldThis = env.setThis(this);
        try {
            Value value2 = this._classDef.putField(env, this._object, name, value);
            return value2;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    public String getName() {
        return this._classDef.getName();
    }

    @Override
    public boolean isA(String name) {
        return this._classDef.isA(name);
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._classDef.findFunction(methodName);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4, a5);
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("array(" + this.getSize() + ") {");
        int nestedDepth = depth + 1;
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            this.printDepth(out, nestedDepth * 2);
            out.print("[");
            Value key = mapEntry.getKey();
            if (key.isString()) {
                out.print("\"" + key + "\"");
            } else {
                out.print((Object)key);
            }
            out.println("]=>");
            this.printDepth(out, nestedDepth * 2);
            if (this._refs != null && this._refs.get(key) != null) {
                out.print('&');
            }
            mapEntry.getValue().varDump(env, out, nestedDepth, valueSet);
            out.println();
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("Array");
        this.printDepth(out, 8 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            this.printDepth(out, 8 * depth);
            out.print("    [");
            out.print((Object)mapEntry.getKey());
            out.print("] => ");
            Value value = mapEntry.getValue();
            if (value != null) {
                value.printR(env, out, depth + 1, valueSet);
            }
            out.println();
        }
        this.printDepth(out, 8 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._object);
        out.writeObject(this._classDef.getName());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._env = Env.getInstance();
        this._object = in.readObject();
        this._classDef = this._env.getJavaClassDefinition((String)in.readObject());
    }

    @Override
    public String toString() {
        return String.valueOf(this._object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeySet
    extends AbstractSet<Value> {
        Env _env;

        KeySet(Env env) {
            this._env = env;
        }

        @Override
        public int size() {
            return JavaAdapter.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return JavaAdapter.this.getKeyIterator(this._env);
        }
    }
}

