/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.annotation.This;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;

public abstract class JavaInvoker
extends AbstractJavaMethod {
    private static final L10N L = new L10N(JavaInvoker.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private static final Value[] NULL_VALUES = new Value[0];
    private final ModuleContext _moduleContext;
    private final String _name;
    private final Class[] _param;
    private final Class _retType;
    private final Annotation[][] _paramAnn;
    private final Annotation[] _methodAnn;
    private volatile boolean _isInit;
    private int _minArgumentLength;
    private int _maxArgumentLength;
    private boolean _hasEnv;
    private boolean _hasThis;
    private Expr[] _defaultExprs;
    private Marshal[] _marshalArgs;
    private boolean _hasRestArgs;
    private Marshal _unmarshalReturn;
    private boolean _isRestReference;
    private boolean _isCallUsesVariableArgs;
    private boolean _isCallUsesSymbolTable;

    public JavaInvoker(ModuleContext moduleContext, String name, Class[] param, Annotation[][] paramAnn, Annotation[] methodAnn, Class retType) {
        this._moduleContext = moduleContext;
        this._name = name;
        this._param = param;
        this._paramAnn = paramAnn;
        this._methodAnn = methodAnn;
        this._retType = retType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this._isInit) {
            return;
        }
        MarshalFactory marshalFactory = this._moduleContext.getMarshalFactory();
        ExprFactory exprFactory = this._moduleContext.getExprFactory();
        try {
            boolean callUsesVariableArgs = false;
            boolean callUsesSymbolTable = false;
            boolean returnNullAsFalse = false;
            for (Annotation ann : this._methodAnn) {
                if (VariableArguments.class.isAssignableFrom(ann.annotationType())) {
                    callUsesVariableArgs = true;
                }
                if (UsesSymbolTable.class.isAssignableFrom(ann.annotationType())) {
                    callUsesSymbolTable = true;
                }
                if (!ReturnNullAsFalse.class.isAssignableFrom(ann.annotationType())) continue;
                returnNullAsFalse = true;
            }
            this._isCallUsesVariableArgs = callUsesVariableArgs;
            this._isCallUsesSymbolTable = callUsesSymbolTable;
            this._hasEnv = this._param.length > 0 && this._param[0].equals(Env.class);
            int envOffset = this._hasEnv ? 1 : 0;
            this._hasThis = envOffset < this._param.length ? this.hasThis(this._param[envOffset], this._paramAnn[envOffset]) : false;
            if (this._hasThis) {
                ++envOffset;
            }
            boolean hasRestArgs = false;
            boolean isRestReference = false;
            if (this._param.length > 0 && (this._param[this._param.length - 1].equals(Value[].class) || this._param[this._param.length - 1].equals(Object[].class))) {
                hasRestArgs = true;
                for (Annotation ann : this._paramAnn[this._param.length - 1]) {
                    if (!Reference.class.isAssignableFrom(ann.annotationType())) continue;
                    isRestReference = true;
                }
            }
            this._hasRestArgs = hasRestArgs;
            this._isRestReference = isRestReference;
            int argLength = this._param.length;
            if (this._hasRestArgs) {
                --argLength;
            }
            this._defaultExprs = new Expr[argLength - envOffset];
            this._marshalArgs = new Marshal[argLength - envOffset];
            this._minArgumentLength = this._maxArgumentLength = argLength - envOffset;
            for (int i = 0; i < argLength - envOffset; ++i) {
                boolean isReference = false;
                boolean isNotNull = false;
                for (Annotation ann : this._paramAnn[i + envOffset]) {
                    if (Optional.class.isAssignableFrom(ann.annotationType())) {
                        --this._minArgumentLength;
                        Optional opt = (Optional)ann;
                        if (!opt.value().equals("")) {
                            Expr expr;
                            this._defaultExprs[i] = expr = QuercusParser.parseDefault(opt.value());
                            continue;
                        }
                        this._defaultExprs[i] = exprFactory.createDefault();
                        continue;
                    }
                    if (Reference.class.isAssignableFrom(ann.annotationType())) {
                        isReference = true;
                        continue;
                    }
                    if (!NotNull.class.isAssignableFrom(ann.annotationType())) continue;
                    isNotNull = true;
                }
                Class argType = this._param[i + envOffset];
                if (isReference) {
                    this._marshalArgs[i] = marshalFactory.createReference();
                    if (Value.class.equals((Object)argType) || Var.class.equals((Object)argType)) continue;
                    throw new QuercusException(L.l("reference must be Value or Var for {0}", (Object)this._name));
                }
                this._marshalArgs[i] = marshalFactory.create(argType, isNotNull);
            }
            this._unmarshalReturn = marshalFactory.create(this._retType, false, returnNullAsFalse);
        }
        finally {
            this._isInit = true;
        }
    }

    public int getMinArgLength() {
        if (!this._isInit) {
            this.init();
        }
        return this._minArgumentLength;
    }

    public int getMaxArgLength() {
        if (!this._isInit) {
            this.init();
        }
        return this._maxArgumentLength;
    }

    public boolean getHasEnv() {
        if (!this._isInit) {
            this.init();
        }
        return this._hasEnv;
    }

    public boolean getHasRestArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._hasRestArgs;
    }

    public boolean isRestReference() {
        if (!this._isInit) {
            this.init();
        }
        return this._isRestReference;
    }

    public Marshal getUnmarshalReturn() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn;
    }

    public boolean isCallUsesVariableArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._isCallUsesVariableArgs;
    }

    public boolean isCallUsesSymbolTable() {
        if (!this._isInit) {
            this.init();
        }
        return this._isCallUsesSymbolTable;
    }

    public boolean isBoolean() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isBoolean();
    }

    public boolean isString() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isString();
    }

    public boolean isLong() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isLong();
    }

    public boolean isDouble() {
        if (!this._isInit) {
            this.init();
        }
        return this._unmarshalReturn.isDouble();
    }

    public String getName() {
        return this._name;
    }

    protected Marshal[] getMarshalArgs() {
        if (!this._isInit) {
            this.init();
        }
        return this._marshalArgs;
    }

    protected Annotation[][] getParamAnn() {
        if (!this._isInit) {
            this.init();
        }
        return this._paramAnn;
    }

    protected Expr[] getDefaultExprs() {
        if (!this._isInit) {
            this.init();
        }
        return this._defaultExprs;
    }

    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        if (!this._isInit) {
            this.init();
        }
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Marshal arg = null;
            if (i >= this._marshalArgs.length) {
                if (this._isRestReference) {
                    values[i] = args[i].evalRef(env);
                    continue;
                }
                values[i] = args[i].eval(env);
                continue;
            }
            arg = this._marshalArgs[i];
            values[i] = arg == null ? args[i].eval(env).copy() : (arg.isReference() ? args[i].evalRef(env) : args[i].eval(env));
        }
        return values;
    }

    public int getMarshalingCost(Value[] args) {
        int restLen;
        int i;
        if (!this._isInit) {
            this.init();
        }
        if (!this._hasRestArgs) {
            if (args.length < this._marshalArgs.length) {
                return Integer.MAX_VALUE;
            }
            if (args.length > this._marshalArgs.length) {
                return Integer.MAX_VALUE;
            }
        }
        int cost = 0;
        for (i = 0; i < this._marshalArgs.length; ++i) {
            Marshal marshal = this._marshalArgs[i];
            if (i >= args.length || args[i] == null) continue;
            Value arg = args[i];
            int argCost = marshal.getMarshalingCost(arg);
            cost = Math.max(argCost + cost, cost);
        }
        if (this._hasRestArgs && (restLen = args.length - this._marshalArgs.length) > 0) {
            i += restLen;
        }
        if (i != args.length) {
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    public Value call(Env env, Value[] value) {
        return this.call(env, env.getThis(), value);
    }

    public Value callCopy(Env env, Value[] args) {
        return this.call(env, args);
    }

    public Value call(Env env, Value obj, Value[] value) {
        return this.call(env, obj.toJavaObject(), value);
    }

    public Value call(Env env, Object obj, Expr[] exprs) {
        if (!this._isInit) {
            this.init();
        }
        int len = this._defaultExprs.length + (this._hasEnv ? 1 : 0) + (this._hasThis ? 1 : 0) + (this._hasRestArgs ? 1 : 0);
        Object[] values = new Object[len];
        int k = 0;
        if (this._hasEnv) {
            values[k++] = env;
        }
        if (this._hasThis) {
            values[k++] = (ObjectValue)obj;
            obj = null;
        }
        for (int i = 0; i < this._marshalArgs.length; ++i) {
            Expr expr;
            if (i < exprs.length && exprs[i] != null) {
                expr = exprs[i];
            } else {
                expr = this._defaultExprs[i];
                if (expr == null) {
                    expr = this._moduleContext.getExprFactory().createRequired();
                }
            }
            values[k] = this._marshalArgs[i].marshal(env, expr, this._param[k]);
            ++k;
        }
        if (this._hasRestArgs) {
            Value[] rest;
            int restLen = exprs.length - this._marshalArgs.length;
            if (restLen <= 0) {
                rest = NULL_VALUES;
            } else {
                rest = new Value[restLen];
                for (int i = this._marshalArgs.length; i < exprs.length; ++i) {
                    rest[i - this._marshalArgs.length] = this._isRestReference ? exprs[i].evalRef(env) : exprs[i].eval(env);
                }
            }
            values[values.length - 1] = rest;
        }
        Object result = this.invoke(obj, values);
        return this._unmarshalReturn.unmarshal(env, result);
    }

    public Value call(Env env, Object obj, Value[] args) {
        if (!this._isInit) {
            this.init();
        }
        int len = this._param.length;
        Object[] javaArgs = new Object[len];
        int k = 0;
        if (this._hasEnv) {
            javaArgs[k++] = env;
        }
        if (this._hasThis) {
            javaArgs[k++] = (ObjectValue)obj;
            obj = null;
        }
        for (int i = 0; i < this._marshalArgs.length; ++i) {
            if (i < args.length && args[i] != null) {
                javaArgs[k] = this._marshalArgs[i].marshal(env, args[i], this._param[k]);
            } else if (this._defaultExprs[i] != null) {
                javaArgs[k] = this._marshalArgs[i].marshal(env, this._defaultExprs[i], this._param[k]);
            } else {
                env.warning(L.l("function '{0}' has {1} required arguments, but only {2} were provided", (Object)this._name, (Object)this._minArgumentLength, (Object)args.length));
                javaArgs[k] = this._marshalArgs[i].marshal(env, NullValue.NULL, this._param[k]);
            }
            ++k;
        }
        if (this._hasRestArgs) {
            Value[] rest;
            int restLen = args.length - this._marshalArgs.length;
            if (restLen <= 0) {
                rest = NULL_VALUES;
            } else {
                rest = new Value[restLen];
                for (int i = this._marshalArgs.length; i < args.length; ++i) {
                    rest[i - this._marshalArgs.length] = this._isRestReference ? args[i] : args[i].toValue();
                }
            }
            javaArgs[k++] = rest;
        }
        Object result = this.invoke(obj, javaArgs);
        return this._unmarshalReturn.unmarshal(env, result);
    }

    public Value call(Env env, Object obj) {
        return this.call(env, obj, new Value[0]);
    }

    public Value call(Env env, Object obj, Value a1) {
        return this.call(env, obj, new Value[]{a1});
    }

    public Value call(Env env, Object obj, Value a1, Value a2) {
        return this.call(env, obj, new Value[]{a1, a2});
    }

    public Value call(Env env, Object obj, Value a1, Value a2, Value a3) {
        return this.call(env, obj, new Value[]{a1, a2, a3});
    }

    public Value call(Env env, Object obj, Value a1, Value a2, Value a3, Value a4) {
        return this.call(env, obj, new Value[]{a1, a2, a3, a4});
    }

    public Value call(Env env, Object obj, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.call(env, obj, new Value[]{a1, a2, a3, a4, a5});
    }

    public abstract Object invoke(Object var1, Object[] var2);

    private boolean hasThis(Class param, Annotation[] ann) {
        if (!param.isAssignableFrom(ObjectValue.class)) {
            return false;
        }
        for (int i = 0; i < ann.length; ++i) {
            if (!This.class.isAssignableFrom(ann[i].annotationType())) continue;
            return true;
        }
        return false;
    }
}

