/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaAdapter;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.JavaClassDef;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMapAdapter
extends JavaAdapter {
    private static final Logger log = Logger.getLogger(JavaMapAdapter.class.getName());
    private Map<Object, Object> _map;
    private long _nextAvailableIndex;

    public JavaMapAdapter(Env env, Map map) {
        this(env, map, env.getJavaClassDefinition(map.getClass()));
    }

    public JavaMapAdapter(Env env, Map map, JavaClassDef def) {
        super(env, map, def);
        this._map = map;
        this.updateNextAvailableIndex();
    }

    @Override
    public void clear() {
        this._map.clear();
        this._nextAvailableIndex = 0L;
    }

    public int size() {
        return this._map.size();
    }

    @Override
    public Object toJavaObject(Env env, Class type) {
        if (type.isAssignableFrom(this._map.getClass())) {
            return this._map;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._map.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Value copy() {
        try {
            Class<?> cl = this._map.getClass();
            Map map = (Map)cl.newInstance();
            map.putAll(this._map);
            return new JavaMapAdapter(this.getEnv(), map, this.getClassDef());
        }
        catch (Exception e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Value get(Value key) {
        Object obj = this._map.get(key.toJavaObject());
        if (obj != null) {
            return this.wrapJava(this._map.get(key.toJavaObject()));
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value remove(Value key) {
        this.updateNextAvailableIndex();
        if (key.isLongConvertible() || key instanceof BooleanValue) {
            long pos = key.toLong();
            Object value = this._map.remove(pos);
            if (value != null) {
                if (pos + 1L == this._nextAvailableIndex) {
                    this.updateNextAvailableIndex();
                }
                return this.wrapJava(value);
            }
        } else {
            Object value = this._map.remove(key.toJavaObject());
            if (value != null) {
                return this.wrapJava(value);
            }
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value createTailKey() {
        this.updateNextAvailableIndex();
        return LongValue.create(this._nextAvailableIndex);
    }

    @Override
    public Value putImpl(Value key, Value value) {
        Object keyObject = key.isLongConvertible() || key instanceof BooleanValue ? Long.valueOf(key.toLong()) : key.toJavaObject();
        Value val = this.wrapJava(this._map.put(keyObject, value.toJavaObject()));
        this.updateNextAvailableIndex(keyObject);
        return val;
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return new KeyIterator();
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return new ValueIterator();
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return new MapIterator();
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        return new MapSet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> objectEntrySet() {
        return this._map.entrySet();
    }

    @Override
    public Collection<Value> values() {
        return new ValueCollection();
    }

    private void updateNextAvailableIndex() {
        this._nextAvailableIndex = 0L;
        for (Object key : this._map.keySet()) {
            this.updateNextAvailableIndex(key);
        }
    }

    private void updateNextAvailableIndex(Object objectKey) {
        long key;
        if (objectKey instanceof Long && this._nextAvailableIndex <= (key = ((Long)objectKey).longValue())) {
            this._nextAvailableIndex = key + 1L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyIterator
    implements Iterator<Value> {
        private Iterator _iterator;

        public KeyIterator() {
            this._iterator = JavaMapAdapter.this._map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            return JavaMapAdapter.this.wrapJava(this._iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIterator
    implements Iterator<Value> {
        private Iterator _iterator;

        public ValueIterator() {
            this._iterator = JavaMapAdapter.this._map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            return JavaMapAdapter.this.wrapJava(this._iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueCollection
    extends AbstractCollection<Value> {
        ValueCollection() {
        }

        @Override
        public int size() {
            return JavaMapAdapter.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntry
    implements Map.Entry<Value, Value> {
        private final Value _key;
        private Value _value;

        public MapEntry(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this._value;
            this._value = value;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Iterator<Map.Entry<Object, Object>> _iterator;

        public MapIterator() {
            this._iterator = JavaMapAdapter.this._map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<Value, Value> next() {
            Map.Entry<Object, Object> entry = this._iterator.next();
            Value key = JavaMapAdapter.this.wrapJava(entry.getKey());
            Value value = JavaMapAdapter.this.wrapJava(entry.getValue());
            return new MapEntry(key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapSet
    extends AbstractSet<Map.Entry<Value, Value>> {
        MapSet() {
        }

        @Override
        public int size() {
            return JavaMapAdapter.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new MapIterator();
        }
    }
}

