/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class JavaOverloadMethod
extends AbstractJavaMethod {
    private static final L10N L = new L10N(JavaOverloadMethod.class);
    private AbstractJavaMethod[][] _methodTable = new AbstractJavaMethod[0][];
    private AbstractJavaMethod[][] _restMethodTable = new AbstractJavaMethod[0][];

    public JavaOverloadMethod(AbstractJavaMethod fun) {
        this.overload(fun);
    }

    public int getMaxArgLength() {
        throw new UnsupportedOperationException();
    }

    public int getMinArgLength() {
        throw new UnsupportedOperationException();
    }

    public boolean getHasRestArgs() {
        throw new UnsupportedOperationException();
    }

    public AbstractJavaMethod overload(AbstractJavaMethod fun) {
        if (fun.getHasRestArgs()) {
            AbstractJavaMethod[] methods;
            int len = fun.getMinArgLength();
            if (this._restMethodTable.length <= len) {
                AbstractJavaMethod[][] restMethodTable = new AbstractJavaMethod[len + 1][];
                System.arraycopy(this._restMethodTable, 0, restMethodTable, 0, this._restMethodTable.length);
                this._restMethodTable = restMethodTable;
            }
            if ((methods = this._restMethodTable[len]) == null) {
                this._restMethodTable[len] = new AbstractJavaMethod[]{fun};
            } else {
                AbstractJavaMethod[] newMethods = new AbstractJavaMethod[methods.length + 1];
                System.arraycopy(methods, 0, newMethods, 0, methods.length);
                newMethods[methods.length] = fun;
                this._restMethodTable[len] = newMethods;
            }
            return this;
        }
        int maxLen = fun.getMaxArgLength();
        if (this._methodTable.length <= maxLen) {
            AbstractJavaMethod[][] methodTable = new AbstractJavaMethod[maxLen + 1][];
            System.arraycopy(this._methodTable, 0, methodTable, 0, this._methodTable.length);
            this._methodTable = methodTable;
        }
        for (int len = fun.getMinArgLength(); len <= maxLen; ++len) {
            AbstractJavaMethod[] methods = this._methodTable[len];
            if (methods == null) {
                this._methodTable[len] = new AbstractJavaMethod[]{fun};
                continue;
            }
            AbstractJavaMethod[] newMethods = new AbstractJavaMethod[methods.length + 1];
            System.arraycopy(methods, 0, newMethods, 0, methods.length);
            newMethods[methods.length] = fun;
            this._methodTable[len] = newMethods;
        }
        return this;
    }

    public Value call(Env env, Object obj, Expr[] args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = args[i].eval(env);
        }
        return this.call(env, obj, values);
    }

    public Value call(Env env, Object obj, Value[] args) {
        if (this._methodTable.length <= args.length) {
            if (this._restMethodTable.length == 0) {
                return env.error(L.l("'{0}' overloaded method call with {1} arguments has too many arguments", (Object)this.getName(), args.length));
            }
            AbstractJavaMethod method = this.getBestFitJavaMethod(null, this._restMethodTable, args);
            return method.call(env, obj, args);
        }
        AbstractJavaMethod[] methods = this._methodTable[args.length];
        if (methods != null) {
            if (methods.length == 1) {
                return methods[0].call(env, obj, args);
            }
            AbstractJavaMethod method = this.getBestFitJavaMethod(methods, this._restMethodTable, args);
            return method.call(env, obj, args);
        }
        if (this._restMethodTable.length == 0) {
            return env.error(L.l("'{0}' overloaded method call with {1} arguments does not match any overloaded method", (Object)this.getName(), args.length));
        }
        AbstractJavaMethod method = this.getBestFitJavaMethod(methods, this._restMethodTable, args);
        return method.call(env, obj, args);
    }

    private AbstractJavaMethod getBestFitJavaMethod(AbstractJavaMethod[] methods, AbstractJavaMethod[][] restMethodTable, Value[] args) {
        int i;
        AbstractJavaMethod minCostJavaMethod = null;
        int minCost = Integer.MAX_VALUE;
        if (methods != null) {
            for (i = 0; i < methods.length; ++i) {
                AbstractJavaMethod javaMethod = methods[i];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        for (i = Math.min(args.length, restMethodTable.length) - 1; i >= 0; --i) {
            if (restMethodTable[i] == null) continue;
            for (int j = 0; j < restMethodTable[i].length; ++j) {
                AbstractJavaMethod javaMethod = restMethodTable[i][j];
                int cost = javaMethod.getMarshalingCost(args);
                if (cost == 0) {
                    return javaMethod;
                }
                if (cost > minCost) continue;
                minCost = cost;
                minCostJavaMethod = javaMethod;
            }
        }
        return minCostJavaMethod;
    }

    public int getMarshalingCost(Value[] args) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        for (int i = 0; i < this._methodTable.length; ++i) {
            if (this._methodTable[i] == null) continue;
            return this._methodTable[i][0].getName();
        }
        return "unknown";
    }

    public String toString() {
        return "JavaOverloadMethod[" + this.getName() + "]";
    }
}

