/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaValue
extends ObjectValue
implements Serializable {
    private static final Logger log = Logger.getLogger(JavaValue.class.getName());
    private JavaClassDef _classDef;
    private Object _object;
    protected Env _env;

    public JavaValue(Env env, Object object, JavaClassDef def) {
        super(env.createQuercusClass(def, null));
        this._env = env;
        this._classDef = def;
        this._object = object;
    }

    @Override
    public String getClassName() {
        return this._classDef.getName();
    }

    @Override
    public Set<Map.Entry<String, Value>> entrySet() {
        throw new UnsupportedOperationException("unimplementated");
    }

    @Override
    public long toLong() {
        return JavaValue.toLong(this.toString());
    }

    public static long toLong(String string) {
        int len = string.length();
        long value = 0L;
        long sign = 1L;
        int i = 0;
        char ch = string.charAt(0);
        if (ch == '-') {
            sign = -1L;
            i = 1;
        } else if (ch == '+') {
            i = 1;
        }
        while (i < len) {
            ch = string.charAt(i);
            if ('0' > ch || ch > '9') {
                return 1L;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return value;
    }

    @Override
    public double toDouble() {
        return JavaValue.toDouble(this.toString());
    }

    public static double toDouble(String s) {
        int len = s.length();
        int i = 0;
        char ch = '\u0000';
        if (i < len && ((ch = s.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = s.charAt(i)) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i != len) {
            return 1.0;
        }
        return Double.parseDouble(s);
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (!this._classDef.printRImpl(env, this._object, out, depth, valueSet)) {
            out.print("resource(" + this.toString(env) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        Value oldThis = env.setThis(this);
        try {
            if (!this._classDef.varDumpImpl(env, this._object, out, depth, valueSet)) {
                out.print("resource(" + this.toString(env) + ")");
            }
        }
        finally {
            env.setThis(oldThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getField(Env env, String name, boolean create) {
        Value oldThis = env.setThis(this);
        try {
            Value value = this._classDef.getField(env, this._object, name, create);
            return value;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value putField(Env env, String name, Value value) {
        Value oldThis = env.setThis(this);
        try {
            Value value2 = this._classDef.putField(env, this._object, name, value);
            return value2;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    @Override
    public Value toKey() {
        return new LongValue(System.identityHashCode(this));
    }

    @Override
    public int cmpObject(ObjectValue rValue) {
        if (rValue == this) {
            return 0;
        }
        if (!(rValue instanceof JavaValue)) {
            return -1;
        }
        Object rObject = rValue.toJavaObject();
        return this._classDef.cmpObject(this._object, rObject, ((JavaValue)rValue)._classDef);
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._classDef.findFunction(methodName);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._classDef.callMethod(env, this._object, hash, name, nameLen, a1, a2, a3, a4, a5);
    }

    @Override
    public void serialize(StringBuilder sb) {
        log.fine("Quercus: can't serialize " + this._object.getClass());
        sb.append("N;");
    }

    public String toString() {
        return String.valueOf(this._object);
    }

    @Override
    public Object toJavaObject() {
        return this._object;
    }

    @Override
    public Object toJavaObject(Env env, Class type) {
        if (type.isAssignableFrom(this._object.getClass())) {
            return this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._object.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Object toJavaObjectNotNull(Env env, Class type) {
        Class<?> objClass = this._object.getClass();
        if (objClass == type || type.isAssignableFrom(objClass)) {
            return this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)objClass.getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public Map toJavaMap(Env env, Class type) {
        if (type.isAssignableFrom(this._object.getClass())) {
            return (Map)this._object;
        }
        env.warning(L.l("Can't assign {0} to {1}", (Object)this._object.getClass().getName(), (Object)type.getName()));
        return null;
    }

    @Override
    public InputStream toInputStream() {
        if (this._object instanceof InputStream) {
            return (InputStream)this._object;
        }
        return super.toInputStream();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._classDef.getType().getCanonicalName());
        out.writeObject(this._object);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._env = Env.getInstance();
        this._classDef = this._env.getJavaClassDefinition((String)in.readObject());
        this.setQuercusClass(this._env.createQuercusClass(this._classDef, null));
        this._object = in.readObject();
    }
}

