/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongValue
extends NumberValue {
    public static final LongValue MINUS_ONE = new LongValue(-1L);
    public static final LongValue ZERO = new LongValue(0L);
    public static final LongValue ONE = new LongValue(1L);
    public static final int STATIC_MIN = -256;
    public static final int STATIC_MAX = 256;
    public static final LongValue[] STATIC_VALUES = new LongValue[513];
    private final long _value;

    public LongValue(long value) {
        this._value = value;
    }

    public static LongValue create(long value) {
        if (-256L <= value && value <= 256L) {
            return STATIC_VALUES[(int)(value - -256L)];
        }
        return new LongValue(value);
    }

    public static LongValue create(Number value) {
        if (value == null) {
            return ZERO;
        }
        return new LongValue(value.longValue());
    }

    @Override
    public String getType() {
        return "integer";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.LONG;
    }

    @Override
    public boolean isLongConvertible() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        return this._value != 0L;
    }

    @Override
    public long toLong() {
        return this._value;
    }

    @Override
    public double toDouble() {
        return this._value;
    }

    public String toString() {
        return String.valueOf(this._value);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().append(this._value);
    }

    @Override
    public LongValue toLongValue() {
        return this;
    }

    @Override
    public Value toKey() {
        return this;
    }

    public Object toObject() {
        return String.valueOf(this._value);
    }

    @Override
    public Object toJavaObject() {
        return new Long(this._value);
    }

    @Override
    public Value neg() {
        return new LongValue(-this._value);
    }

    @Override
    public Value pos() {
        return this;
    }

    @Override
    public Value preincr(int incr) {
        return LongValue.create(this._value + (long)incr);
    }

    @Override
    public Value postincr(int incr) {
        return LongValue.create(this._value + (long)incr);
    }

    @Override
    public Value add(Value value) {
        return value.add(this._value);
    }

    @Override
    public Value add(long lLong) {
        return LongValue.create(lLong + this._value);
    }

    @Override
    public Value sub(Value rValue) {
        if (rValue.isLongConvertible()) {
            return LongValue.create(this._value - rValue.toLong());
        }
        return DoubleValue.create((double)this._value - rValue.toDouble());
    }

    @Override
    public Value sub(long rLong) {
        return LongValue.create(this._value - rLong);
    }

    @Override
    public boolean eql(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof LongValue)) {
            return false;
        }
        long rLong = ((LongValue)rValue)._value;
        return this._value == rLong;
    }

    @Override
    public int cmp(Value rValue) {
        long l = this._value;
        double r = rValue.toDouble();
        if ((double)l == r) {
            return 0;
        }
        if ((double)l < r) {
            return -1;
        }
        return 1;
    }

    @Override
    public long nextIndex(long oldIndex) {
        if (oldIndex <= this._value) {
            return this._value + 1L;
        }
        return oldIndex;
    }

    @Override
    public void print(Env env) {
        env.print(this._value);
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("i:");
        sb.append(this._value);
        sb.append(";");
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append(this._value);
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        if (this._value == 0L) {
            out.print("LongValue.ZERO");
        } else if (this._value == 1L) {
            out.print("LongValue.ONE");
        } else if (this._value == -1L) {
            out.print("LongValue.MINUS_ONE");
        } else if (-256L <= this._value && this._value <= 256L) {
            out.print("LongValue.STATIC_VALUES[" + (this._value - -256L) + "]");
        } else {
            out.print("new LongValue(" + this._value + "L)");
        }
    }

    public final int hashCode() {
        long v = this._value;
        return (int)(17L * v + 65537L * (v >> 32));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongValue)) {
            return false;
        }
        LongValue value = (LongValue)o;
        return this._value == value._value;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("int(" + this.toLong() + ")");
    }

    private Object readResolve() {
        if (-256L <= this._value && this._value <= 256L) {
            return STATIC_VALUES[(int)(this._value - -256L)];
        }
        return this;
    }

    static {
        for (int i = -256; i <= 256; ++i) {
            LongValue.STATIC_VALUES[i - -256] = new LongValue(i);
        }
    }
}

