/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMap<V> {
    private Entry<V>[] _entries = new Entry[16];
    private int _size;

    public void put(char[] buffer, int length, V value) {
        if (this._entries.length <= this._size * 4) {
            this.resize();
        }
        int hash = MethodMap.hash(buffer, length);
        char[] key = new char[length];
        System.arraycopy(buffer, 0, key, 0, length);
        int bucket = hash & this._entries.length - 1;
        Entry<V> entry = this._entries[bucket];
        while (entry != null) {
            if (this.match(entry._key, key, key.length)) {
                entry._value = value;
                return;
            }
            entry = entry._next;
        }
        entry = new Entry<V>(buffer, value);
        entry._next = this._entries[bucket];
        this._entries[bucket] = entry;
        ++this._size;
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public V get(int hash, char[] buffer, int length) {
        int bucket = hash & this._entries.length - 1;
        Entry<V> entry = this._entries[bucket];
        while (entry != null) {
            char[] key = entry._key;
            if (this.match(key, buffer, length)) {
                return entry._value;
            }
            entry = entry._next;
        }
        return null;
    }

    public void put(String keyString, V value) {
        char[] key = keyString.toCharArray();
        this.put(key, key.length, value);
    }

    public V get(String keyString) {
        char[] key = keyString.toCharArray();
        int hash = MethodMap.hash(key, key.length);
        return this.get(hash, key, key.length);
    }

    public Iterable<V> values() {
        return new ValueIterator<V>(this._entries);
    }

    private boolean match(char[] a, char[] b, int length) {
        if (a.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            int chA = a[i];
            int chB = b[i];
            if (chA == chB) continue;
            if (65 <= chA && chA <= 90) {
                chA += 32;
            }
            if (65 <= chB && chB <= 90) {
                chB += 32;
            }
            if (chA == chB) continue;
            return false;
        }
        return true;
    }

    private void resize() {
        Entry[] newEntries = new Entry[2 * this._entries.length];
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<V> entry = this._entries[i];
            while (entry != null) {
                Entry next = entry._next;
                int hash = MethodMap.hash(entry._key, entry._key.length);
                int bucket = hash & newEntries.length - 1;
                entry._next = newEntries[bucket];
                newEntries[bucket] = entry;
                entry = next;
            }
        }
        this._entries = newEntries;
    }

    public static int hash(char[] buffer, int length) {
        int hash = 17;
        --length;
        while (length >= 0) {
            int ch = buffer[length];
            if (65 <= ch && ch <= 90) {
                ch += 32;
            }
            hash = 65537 * hash + ch;
            --length;
        }
        return hash;
    }

    public static int hash(String string) {
        int hash = 17;
        int length = string.length();
        --length;
        while (length >= 0) {
            int ch = string.charAt(length);
            if (65 <= ch && ch <= 90) {
                ch += 32;
            }
            hash = 65537 * hash + ch;
            --length;
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ValueIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        int _index;
        Entry<V>[] _entries;
        Entry<V> _next;

        public ValueIterator(Entry<V>[] entries) {
            this._entries = entries;
            this.getNext();
        }

        private void getNext() {
            Entry entry;
            Entry entry2 = entry = this._next == null ? null : this._next._next;
            while (entry == null && this._index < this._entries.length && (entry = this._entries[this._index++]) == null) {
            }
            this._next = entry;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public V next() {
            Object value = this._next._value;
            this.getNext();
            return value;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<V> {
        final char[] _key;
        V _value;
        Entry<V> _next;

        Entry(char[] key, V value) {
            this._key = key;
            this._value = value;
        }
    }
}

