/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArgGetFieldValue;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.RefVar;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtValue
extends ObjectValue
implements Serializable {
    private static final StringValue TO_STRING = new StringBuilderValue("__toString");
    private static final int DEFAULT_SIZE = 16;
    private Entry[] _entries;
    private int _hashMask;
    private int _size;

    public ObjectExtValue(QuercusClass cl) {
        super(cl);
        this.init();
    }

    private void init() {
        this._entries = new Entry[16];
        this._hashMask = this._entries.length - 1;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public Value getField(Env env, String key, boolean create) {
        int capacity = this._entries.length;
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        for (int count = capacity; count >= 0; --count) {
            Entry entry = this._entries[hash];
            if (entry == null) {
                if (create) {
                    return this.createEntry(key).getValue();
                }
                return this._quercusClass.getField(env, this, key, create);
            }
            if (key.equals(entry.getKey())) {
                return entry.getValue();
            }
            hash = hash + 1 & hashMask;
        }
        return this._quercusClass.getField(env, this, key, create);
    }

    @Override
    public Var getFieldRef(Env env, String index) {
        Entry entry = this.createEntry(index);
        Value value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Value getFieldArg(Env env, String index) {
        Entry entry = this.getEntry(index);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, index);
    }

    @Override
    public Value getFieldArgRef(Env env, String index) {
        Entry entry = this.getEntry(index);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, index);
    }

    private Entry getEntry(String key) {
        int capacity = this._entries.length;
        int hash = key.hashCode() & this._hashMask;
        for (int count = capacity; count >= 0; --count) {
            Entry entry = this._entries[hash];
            if (entry == null) {
                return null;
            }
            if (key.equals(entry.getKey())) {
                return entry;
            }
            hash = hash + 1 & this._hashMask;
        }
        return null;
    }

    @Override
    public Value putThisField(Env env, String key, Value value) {
        Entry entry = this.createEntry(key);
        Value oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    @Override
    public Value initField(Env env, String key, Value value) {
        this.createEntry(key);
        return this.putField(env, key, value);
    }

    @Override
    public Value putField(Env env, String key, Value value) {
        Entry entry = null;
        AbstractFunction setField = this.getQuercusClass().getSetField();
        if (setField != null) {
            entry = this.getEntry(key);
            if (entry == null) {
                return setField.callMethod(env, this, new UnicodeValueImpl(key), value);
            }
        } else {
            entry = this.createEntry(key);
        }
        Value oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    @Override
    public Value putField(String key, String value) {
        return this.putField(null, key, new StringBuilderValue(value));
    }

    @Override
    public Value putField(String key, long value) {
        return this.putField(null, key, LongValue.create(value));
    }

    @Override
    public Value putField(String key, double value) {
        return this.putField(null, key, DoubleValue.create(value));
    }

    @Override
    public void removeField(String key) {
        int capacity = this._entries.length;
        int hash = key.hashCode() & this._hashMask;
        for (int count = capacity; count >= 0; --count) {
            Entry entry = this._entries[hash];
            if (entry == null) {
                return;
            }
            if (key.equals(entry.getKey())) {
                --this._size;
                this._entries[hash] = null;
                this.shiftEntries(hash + 1);
                return;
            }
            hash = hash + 1 & this._hashMask;
        }
    }

    private void shiftEntries(int index) {
        int capacity = this._entries.length;
        while (index < capacity) {
            Entry entry = this._entries[index];
            if (entry == null) {
                return;
            }
            this._entries[index] = null;
            this.addEntry(entry);
            ++index;
        }
    }

    private Entry createEntry(String key) {
        Entry newEntry;
        Entry entry;
        int capacity = this._entries.length;
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        for (int count = capacity; count >= 0 && (entry = this._entries[hash]) != null; --count) {
            if (key.equals(entry.getKey())) {
                return entry;
            }
            hash = hash + 1 & hashMask;
        }
        ++this._size;
        this._entries[hash] = newEntry = new Entry(key);
        if (this._entries.length <= 2 * this._size) {
            this.expand();
        }
        return newEntry;
    }

    private void expand() {
        Entry[] entries = this._entries;
        this._entries = new Entry[2 * entries.length];
        this._hashMask = this._entries.length - 1;
        for (int i = entries.length - 1; i >= 0; --i) {
            Entry entry = entries[i];
            if (entry == null) continue;
            this.addEntry(entry);
        }
    }

    private void addEntry(Entry entry) {
        int capacity = this._entries.length;
        int hash = entry.getKey().hashCode() & this._hashMask;
        for (int i = capacity; i >= 0; --i) {
            if (this._entries[hash] == null) {
                this._entries[hash] = entry;
                return;
            }
            hash = hash + 1 & this._hashMask;
        }
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        Iterator<Map.Entry<Value, Value>> iter = super.getIterator(env);
        if (iter != null) {
            return iter;
        }
        return new Iterator<Map.Entry<Value, Value>>(){
            final Iterator<Map.Entry<String, Value>> _iterator;
            {
                this._iterator = new EntryIterator(ObjectExtValue.this._entries);
            }

            @Override
            public boolean hasNext() {
                return this._iterator.hasNext();
            }

            @Override
            public Map.Entry<Value, Value> next() {
                final Map.Entry<String, Value> next = this._iterator.next();
                return new Map.Entry<Value, Value>(){

                    @Override
                    public Value getKey() {
                        return new StringBuilderValue((String)next.getKey());
                    }

                    @Override
                    public Value getValue() {
                        return (Value)next.getValue();
                    }

                    @Override
                    public Value setValue(Value value) {
                        return next.setValue(value);
                    }
                };
            }

            @Override
            public void remove() {
                this._iterator.remove();
            }
        };
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        Iterator<Value> iter = super.getKeyIterator(env);
        if (iter != null) {
            return iter;
        }
        return new Iterator<Value>(){
            final Iterator<Map.Entry<String, Value>> _iterator;
            {
                this._iterator = new EntryIterator(ObjectExtValue.this._entries);
            }

            @Override
            public boolean hasNext() {
                return this._iterator.hasNext();
            }

            @Override
            public Value next() {
                return new StringBuilderValue(this._iterator.next().getKey());
            }

            @Override
            public void remove() {
                this._iterator.remove();
            }
        };
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        Iterator<Value> iter = super.getValueIterator(env);
        if (iter != null) {
            return iter;
        }
        return new Iterator<Value>(){
            final Iterator<Map.Entry<String, Value>> _iterator;
            {
                this._iterator = new EntryIterator(ObjectExtValue.this._entries);
            }

            @Override
            public boolean hasNext() {
                return this._iterator.hasNext();
            }

            @Override
            public Value next() {
                return this._iterator.next().getValue();
            }

            @Override
            public void remove() {
                this._iterator.remove();
            }
        };
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._quercusClass.callMethod(env, (Value)this, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._quercusClass.callMethod(env, (Value)this, hash, name, nameLen, args);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen) {
        return this._quercusClass.callMethod(env, this, hash, name, nameLen);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0) {
        return this._quercusClass.callMethod(env, (Value)this, hash, name, nameLen, a0);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1) {
        return this._quercusClass.callMethod(env, this, hash, name, nameLen, a0, a1);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2) {
        return this._quercusClass.callMethod(env, this, hash, name, nameLen, a0, a1, a2);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3) {
        return this._quercusClass.callMethod(env, this, hash, name, nameLen, a0, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this._quercusClass.callMethod(env, this, hash, name, nameLen, a0, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        return this._quercusClass.callMethodRef(env, (Value)this, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value[] args) {
        return this._quercusClass.callMethodRef(env, (Value)this, hash, name, nameLen, args);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen) {
        return this._quercusClass.callMethodRef(env, this, hash, name, nameLen);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0) {
        return this._quercusClass.callMethodRef(env, (Value)this, hash, name, nameLen, a0);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1) {
        return this._quercusClass.callMethodRef(env, this, hash, name, nameLen, a0, a1);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2) {
        return this._quercusClass.callMethodRef(env, this, hash, name, nameLen, a0, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3) {
        return this._quercusClass.callMethodRef(env, this, hash, name, nameLen, a0, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3, Value a4) {
        return this._quercusClass.callMethodRef(env, this, hash, name, nameLen, a0, a1, a2, a3, a4);
    }

    @Override
    public Value callClassMethod(Env env, AbstractFunction fun, Value[] args) {
        return fun.callMethod(env, (Value)this, args);
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value getObject(Env env, Value index) {
        env.error(L.l("Can't use object '{0}' as array", (Object)this.getName()));
        return NullValue.NULL;
    }

    @Override
    public Value getObject(Env env, Location location, Value index) {
        env.error(location, L.l("Can't use object '{0}' as array", (Object)this.getName()));
        return NullValue.NULL;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Value clone() {
        ObjectExtValue newObject = new ObjectExtValue(this._quercusClass);
        for (Map.Entry<String, Value> entry : this.entrySet()) {
            newObject.putField(null, entry.getKey(), entry.getValue());
        }
        return newObject;
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("O:");
        sb.append(this._quercusClass.getName().length());
        sb.append(":\"");
        sb.append(this._quercusClass.getName());
        sb.append("\":");
        sb.append(this.getSize());
        sb.append(":{");
        for (Map.Entry<String, Value> entry : this.entrySet()) {
            String key = entry.getKey();
            sb.append("s:");
            sb.append(key.length());
            sb.append(":\"");
            sb.append(key);
            sb.append("\";");
            entry.getValue().serialize(sb);
        }
        sb.append("}");
    }

    @Override
    public StringValue toString(Env env) {
        AbstractFunction fun = this._quercusClass.findFunction("__toString");
        if (fun != null) {
            return fun.callMethod(env, (Value)this, new Expr[0]).toStringValue();
        }
        return env.createString(this._quercusClass.getName() + "[]");
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public Value toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<String, Value> entry : this.entrySet()) {
            ((ArrayValue)array).put(new StringBuilderValue(entry.getKey()), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<Map.Entry<String, Value>> entrySet() {
        return new EntrySet();
    }

    public Set<Map.Entry<String, Value>> sortedEntrySet() {
        return new TreeSet<Map.Entry<String, Value>>(this.entrySet());
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("object(" + this.getName() + ") (" + this.getSize() + ") {");
        for (Map.Entry<String, Value> mapEntry : this.sortedEntrySet()) {
            Entry entry = (Entry)mapEntry;
            entry.varDumpImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getName());
        out.print(' ');
        out.println("Object");
        this.printDepth(out, 4 * depth);
        out.println("(");
        for (Map.Entry<String, Value> mapEntry : this.sortedEntrySet()) {
            Entry entry = (Entry)mapEntry;
            entry.printRImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 4 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._quercusClass.getName());
        out.writeInt(this._size);
        for (Map.Entry<String, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Env env = Env.getInstance();
        String name = (String)in.readObject();
        QuercusClass cl = env.findClass(name);
        this.init();
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.putField(env, "__Quercus_Class_Definition_Not_Found", env.createString(name));
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.putField(env, (String)in.readObject(), (Value)in.readObject());
        }
    }

    public String toString() {
        return "ObjectExtValue@" + System.identityHashCode(this) + "[" + this._quercusClass.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Map.Entry<String, Value>,
    Comparable<Map.Entry<String, Value>> {
        private final String _key;
        private Value _value;

        public Entry(String key) {
            this._key = key;
            this._value = NullValue.NULL;
        }

        public Entry(String key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        @Override
        public String getKey() {
            return this._key;
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toRefVar() {
            Value val = this._value;
            if (val instanceof Var) {
                return (Var)val;
            }
            Var var = new Var(val);
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this.toValue();
            this._value = value;
            return oldValue;
        }

        public Value toRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new RefVar(var);
        }

        public Value toArgRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new RefVar(var);
        }

        public Value toArg() {
            Value value = this._value;
            if (value instanceof Var) {
                return value;
            }
            Var var = new Var(this._value);
            this._value = var;
            return var;
        }

        @Override
        public int compareTo(Map.Entry<String, Value> other) {
            if (other == null) {
                return 1;
            }
            String thisKey = this.getKey();
            String otherKey = other.getKey();
            if (thisKey == null) {
                return otherKey == null ? 0 : -1;
            }
            if (otherKey == null) {
                return 1;
            }
            return thisKey.compareTo(otherKey);
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 2 * depth);
            out.println("[\"" + this.getKey() + "\"]=>");
            this.printDepth(out, 2 * depth);
            this._value.varDump(env, out, depth, valueSet);
            out.println();
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 4 * depth);
            out.print("[" + this.getKey() + "] => ");
            this._value.printR(env, out, depth + 1, valueSet);
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = 0; i < depth; ++i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ObjectExtValue.Entry[" + this.getKey() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator
    implements Iterator<Map.Entry<String, Value>> {
        private final Entry[] _list;
        private int _index;

        EntryIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Map.Entry<String, Value> next() {
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            return this._list[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Map.Entry<String, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ObjectExtValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<String, Value>> iterator() {
            return new EntryIterator(ObjectExtValue.this._entries);
        }
    }
}

