/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectValue
extends Value {
    protected transient QuercusClass _quercusClass;

    protected ObjectValue(QuercusClass quercusClass) {
        this._quercusClass = quercusClass;
    }

    protected void setQuercusClass(QuercusClass cl) {
        this._quercusClass = cl;
    }

    public QuercusClass getQuercusClass() {
        return this._quercusClass;
    }

    @Override
    public String getClassName() {
        return this._quercusClass.getName();
    }

    public abstract Set<Map.Entry<String, Value>> entrySet();

    public String getName() {
        return this._quercusClass.getName();
    }

    public String getParentClassName() {
        return this._quercusClass.getParentName();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean isA(String name) {
        return this._quercusClass.isA(name);
    }

    @Override
    public long toLong() {
        return 1L;
    }

    @Override
    public double toDouble() {
        return this.toLong();
    }

    public Value putField(String key, String value) {
        return this.putField(null, key, new UnicodeValueImpl(value));
    }

    public Value putField(Env env, String key, String value) {
        return this.putField(env, key, env.createString(value));
    }

    public Value putField(String key, long value) {
        return this.putField(null, key, LongValue.create(value));
    }

    public Value putField(Env env, String key, long value) {
        return this.putField(env, key, LongValue.create(value));
    }

    public Value initField(Env env, String key, Value value) {
        return this.putField(env, key, value);
    }

    public Value putField(String key, double value) {
        return this.putField(null, key, DoubleValue.create(value));
    }

    @Override
    public boolean eq(Value rValue) {
        if (rValue.isObject()) {
            return this.cmpObject((ObjectValue)rValue) == 0;
        }
        return super.eq(rValue);
    }

    public int cmpObject(ObjectValue rValue) {
        Set<Map.Entry<String, Value>> bSet;
        if (rValue == this) {
            return 0;
        }
        int result = this.getName().compareTo(rValue.getName());
        if (result != 0) {
            return result;
        }
        Set<Map.Entry<String, Value>> aSet = this.entrySet();
        if (((Object)aSet).equals(bSet = rValue.entrySet())) {
            return 0;
        }
        if (aSet.size() > bSet.size()) {
            return 1;
        }
        if (aSet.size() < bSet.size()) {
            return -1;
        }
        TreeSet<Map.Entry<String, Value>> aTree = new TreeSet<Map.Entry<String, Value>>(aSet);
        TreeSet<Map.Entry<String, Value>> bTree = new TreeSet<Map.Entry<String, Value>>(bSet);
        Iterator<Map.Entry<String, Value>> iterA = aTree.iterator();
        Iterator<Map.Entry<String, Value>> iterB = bTree.iterator();
        while (iterA.hasNext()) {
            Map.Entry<String, Value> a = iterA.next();
            Map.Entry<String, Value> b = iterB.next();
            result = a.getKey().compareTo(b.getKey());
            if (result != 0) {
                return result;
            }
            result = a.getValue().cmp(b.getValue());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public int getCount(Env env) {
        return this._quercusClass.getCount(env, this);
    }

    @Override
    public int getCountRecursive(Env env) {
        return this._quercusClass.getCountRecursive(env, this);
    }

    @Override
    public Value get(Value key) {
        return this._quercusClass.get(Env.getInstance(), this, key);
    }

    @Override
    public Value get(Env env, Location location, Value key) {
        return this._quercusClass.get(env, this, key);
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return this._quercusClass.getIterator(env, this);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return this._quercusClass.getKeyIterator(env, this);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return this._quercusClass.getValueIterator(env, this);
    }

    @Override
    public Value put(Value key, Value value) {
        return this._quercusClass.put(Env.getInstance(), this, key, value);
    }

    @Override
    public Value put(Env env, Location location, Value key, Value value) {
        return this._quercusClass.put(env, this, key, value);
    }

    @Override
    public Value put(Value value) {
        return this._quercusClass.put(Env.getInstance(), this, value);
    }

    @Override
    public Value put(Env env, Location location, Value value) {
        return this._quercusClass.put(env, this, value);
    }

    @Override
    public Value remove(Value key) {
        return this._quercusClass.remove(Env.getInstance(), this, key);
    }

    public void varDumpObject(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        Map.Entry<Value, Value> entry;
        out.println("object(" + this.getName() + ") (" + this.getSize() + ") {");
        ArrayValueImpl sortedEntries = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            ((ArrayValue)sortedEntries).put(entry.getKey(), entry.getValue());
        }
        ArrayModule.ksort(env, sortedEntries, 2L);
        iter = sortedEntries.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            this.printDepth(out, 2 * depth);
            out.println("[\"" + key + "\"]=>");
            this.printDepth(out, 2 * ++depth);
            value.varDump(env, out, depth, valueSet);
            out.println();
            --depth;
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }
}

