/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputBuffer {
    public static final int PHP_OUTPUT_HANDLER_START = 0;
    public static final int PHP_OUTPUT_HANDLER_CONT = 1;
    public static final int PHP_OUTPUT_HANDLER_END = 2;
    private static final Logger log = Logger.getLogger(OutputBuffer.class.getName());
    private int _state;
    private boolean _haveFlushed;
    private Callback _callback;
    private final boolean _erase;
    private final int _chunkSize;
    private final int _level;
    private final OutputBuffer _next;
    private final TempStream _tempStream;
    private final WriteStream _out;
    private final Env _env;

    OutputBuffer(OutputBuffer next, Env env, Callback callback, int chunkSize, boolean erase) {
        block6: {
            this._next = next;
            this._level = this._next != null ? this._next._level + 1 : 1;
            this._erase = erase;
            this._chunkSize = chunkSize;
            this._env = env;
            this._callback = callback;
            this._tempStream = new TempStream();
            this._out = new WriteStream((StreamImpl)this._tempStream);
            String encoding = env.getOutputEncoding();
            if (encoding != null) {
                try {
                    this._out.setEncoding(env.getOutputEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    try {
                        this._out.setEncoding("UTF-8");
                    }
                    catch (UnsupportedEncodingException e2) {
                        if (!log.isLoggable(Level.WARNING)) break block6;
                        log.log(Level.WARNING, e.toString(), e2);
                    }
                }
            }
        }
        this._state = 1;
        this._haveFlushed = false;
    }

    public OutputBuffer getNext() {
        return this._next;
    }

    public WriteStream getOut() {
        return this._out;
    }

    public Value getContents() {
        try {
            int ch;
            this._out.flush();
            ReadStream rs = this._tempStream.openRead(false);
            StringValue bb = this._env.createBinaryBuilder();
            while ((ch = rs.read()) >= 0) {
                bb.appendByte(ch);
            }
            return bb;
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public long getLength() {
        try {
            this._out.flush();
            return this._tempStream.getLength();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
            return -1L;
        }
    }

    public int getLevel() {
        return this._level;
    }

    public boolean haveFlushed() {
        return this._haveFlushed;
    }

    public boolean getEraseFlag() {
        return this._erase;
    }

    public int getChunkSize() {
        return this._chunkSize;
    }

    public void clean() {
        try {
            this._out.flush();
            this._tempStream.clearWrite();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
        }
    }

    private void doFlush() {
        try {
            this._out.flush();
            ReadStream rs = this._tempStream.openRead(true);
            WriteStream out = this._next != null ? this._next.getOut() : this._env.getOriginalOut();
            rs.writeToStream((OutputStream)out);
            rs.close();
        }
        catch (IOException e) {
            this._env.error(e.toString(), e);
        }
    }

    private void callCallback() {
        if (this._callback != null) {
            Value result = this._callback.call(this._env, this.getContents(), LongValue.create(this._state));
            if (result == BooleanValue.FALSE) {
                return;
            }
            this.clean();
            try {
                if (result instanceof BytesValue) {
                    this._out.write(((BytesValue)result).toBytes());
                } else {
                    this._out.print(result.toString(this._env).toString());
                }
            }
            catch (IOException e) {
                this._env.error(e.toString(), e);
            }
        }
    }

    public void flush() {
        this._state |= 2;
        this.callCallback();
        this._state &= 0xFFFFFFFE;
        this._state &= 0xFFFFFFFD;
        this.doFlush();
        this._haveFlushed = true;
    }

    public void close() {
        this._state |= 4;
        this.callCallback();
        this._state = 0;
        this.doFlush();
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void setCallback(Callback callback) {
        this._callback = callback;
    }
}

