/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Post {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillPost(Env env, ArrayValue post, ArrayValue files, HttpServletRequest request, boolean addSlashesToValues) {
        InputStream is = null;
        try {
            if (request.getMethod().equals("POST")) {
                String contentType;
                String encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = env.getHttpInputEncoding().toString();
                }
                if ((contentType = request.getHeader("Content-Type")) != null) {
                    if (contentType.startsWith("application/x-www-form-urlencoded")) {
                        int ch;
                        is = request.getInputStream();
                        StringBuilder value = new StringBuilder();
                        while ((ch = is.read()) >= 0) {
                            value.append((char)ch);
                        }
                        StringUtility.parseStr(env, value.toString(), post, false, encoding);
                    } else if (contentType.startsWith("multipart/form-data")) {
                        String boundary = Post.getBoundary(contentType);
                        is = request.getInputStream();
                        ReadStream rs = new ReadStream((StreamImpl)new VfsStream(is, null));
                        MultipartStream ms = new MultipartStream(rs, boundary);
                        ms.setEncoding(encoding);
                        Post.readMultipartStream(env, ms, post, files, addSlashesToValues);
                        rs.close();
                    }
                }
                if (post.getSize() == 0) {
                    Post.putRequestMap(env, post, files, request, addSlashesToValues);
                }
            }
        }
        catch (IOException e) {
            env.warning(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMultipartStream(Env env, MultipartStream ms, ArrayValue post, ArrayValue files, boolean addSlashesToValues) throws IOException {
        ReadStream is;
        while ((is = ms.openRead()) != null) {
            String attr = (String)ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = Post.getAttribute(attr, "name");
            String filename = Post.getAttribute(attr, "filename");
            if (filename == null) {
                int ch;
                StringBuilder value = new StringBuilder();
                while ((ch = is.read()) >= 0) {
                    value.append((char)ch);
                }
                Post.addFormValue(env, post, name, env.createString(value.toString()), null, addSlashesToValues);
                continue;
            }
            Path tmpPath = env.getUploadDirectory().createTempFile("php", "tmp");
            env.addRemovePath(tmpPath);
            WriteStream os = tmpPath.openWrite();
            try {
                os.writeStream((InputStream)is);
            }
            finally {
                os.close();
            }
            Post.addFormFile(env, files, name, filename, tmpPath.getFullPath(), Post.getAttribute(attr, "mime-type"), tmpPath.getLength(), addSlashesToValues);
        }
    }

    private static void addFormFile(Env env, ArrayValue files, String name, String fileName, String tmpName, String mimeType, long fileLength, boolean addSlashesToValues) {
        long size;
        long uploadMaxFilesize;
        int p = name.indexOf(91);
        String index = "";
        if (p >= 0) {
            index = name.substring(p);
            name = name.substring(0, p);
        }
        StringValue nameValue = env.createString(name);
        Value v = files.get(nameValue).toValue();
        ArrayValue entry = null;
        if (v instanceof ArrayValue) {
            entry = (ArrayValue)v;
        }
        if (entry == null) {
            entry = new ArrayValueImpl();
            files.put(nameValue, entry);
        }
        int error = fileLength > (uploadMaxFilesize = env.getIniBytes("upload_max_filesize", 0x200000L)) ? 1 : 0;
        Post.addFormValue(env, entry, "name" + index, env.createString(fileName), null, addSlashesToValues);
        if (error != 1) {
            size = fileLength;
        } else {
            mimeType = "";
            tmpName = "";
            size = 0L;
        }
        if (mimeType != null) {
            Post.addFormValue(env, entry, "type" + index, env.createString(mimeType), null, addSlashesToValues);
            entry.put("type", mimeType);
        }
        Post.addFormValue(env, entry, "tmp_name" + index, env.createString(tmpName), null, addSlashesToValues);
        Post.addFormValue(env, entry, "error" + index, new LongValue(error), null, addSlashesToValues);
        Post.addFormValue(env, entry, "size" + index, new LongValue(size), null, addSlashesToValues);
        Post.addFormValue(env, files, name, entry, null, addSlashesToValues);
    }

    public static void addFormValue(Env env, ArrayValue array, String key, String[] formValueList, boolean addSlashesToValues) {
        String formValue = formValueList[formValueList.length - 1];
        Value value = formValue != null ? env.createString(formValue) : NullValue.NULL;
        Post.addFormValue(env, array, key, value, formValueList, addSlashesToValues);
    }

    public static void addFormValue(Env env, ArrayValue array, String key, Value formValue, String[] formValueList, boolean addSlashesToValues) {
        int p = key.indexOf(91);
        int q = key.indexOf(93, p);
        if (p >= 0 && p < q) {
            int p1;
            Value existingValue;
            StringValue keyValue;
            String index = key;
            if (p > 0) {
                keyValue = env.createString(key = key.substring(0, p));
                existingValue = array.get(keyValue);
                if (existingValue == null || !existingValue.isset()) {
                    existingValue = new ArrayValueImpl();
                    array.put(keyValue, existingValue);
                } else if (!existingValue.isArray()) {
                    existingValue = new ArrayValueImpl().put(existingValue);
                    array.put(keyValue, existingValue);
                }
                array = (ArrayValue)existingValue;
            }
            while ((p1 = index.indexOf(91, q)) > 0) {
                key = index.substring(p + 1, q);
                if (key.equals("")) {
                    existingValue = new ArrayValueImpl();
                    array.put(existingValue);
                } else {
                    keyValue = env.createString(key);
                    existingValue = array.get(keyValue);
                    if (existingValue == null || !existingValue.isset()) {
                        existingValue = new ArrayValueImpl();
                        array.put(keyValue, existingValue);
                    } else if (!existingValue.isArray()) {
                        existingValue = new ArrayValueImpl().put(existingValue);
                        array.put(keyValue, existingValue);
                    }
                }
                array = (ArrayValue)existingValue;
                p = p1;
                q = index.indexOf(93, p);
            }
            index = q > 0 ? index.substring(p + 1, q) : index.substring(p + 1);
            if (index.equals("")) {
                if (formValueList != null) {
                    for (int i = 0; i < formValueList.length; ++i) {
                        Value value = formValueList[i] != null ? env.createString(formValueList[i]) : NullValue.NULL;
                        Post.put(array, null, value, addSlashesToValues);
                    }
                } else {
                    array.put(formValue);
                }
            } else if ('0' <= index.charAt(0) && index.charAt(0) <= '9') {
                Post.put(array, new LongValue(StringValue.toLong(index)), formValue, addSlashesToValues);
            } else {
                Post.put(array, env.createString(index), formValue, addSlashesToValues);
            }
        } else {
            Post.put(array, env.createString(key), formValue, addSlashesToValues);
        }
    }

    private static void put(ArrayValue array, Value key, Value value, boolean addSlashes) {
        if (addSlashes && value instanceof StringValue) {
            value = StringModule.addslashes(value.toStringValue());
        }
        if (key == null) {
            array.put(value);
        } else {
            array.put(key, value);
        }
    }

    private static String getBoundary(String contentType) {
        int i = contentType.indexOf("boundary=");
        if (i < 0) {
            return null;
        }
        int length = contentType.length();
        if (length <= (i += "boundary=".length())) {
            return null;
        }
        char ch = contentType.charAt(i);
        if (ch == '\'') {
            StringBuilder sb = new StringBuilder();
            ++i;
            while (i < length && (ch = contentType.charAt(i)) != '\'') {
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        if (ch == '\"') {
            StringBuilder sb = new StringBuilder();
            ++i;
            while (i < length && (ch = contentType.charAt(i)) != '\"') {
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private static String getAttribute(String attr, String name) {
        StringBuilder value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = new StringBuilder();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.toString();
    }

    private static void putRequestMap(Env env, ArrayValue post, ArrayValue files, HttpServletRequest request, boolean addSlashesToValues) {
        Map map = request.getParameterMap();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            int len = key.length();
            if (len < 10 || !key.endsWith(".filename")) continue;
            String name = key.substring(0, len - 9);
            String[] fileNames = request.getParameterValues(name + ".filename");
            String[] tmpNames = request.getParameterValues(name + ".file");
            String[] mimeTypes = request.getParameterValues(name + ".content-type");
            for (int i = 0; i < fileNames.length; ++i) {
                long fileLength = new FilePath(tmpNames[i]).getLength();
                Post.addFormFile(env, files, name, fileNames[i], tmpNames[i], mimeTypes[i], fileLength, addSlashesToValues);
            }
        }
        ArrayList keys = new ArrayList();
        keys.addAll(request.getParameterMap().keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String[] value = request.getParameterValues(key);
            Post.addFormValue(env, post, key, value, addSlashesToValues);
        }
    }
}

