/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.ClassConstExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.StringLiteralExpr;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.InstanceInitializer;
import com.caucho.util.IdentityIntMap;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusClass {
    private final L10N L = new L10N(QuercusClass.class);
    private final Logger log = Logger.getLogger(QuercusClass.class.getName());
    private final ClassDef _classDef;
    private ClassDef[] _classDefList;
    private QuercusClass _parent;
    private AbstractFunction _constructor;
    private AbstractFunction _get;
    private AbstractFunction _set;
    private AbstractFunction _call;
    private ArrayDelegate _arrayDelegate = new DefaultArrayDelegate();
    private final ArrayList<InstanceInitializer> _initializers = new ArrayList();
    private final ArrayList<String> _fieldNames = new ArrayList();
    private final IdentityIntMap _fieldMap = new IdentityIntMap();
    private final HashMap<StringValue, Expr> _fieldInitMap = new HashMap();
    private final MethodMap<AbstractFunction> _methodMap = new MethodMap();
    private final IdentityHashMap<String, Expr> _constMap = new IdentityHashMap();
    private final HashMap<String, ArrayList<StaticField>> _staticFieldExprMap = new LinkedHashMap<String, ArrayList<StaticField>>();
    private final HashMap<String, Var> _staticFieldMap = new HashMap();

    public QuercusClass(ClassDef classDef, QuercusClass parent) {
        this(ModuleContext.getLocalContext(Thread.currentThread().getContextClassLoader()), classDef, parent);
    }

    public QuercusClass(ModuleContext moduleContext, ClassDef classDef, QuercusClass parent) {
        ClassDef[] classDefList;
        this._classDef = classDef;
        this._parent = parent;
        for (QuercusClass cls = parent; cls != null; cls = cls.getParent()) {
            AbstractFunction cons = cls.getConstructor();
            if (cons == null) continue;
            this.addMethod(cls.getName(), cons);
        }
        if (this._parent != null) {
            classDefList = new ClassDef[parent._classDefList.length + 1];
            System.arraycopy(parent._classDefList, 0, classDefList, 1, parent._classDefList.length);
            classDefList[0] = classDef;
        } else {
            classDefList = new ClassDef[]{classDef};
        }
        this._classDefList = classDefList;
        HashSet<String> ifaces = new HashSet<String>();
        for (int i = classDefList.length - 1; i >= 0; --i) {
            classDef = classDefList[i];
            if (classDef == null) {
                throw new NullPointerException("classDef:" + this._classDef + " i:" + i + " parent:" + parent);
            }
            classDef.init();
            for (String iface : classDef.getInterfaces()) {
                ClassDef ifaceDef = Env.getInstance().findClass(iface).getClassDef();
                if (ifaceDef == null || !ifaces.add(iface)) continue;
                ifaceDef.initClass(this);
            }
            classDef.initClass(this);
        }
        if (this._constructor == null && parent != null) {
            this._constructor = parent.getConstructor();
        }
    }

    public ClassDef getClassDef() {
        return this._classDef;
    }

    public String getName() {
        return this._classDef.getName();
    }

    public QuercusClass getParent() {
        return this._parent;
    }

    public boolean isInterface() {
        return this._classDef.isInterface();
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public AbstractFunction getConstructor() {
        return this._constructor;
    }

    public void addArrayDelegate(ArrayDelegate delegate) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.L.l("{0} adding delegate {1}", (Object)this, (Object)delegate));
        }
        delegate.init(this._arrayDelegate);
        this._arrayDelegate = delegate;
    }

    public void setGet(AbstractFunction fun) {
        this._get = fun;
    }

    public void setSet(AbstractFunction fun) {
        this._set = fun;
    }

    public AbstractFunction getSetField() {
        return this._set;
    }

    public void setCall(AbstractFunction fun) {
        this._call = fun;
    }

    public AbstractFunction getCall() {
        return this._call;
    }

    public void addInitializer(InstanceInitializer init) {
        this._initializers.add(init);
    }

    public void addField(String name, int index, Expr initExpr) {
        this._fieldNames.add(name);
        this._fieldMap.put((Object)name, index);
        this._fieldInitMap.put(new StringBuilderValue(name), initExpr);
    }

    public int addFieldIndex(String name) {
        int index = this._fieldMap.get((Object)name);
        if (index >= 0) {
            return index;
        }
        index = this._fieldNames.size();
        this._fieldMap.put((Object)name, index);
        this._fieldNames.add(name);
        return index;
    }

    public HashMap<StringValue, Expr> getClassVars() {
        return this._fieldInitMap;
    }

    public Iterable<AbstractFunction> getClassMethods() {
        return this._methodMap.values();
    }

    public void addMethod(String name, AbstractFunction fun) {
        this._methodMap.put(name, fun);
    }

    public void addStaticFieldExpr(String className, String name, Expr value) {
        ArrayList<StaticField> fieldList = this._staticFieldExprMap.get(className);
        if (fieldList == null) {
            fieldList = new ArrayList();
            this._staticFieldExprMap.put(className, fieldList);
        }
        fieldList.add(new StaticField(name, value));
    }

    public void addConstant(String name, Expr expr) {
        this._constMap.put(name, expr);
    }

    public int getFieldSize() {
        return this._fieldNames.size();
    }

    public int findFieldIndex(String name) {
        return this._fieldMap.get((Object)name);
    }

    public ArrayList<String> getFieldNames() {
        return this._fieldNames;
    }

    public void validate(Env env) {
        if (!this._classDef.isAbstract() && !this._classDef.isInterface()) {
            for (AbstractFunction fun : this._methodMap.values()) {
                boolean isAbstract = this._constructor != null && fun.getName().equals(this._constructor.getName()) ? this._constructor.isAbstract() : fun.isAbstract();
                if (!isAbstract) continue;
                throw env.createErrorException(this._classDef.getLocation(), this.L.l("Abstract function '{0}' must be implemented in concrete class {1}.", (Object)fun.getName(), (Object)this.getName()));
            }
        }
    }

    public void init(Env env) {
        for (Map.Entry<String, ArrayList<StaticField>> map : this._staticFieldExprMap.entrySet()) {
            if (env.isInitializedClass(map.getKey())) continue;
            for (StaticField field : map.getValue()) {
                Expr expr = field._expr;
                Value val = expr instanceof ClassConstExpr ? ((ClassConstExpr)expr).eval(env) : expr.eval(env);
                Var var = new Var();
                var.set(val);
                this._staticFieldMap.put(field._name, var);
            }
            env.addInitializedClass(map.getKey());
        }
    }

    public Var getStaticField(String name) {
        Var var = this._staticFieldMap.get(name);
        if (var != null) {
            return var;
        }
        QuercusClass parent = this.getParent();
        if (parent != null) {
            var = parent.getStaticField(name);
        }
        return var;
    }

    public Value callNew(Env env, Expr[] args) {
        Value object = this._classDef.callNew(env, args);
        if (object != null) {
            return object;
        }
        object = this.newInstance(env);
        AbstractFunction fun = this.findConstructor();
        if (fun != null) {
            fun.callMethod(env, object, args);
        }
        return object;
    }

    public Value callNew(Env env, Value[] args) {
        Value object = this._classDef.callNew(env, args);
        if (object != null) {
            return object;
        }
        object = this.newInstance(env);
        AbstractFunction fun = this.findConstructor();
        if (fun != null) {
            fun.callMethod(env, object, args);
        }
        return object;
    }

    public String getParentName() {
        return this._classDefList[0].getParentName();
    }

    public boolean isA(String name) {
        for (int i = this._classDefList.length - 1; i >= 0; --i) {
            if (!this._classDefList[i].isA(name)) continue;
            return true;
        }
        return false;
    }

    public ObjectValue newInstance(Env env) {
        ObjectValue obj = this._classDef.newInstance(env, this);
        for (int i = 0; i < this._initializers.size(); ++i) {
            this._initializers.get(i).initInstance(env, obj);
        }
        return obj;
    }

    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    public int getCount(Env env, ObjectValue obj) {
        return this._arrayDelegate.getCount(env, obj);
    }

    public int getCountRecursive(Env env, ObjectValue obj) {
        return this._arrayDelegate.getCountRecursive(env, obj);
    }

    public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue obj) {
        return this._arrayDelegate.getIterator(env, obj);
    }

    public Iterator<Value> getKeyIterator(Env env, ObjectValue obj) {
        return this._arrayDelegate.getKeyIterator(env, obj);
    }

    public Iterator<Value> getValueIterator(Env env, ObjectValue obj) {
        return this._arrayDelegate.getValueIterator(env, obj);
    }

    public Value get(Env env, ObjectValue obj, Value key) {
        return this._arrayDelegate.get(env, obj, key);
    }

    public Value put(Env env, ObjectValue obj, Value key, Value value) {
        return this._arrayDelegate.put(env, obj, key, value);
    }

    public Value put(Env env, ObjectValue obj, Value value) {
        return this._arrayDelegate.put(env, obj, value);
    }

    public Value remove(Env env, ObjectValue obj, Value key) {
        return this._arrayDelegate.remove(env, obj, key);
    }

    public Value getField(Env env, Value qThis, String name, boolean create) {
        if (this._get != null) {
            return this._get.callMethod(env, qThis, env.createString(name));
        }
        return UnsetValue.UNSET;
    }

    public void setField(Env env, Value qThis, String name, Value value) {
        if (this._set != null) {
            this._set.callMethod(env, qThis, env.createString(name), value);
        }
    }

    public AbstractFunction findFunction(String name) {
        char[] key = name.toCharArray();
        int hash = MethodMap.hash(key, key.length);
        AbstractFunction fun = this._methodMap.get(hash, key, key.length);
        return fun;
    }

    public AbstractFunction findFunctionExact(String name) {
        throw new UnsupportedOperationException();
    }

    public AbstractFunction findFunctionLowerCase(String name) {
        throw new UnsupportedOperationException();
    }

    public AbstractFunction findStaticFunction(String name) {
        return this.findFunction(name);
    }

    public final AbstractFunction getFunction(String name) {
        char[] key = name.toCharArray();
        int hash = MethodMap.hash(key, key.length);
        return this.getFunction(hash, key, key.length);
    }

    public final AbstractFunction getFunction(int hash, char[] name, int nameLen) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun;
        }
        throw new QuercusRuntimeException(this.L.l("{0}::{1} is an unknown method", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLength, Expr[] args) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLength);
        if (fun != null) {
            return fun.callMethod(env, thisValue, args);
        }
        if (this.getCall() != null) {
            Expr[] newArgs = new Expr[args.length + 1];
            newArgs[0] = new StringLiteralExpr(this.toMethod(name, nameLength));
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return this.getCall().callMethod(env, thisValue, newArgs);
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}", (Object)this.getName(), (Object)this.toMethod(name, nameLength)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value[] args) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, args);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl(args));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl());
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, a1);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, a1, a2);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, a1, a2, a3);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, a1, a2, a3, a4);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethod(env, thisValue, a1, a2, a3, a4, a5);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Expr[] args) {
        AbstractFunction fun = this.getFunction(hash, name, nameLen);
        return fun.callMethodRef(env, thisValue, args);
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value[] args) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, args);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl(args));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl());
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, a1);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, a1, a2);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, a1, a2, a3);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, a1, a2, a3, a4);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun.callMethodRef(env, thisValue, a1, a2, a3, a4, a5);
        }
        if (this.getCall() != null) {
            return this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
        }
        return env.error(this.L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    private String toMethod(char[] key, int keyLength) {
        return new String(key, 0, keyLength);
    }

    public AbstractFunction findStaticFunctionLowerCase(String name) {
        return null;
    }

    public final AbstractFunction getStaticFunction(String name) {
        AbstractFunction fun = this.findStaticFunction(name);
        if (fun != null) {
            return fun;
        }
        throw new QuercusRuntimeException(this.L.l("{0}::{1} is an unknown method", (Object)this.getName(), (Object)name));
    }

    public final Value getConstant(Env env, String name) {
        Expr expr = this._constMap.get(name);
        if (expr != null) {
            return expr.eval(env);
        }
        throw new QuercusRuntimeException(this.L.l("{0}::{1} is an unknown constant", (Object)this.getName(), (Object)name));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultArrayDelegate
    extends ArrayDelegate {
        @Override
        public int getCount(Env env, ObjectValue obj) {
            return 1;
        }

        @Override
        public int getCountRecursive(Env env, ObjectValue obj) {
            return this.getCount(env, obj);
        }

        private Value arrayerror(Env env, ObjectValue obj) {
            String name = obj.getName();
            env.error(env.getLocation(), QuercusClass.this.L.l("Can't use object '{0}' as array", (Object)name));
            return UnsetValue.UNSET;
        }

        @Override
        public Value get(Env env, ObjectValue obj, Value offset) {
            return this.arrayerror(env, obj);
        }

        @Override
        public Value put(Env env, ObjectValue obj, Value value) {
            return this.arrayerror(env, obj);
        }

        @Override
        public Value put(Env env, ObjectValue obj, Value offset, Value value) {
            return this.arrayerror(env, obj);
        }

        @Override
        public Value remove(Env env, ObjectValue obj, Value offset) {
            return this.arrayerror(env, obj);
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue obj) {
            return null;
        }

        @Override
        public Iterator<Value> getKeyIterator(Env env, ObjectValue obj) {
            return null;
        }

        @Override
        public Iterator<Value> getValueIterator(Env env, ObjectValue obj) {
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + QuercusClass.this.getName() + "]";
        }
    }

    static class StaticField {
        String _name;
        Expr _expr;

        StaticField(String name, Expr expr) {
            this._name = name;
            this._expr = expr;
        }
    }
}

