/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerArrayValue
extends ArrayValueImpl {
    private static final StringValue SERVER_NAME_V = new StringBuilderValue("SERVER_NAME");
    private static final StringValue SERVER_PORT_V = new StringBuilderValue("SERVER_PORT");
    private static final StringValue REMOTE_HOST_V = new StringBuilderValue("REMOTE_HOST");
    private static final StringValue REMOTE_ADDR_V = new StringBuilderValue("REMOTE_ADDR");
    private static final StringValue REMOTE_PORT_V = new StringBuilderValue("REMOTE_PORT");
    private static final StringValue DOCUMENT_ROOT_V = new StringBuilderValue("DOCUMENT_ROOT");
    private static final StringValue SERVER_PROTOCOL_V = new StringBuilderValue("SERVER_PROTOCOL");
    private static final StringValue REQUEST_METHOD_V = new StringBuilderValue("REQUEST_METHOD");
    private static final StringValue QUERY_STRING_V = new StringBuilderValue("QUERY_STRING");
    private static final StringValue REQUEST_URI_V = new StringBuilderValue("REQUEST_URI");
    private static final StringValue SCRIPT_NAME_V = new StringBuilderValue("SCRIPT_NAME");
    private static final StringValue SCRIPT_FILENAME_V = new StringBuilderValue("SCRIPT_FILENAME");
    private static final StringValue PATH_INFO_V = new StringBuilderValue("PATH_INFO");
    private static final StringValue PATH_TRANSLATED_V = new StringBuilderValue("PATH_TRANSLATED");
    private static final StringValue PHP_SELF_V = new StringBuilderValue("PHP_SELF");
    private static final StringValue HTTPS_V = new StringBuilderValue("HTTPS");
    private static final StringValue HTTP_HOST_V = new StringBuilderValue("HTTP_HOST");
    private final Env _env;
    private boolean _isFilled;

    public ServerArrayValue(Env env) {
        this._env = env;
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Value put(Value key, Value value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.put(key, value);
    }

    @Override
    public Value put(Value value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.put(value);
    }

    @Override
    public Value get(Value key) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.get(key);
    }

    @Override
    public Var getRef(Value key) {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.getRef(key);
    }

    @Override
    public Value copy() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return new ArrayValueImpl(this);
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return super.entrySet();
    }

    @Override
    public void put(String key, String value) {
        if (!this._isFilled) {
            this.fillMap();
        }
        super.put(this._env.createString(key), this._env.createString(value));
    }

    @Override
    public void print(Env env) {
        env.print("Array");
    }

    private void fillMap() {
        if (this._isFilled) {
            return;
        }
        this._isFilled = true;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            super.put(this._env.createString(entry.getKey()), this._env.createString(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this._env.getQuercus().getServerEnvMap().entrySet()) {
            super.put((Value)entry.getKey(), (Value)entry.getValue());
        }
        HttpServletRequest request = this._env.getRequest();
        if (request != null) {
            String root;
            super.put(SERVER_NAME_V, this._env.createString(request.getServerName()));
            super.put(SERVER_PORT_V, new LongValue(request.getServerPort()));
            super.put(REMOTE_HOST_V, this._env.createString(request.getRemoteHost()));
            super.put(REMOTE_ADDR_V, this._env.createString(request.getRemoteAddr()));
            super.put(REMOTE_PORT_V, new LongValue(request.getRemotePort()));
            super.put(SERVER_PROTOCOL_V, this._env.createString(request.getProtocol()));
            super.put(REQUEST_METHOD_V, this._env.createString(request.getMethod()));
            String string = QuercusRequestAdapter.getPageQueryString(request);
            String requestURI = QuercusRequestAdapter.getPageURI(request);
            String servletPath = QuercusRequestAdapter.getPageServletPath(request);
            String pathInfo = QuercusRequestAdapter.getPagePathInfo(request);
            String contextPath = QuercusRequestAdapter.getPageContextPath(request);
            if (string != null) {
                super.put(QUERY_STRING_V, this._env.createString(string));
            }
            if ((root = request.getRealPath("/")).indexOf(92) >= 0) {
                root = root.replace('\\', '/');
                root = '/' + root;
            }
            super.put(DOCUMENT_ROOT_V, this._env.createString(root));
            super.put(SCRIPT_NAME_V, this._env.createString(contextPath + servletPath));
            if (string != null) {
                requestURI = requestURI + '?' + string;
            }
            super.put(REQUEST_URI_V, this._env.createString(requestURI));
            super.put(SCRIPT_FILENAME_V, this._env.createString(request.getRealPath(servletPath)));
            if (pathInfo != null) {
                super.put(PATH_INFO_V, this._env.createString(pathInfo));
                super.put(PATH_TRANSLATED_V, this._env.createString(request.getRealPath(pathInfo)));
            }
            if (request.isSecure()) {
                super.put(HTTPS_V, this._env.createString("on"));
            }
            if (pathInfo == null) {
                super.put(PHP_SELF_V, this._env.createString(contextPath + servletPath));
            } else {
                super.put(PHP_SELF_V, this._env.createString(contextPath + servletPath + pathInfo));
            }
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = request.getHeader(key);
                if (key.equalsIgnoreCase("Host")) {
                    super.put(HTTP_HOST_V, this._env.createString(value));
                    continue;
                }
                super.put(this.convertHttpKey(key), this._env.createString(value));
            }
        }
    }

    private StringValue convertHttpKey(String key) {
        StringValue sb = this._env.createUnicodeBuilder();
        sb.append("HTTP_");
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            if (Character.isLowerCase(ch)) {
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            if (ch == '-') {
                sb.append('_');
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private Object writeReplace() {
        if (!this._isFilled) {
            this.fillMap();
        }
        return new ArrayValueImpl(this);
    }
}

