/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionCallback
extends Value {
    private static final Logger log = Logger.getLogger(SessionCallback.class.getName());
    private Callback _open;
    private Callback _close;
    private Callback _read;
    private Callback _write;
    private Callback _destroy;
    private Callback _gc;

    public SessionCallback(Callback open, Callback close, Callback read, Callback write, Callback destroy, Callback gc) {
        this._open = open;
        this._close = close;
        this._read = read;
        this._write = write;
        this._destroy = destroy;
        this._gc = gc;
    }

    public void open(Env env, String savePath, String sessionName) {
        this._open.call(env, env.createString(savePath), env.createString(sessionName));
    }

    public StringValue read(Env env, String id) {
        try {
            Value value = this._read.call(env, env.createString(id));
            if (value instanceof StringValue) {
                return (StringValue)value;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public void write(Env env, String id, String value) {
        try {
            this._write.call(env, env.createString(id), env.createString(value));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void destroy(Env env, String id) {
        try {
            this._destroy.call(env, env.createString(id));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close(Env env) {
        try {
            this._close.call(env);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }
}

