/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringValue
extends Value
implements CharSequence {
    public static final StringValue EMPTY = new StringBuilderValue("");
    private static final StringValue[] CHAR_STRINGS = new StringValue[256];
    protected static final int IS_STRING = 0;
    protected static final int IS_LONG = 1;
    protected static final int IS_DOUBLE = 2;

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new StringBuilderValue(value);
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new StringBuilderValue(String.valueOf(value));
    }

    public static Value create(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new StringBuilderValue(value.toString());
    }

    public StringValue create(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return unicodeStr;
        }
        try {
            StringValue sb = this.createEmptyStringBuilder();
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            sb.append(bytes);
            return sb;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return unicodeStr;
        }
    }

    public abstract StringValue createEmptyStringBuilder();

    public abstract StringValue getEmptyString();

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public boolean isLongConvertible() {
        return this.getValueType().isLongCmp();
    }

    @Override
    public boolean isDoubleConvertible() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public boolean isPHP5String() {
        return false;
    }

    @Override
    public int cmp(Value rValue) {
        if (this.isNumberConvertible() || rValue.isNumberConvertible()) {
            double r;
            double l = this.toDouble();
            if (l == (r = rValue.toDouble())) {
                return 0;
            }
            if (l < r) {
                return -1;
            }
            return 1;
        }
        return this.toString().compareTo(rValue.toString());
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeA = this.getValueType();
        ValueType typeB = rValue.getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        return this.toString().equals(rValue.toString());
    }

    public int cmpString(StringValue rValue) {
        if (this.isNumberConvertible() && rValue.isNumberConvertible()) {
            double rDouble;
            double thisDouble = this.toDouble();
            if (thisDouble < (rDouble = rValue.toDouble())) {
                return -1;
            }
            if (thisDouble > rDouble) {
                return 1;
            }
            return 0;
        }
        return this.toString().compareTo(rValue.toString());
    }

    @Override
    public StringValue toStringValue() {
        return this;
    }

    public static long toLong(String string) {
        if (string.equals("")) {
            return 0L;
        }
        int len = string.length();
        long value = 0L;
        long sign = 1L;
        int i = 0;
        char ch = string.charAt(0);
        if (ch == '-') {
            sign = -1L;
            i = 1;
        } else if (ch == '+') {
            i = 1;
        }
        while (i < len) {
            ch = string.charAt(i);
            if ('0' > ch || ch > '9') {
                return sign * value;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return value;
    }

    @Override
    public double toDouble() {
        return StringValue.toDouble(this.toString());
    }

    public static double toDouble(String s) {
        int len = s.length();
        int i = 0;
        char ch = '\u0000';
        if (i < len && ((ch = s.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = s.charAt(i)) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        if (i == len) {
            return Double.parseDouble(s);
        }
        return Double.parseDouble(s.substring(0, i));
    }

    @Override
    public boolean toBoolean() {
        int length = this.length();
        if (length == 0) {
            return false;
        }
        if (length > 1) {
            return true;
        }
        return this.charAt(0) != '0';
    }

    @Override
    public Value toKey() {
        int len = this.length();
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        char ch = this.charAt(i);
        if (ch == '-') {
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = this.charAt(i);
            if ('0' > ch || ch > '9') {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return LongValue.create((long)sign * value);
    }

    @Override
    public Object toJavaObject() {
        return this.toString();
    }

    @Override
    public Object valuesToArray(Env env, Class elementType) {
        if (Character.TYPE.equals(elementType)) {
            return this.toUnicodeValue(env).toCharArray();
        }
        if (Character.class.equals((Object)elementType)) {
            char[] chars = this.toUnicodeValue(env).toCharArray();
            int length = chars.length;
            Character[] charObjects = new Character[length];
            for (int i = 0; i < length; ++i) {
                charObjects[i] = Character.valueOf(chars[i]);
            }
            return charObjects;
        }
        if (Byte.TYPE.equals(elementType)) {
            return this.toBinaryValue(env).toBytes();
        }
        if (Byte.class.equals((Object)elementType)) {
            byte[] bytes = this.toBinaryValue(env).toBytes();
            int length = bytes.length;
            Byte[] byteObjects = new Byte[length];
            for (int i = 0; i < length; ++i) {
                byteObjects[i] = bytes[i];
            }
            return byteObjects;
        }
        env.error(L.l("Can't assign {0} with type {1} to {2}", (Object)this, this.getClass(), (Object)elementType));
        return null;
    }

    @Override
    public Value toAutoArray() {
        if (this.length() == 0) {
            return new ArrayValueImpl();
        }
        return this;
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getArg(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getRef(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value charValueAt(long index) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        return StringValue.create(this.charAt((int)index));
    }

    @Override
    public Value setCharValueAt(long index, String value) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return this;
        }
        return this.createStringBuilder().append(this, 0, (int)index).append(value).append(this, (int)(index + 1L), this.length());
    }

    @Override
    public Value preincr(int incr) {
        return this.postincr(incr);
    }

    @Override
    public Value postincr(int incr) {
        if (this.length() == 0) {
            if (incr == 1) {
                return this.createStringBuilder().append("1");
            }
            return LongValue.MINUS_ONE;
        }
        if (incr > 0) {
            StringBuilder tail = new StringBuilder();
            for (int i = this.length() - 1; i >= 0; --i) {
                char ch = this.charAt(i);
                if (ch == 'z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("aa").append(tail);
                    }
                    tail.insert(0, 'a');
                    continue;
                }
                if ('a' <= ch && ch < 'z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if (ch == 'Z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("AA").append(tail);
                    }
                    tail.insert(0, 'A');
                    continue;
                }
                if ('A' <= ch && ch < 'Z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if ('0' > ch || ch > '9' || i != this.length() - 1) continue;
                return LongValue.create(this.toLong() + (long)incr);
            }
            return this.createStringBuilder().append(tail.toString());
        }
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + (long)incr);
        }
        return this;
    }

    @Override
    public Value add(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + rValue);
        }
        return DoubleValue.create(this.toDouble() + (double)rValue);
    }

    @Override
    public Value sub(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() - rValue);
        }
        return DoubleValue.create(this.toDouble() - (double)rValue);
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("s:");
        sb.append(this.length());
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    public StringValue append(String s) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(String s, int start, int end) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue append(CharSequence buf, int head, int tail) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(UnicodeBuilderValue sb, int head, int tail) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return this.append(unicodeStr);
        }
        try {
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            this.append(bytes);
            return this;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return this.append(unicodeStr);
        }
    }

    public StringValue append(char v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Value v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void ensureAppendCapacity(int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue append(Reader reader) throws IOException {
        int ch;
        while ((ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public StringValue append(Reader reader, long length) throws IOException {
        int ch;
        while (length-- > 0L && (ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public StringValue append(InputStream is) {
        try {
            int ch;
            while ((ch = is.read()) >= 0) {
                this.appendByte(ch);
            }
            return this;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue append(InputStream is, long length) {
        try {
            int ch;
            while (length-- > 0L && (ch = is.read()) >= 0) {
                this.appendByte(ch);
            }
            return this;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue append(BinaryInput is) {
        try {
            int ch;
            while ((ch = is.read()) >= 0) {
                this.appendByte(ch);
            }
            return this;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue append(BinaryInput is, long length) {
        try {
            TempBuffer buf = TempBuffer.allocate();
            int sublen = buf.getBuffer().length;
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((sublen = is.read(buf.getBuffer(), 0, sublen)) > 0) {
                this.append(buf.getBuffer(), 0, sublen);
            }
            TempBuffer.free((TempBuffer)buf);
            return this;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue appendAll(BinaryInput is, long length) {
        try {
            int ch;
            while (length-- > 0L && (ch = is.read()) >= 0) {
                this.appendByte(ch);
            }
            return this;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            sb.append(this.charAt(i));
        }
        return this;
    }

    public StringValue appendUnicode(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue appendUnicode(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(char v) {
        return this.append(v);
    }

    public StringValue appendUnicode(char[] buffer, int offset, int length) {
        return this.append(buffer, offset, length);
    }

    public StringValue appendUnicode(String value) {
        return this.append(value);
    }

    public StringValue appendUnicode(String value, int offset, int length) {
        return this.append(value, offset, length);
    }

    public StringValue appendUnicode(Value value) {
        return this.append(value);
    }

    public StringValue appendByte(int v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue appendBytes(String s) {
        StringValue sb = this;
        for (int i = 0; i < s.length(); ++i) {
            sb = sb.appendByte(s.charAt(i));
        }
        return sb;
    }

    public StringValue appendBytes(char[] buf, int offset, int length) {
        StringValue sb = this;
        int end = Math.min(buf.length, offset + length);
        while (offset < end) {
            sb = sb.appendByte(buf[offset++]);
        }
        return sb;
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append("'");
        String value = this.toString();
        int len = value.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("'");
    }

    public StringValue intern(Quercus quercus) {
        return quercus.intern(this.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringBuilderValue(this.toString().substring(start, end));
    }

    public final int indexOf(CharSequence match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(CharSequence match, int head) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (head < 0) {
            return -1;
        }
        int end = length - matchLength;
        char first = match.charAt(0);
        while (head <= end) {
            block6: {
                if (this.charAt(head) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(head + i) == match.charAt(i)) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    public int indexOf(char match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(char match, int head) {
        int length = this.length();
        while (head < length) {
            if (this.charAt(head) == match) {
                return head;
            }
            ++head;
        }
        return -1;
    }

    public final int lastIndexOf(char match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(char match, int tail) {
        int length = this.length();
        if (tail >= length) {
            tail = length - 1;
        }
        while (tail >= 0) {
            if (this.charAt(tail) == match) {
                return tail;
            }
            --tail;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(CharSequence match, int tail) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (tail < 0) {
            return -1;
        }
        if (tail > length - matchLength) {
            tail = length - matchLength;
        }
        char first = match.charAt(0);
        while (tail >= 0) {
            block7: {
                if (this.charAt(tail) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(tail + i) == match.charAt(i)) {
                            continue;
                        }
                        break block7;
                    }
                    return tail;
                }
            }
            --tail;
        }
        return -1;
    }

    public StringValue substring(int head) {
        return (StringValue)this.subSequence(head, this.length());
    }

    public StringValue substring(int begin, int end) {
        return (StringValue)this.subSequence(begin, end);
    }

    public char[] toCharArray() {
        int length = this.length();
        char[] array = new char[this.length()];
        this.getChars(0, array, 0, length);
        return array;
    }

    public char[] getRawCharArray() {
        return this.toCharArray();
    }

    public void getChars(int stringOffset, char[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.charAt(stringOffset + i);
        }
    }

    public StringValue toLowerCase() {
        int length = this.length();
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] buffer = string.getBuffer();
        this.getChars(0, buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = buffer[i];
            if ('A' <= ch && ch <= 'Z') {
                buffer[i] = (char)(ch + 97 - 65);
                continue;
            }
            if (ch < '\u0080' || !Character.isUpperCase(ch)) continue;
            buffer[i] = Character.toLowerCase(ch);
        }
        string.setOffset(length);
        return string;
    }

    public StringValue toUpperCase() {
        int length = this.length();
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] buffer = string.getBuffer();
        this.getChars(0, buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = buffer[i];
            if ('a' <= ch && ch <= 'z') {
                buffer[i] = (char)(ch + 65 - 97);
                continue;
            }
            if (ch < '\u0080' || !Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        string.setOffset(length);
        return string;
    }

    @Override
    public InputStream toInputStream() {
        try {
            return this.toInputStream(Env.getInstance().getRuntimeEncoding().toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public InputStream toInputStream(String charset) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.toString().getBytes(charset));
    }

    public Reader toReader(String charset) throws UnsupportedEncodingException {
        byte[] bytes = this.toBytes();
        return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset);
    }

    public StringValue toBinaryValue(Env env, String charset) {
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            InputStream in = this.toInputStream(charset);
            TempStream out = new TempStream();
            int sublen = in.read(buffer, 0, buffer.length);
            while (sublen >= 0) {
                out.write(buffer, 0, sublen, false);
                sublen = in.read(buffer, 0, buffer.length);
            }
            out.flush();
            StringValue result = env.createBinaryBuilder();
            for (TempBuffer ptr = out.getHead(); ptr != null; ptr = ptr.getNext()) {
                result.append(ptr.getBuffer(), 0, ptr.getLength());
            }
            TempBuffer.free((TempBuffer)out.getHead());
            StringValue stringValue = result;
            return stringValue;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
    }

    public byte[] toBytes() {
        throw new UnsupportedOperationException();
    }

    public StringValue toUnicodeValue(Env env, String charset) {
        StringValue sb = env.createUnicodeBuilder();
        TempCharBuffer tb = TempCharBuffer.allocate();
        char[] charBuf = tb.getBuffer();
        try {
            int sublen;
            Reader in = this.toReader(charset);
            while ((sublen = in.read(charBuf, 0, charBuf.length)) >= 0) {
                sb.append(charBuf, 0, sublen);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        finally {
            TempCharBuffer.free((TempCharBuffer)tb);
        }
        return sb;
    }

    public StringValue convertToUnicode(Env env, String charset) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        TempCharBuffer tb = TempCharBuffer.allocate();
        char[] charBuf = tb.getBuffer();
        try {
            int sublen;
            Reader in = this.toReader(charset);
            while ((sublen = in.read(charBuf, 0, charBuf.length)) >= 0) {
                sb.append(charBuf, 0, sublen);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        finally {
            TempCharBuffer.free((TempCharBuffer)tb);
        }
        return sb;
    }

    public StringValue createStringBuilder() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue createStringBuilder(int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return this.createStringBuilder().append(this);
    }

    public int hashCode() {
        int hash = 37;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + this.charAt(i);
        }
        return hash;
    }

    public boolean equals(Object o) {
        int bLength;
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue s = (StringValue)o;
        if (s.isUnicode() != this.isUnicode()) {
            return false;
        }
        int aLength = this.length();
        if (aLength != (bLength = s.length())) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract String toDebugString();

    @Override
    public abstract void varDumpImpl(Env var1, WriteStream var2, int var3, IdentityHashMap<Value, String> var4) throws IOException;

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            StringValue.CHAR_STRINGS[i] = new StringBuilderValue(String.valueOf((char)i));
        }
    }

    class StringValueInputStream
    extends InputStream {
        private final int _length;
        private int _index;

        StringValueInputStream() {
            this._length = StringValue.this.length();
        }

        public int read() {
            if (this._index < this._length) {
                return StringValue.this.charAt(this._index++);
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            int index = this._index;
            for (int i = 0; i < sublen; ++i) {
                buffer[offset + i] = (byte)StringValue.this.charAt(index + i);
            }
            this._index += sublen;
            return sublen;
        }
    }
}

