/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StreamImplInputStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.InputStream;
import java.io.Serializable;

public class TempBufferBytesValue
extends BytesValue
implements Serializable {
    private TempBuffer _head;
    private String _string;

    public TempBufferBytesValue(TempBuffer buffer) {
        this._head = buffer;
    }

    public StringValue createEmptyStringBuilder() {
        return new BinaryBuilderValue();
    }

    public StringValue getEmptyString() {
        return BinaryBuilderValue.EMPTY;
    }

    public InputStream toInputStream() {
        TempReadStream ts = new TempReadStream(this._head);
        ts.setFreeWhenDone(false);
        return new StreamImplInputStream((StreamImpl)ts);
    }

    public int length() {
        int len = 0;
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            len += ptr.getLength();
        }
        return len;
    }

    public char charAt(int index) {
        int len = 0;
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            int sublen = ptr.getLength();
            if (index < len + sublen) {
                return (char)(ptr.getBuffer()[index - len] & 0xFF);
            }
            len += sublen;
        }
        return '\u0000';
    }

    public void print(Env env) {
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            env.write(ptr.getBuffer(), 0, ptr.getLength());
        }
    }

    public String toString() {
        if (this._string == null) {
            char[] cbuf = new char[this.length()];
            int i = 0;
            for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
                byte[] buf = ptr.getBuffer();
                int len = ptr.getLength();
                for (int j = 0; j < len; ++j) {
                    cbuf[i++] = (char)(buf[j] & 0xFF);
                }
            }
            this._string = new String(cbuf);
        }
        return this._string;
    }

    public int hashCode() {
        int hash = 37;
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            byte[] buffer = ptr.getBuffer();
            int length = ptr.getLength();
            for (int i = 0; i < length; ++i) {
                hash = 65521 * hash + (buffer[i] & 0xFF);
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TempBufferBytesValue) {
            TempBuffer ptrB;
            TempBufferBytesValue tb = (TempBufferBytesValue)o;
            TempBuffer ptrA = this._head;
            for (ptrB = tb._head; ptrA != null && ptrB != null; ptrA = ptrA.getNext(), ptrB = ptrB.getNext()) {
                byte[] bufferA = ptrA.getBuffer();
                int lengthA = ptrA.getLength();
                byte[] bufferB = ptrB.getBuffer();
                int lengthB = ptrB.getLength();
                if (lengthA != lengthB) {
                    return false;
                }
                while (--lengthA >= 0) {
                    if (bufferA[lengthA] == bufferB[lengthA]) continue;
                    return false;
                }
            }
            return ptrA == null && ptrB == null;
        }
        return super.equals(o);
    }

    public byte[] toBytes() {
        int len = 0;
        byte[] buffer = new byte[this.length()];
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            System.arraycopy(ptr.getBuffer(), 0, buffer, len, ptr.getLength());
            len += ptr.getLength();
        }
        return buffer;
    }

    public Object writeReplace() {
        return new BinaryBuilderValue(this.toBytes());
    }
}

