/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BinaryBuilderStream;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeBuilderValue
extends StringBuilderValue {
    public static final UnicodeBuilderValue EMPTY = new UnicodeBuilderValue("");
    private static final UnicodeBuilderValue[] CHAR_STRINGS = new UnicodeBuilderValue[256];

    public UnicodeBuilderValue() {
    }

    public UnicodeBuilderValue(int capacity) {
        super(capacity);
    }

    public UnicodeBuilderValue(String value) {
        super(value);
    }

    public UnicodeBuilderValue(String value, int minLength) {
        super(value);
    }

    public UnicodeBuilderValue(char[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    private UnicodeBuilderValue(char[] buffer, int offset, int length, String copy) {
        super(buffer, offset, length);
    }

    public UnicodeBuilderValue(char[] buffer) {
        super(buffer, 0, buffer.length);
    }

    public UnicodeBuilderValue(char[] buffer, int length) {
        super(buffer, 0, length);
    }

    public UnicodeBuilderValue(char[] buffer, int offset, int length, boolean isExact) {
        super(buffer, offset, length);
    }

    public UnicodeBuilderValue(Character[] buffer) {
        super(buffer);
    }

    public UnicodeBuilderValue(char ch) {
        super(ch);
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new UnicodeBuilderValue(value);
    }

    @Override
    public StringValue create(Env env, StringValue str, String charset) {
        return str;
    }

    @Override
    public StringValue createEmptyStringBuilder() {
        return new UnicodeBuilderValue();
    }

    @Override
    public StringValue getEmptyString() {
        return EMPTY;
    }

    @Override
    public StringValue convertToUnicode(Env env, String charset) {
        return this;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return UnicodeBuilderValue.getValueType(this._buffer, 0, this._length);
    }

    @Override
    public StringValue intern(Quercus quercus) {
        return quercus.intern(this.toString());
    }

    @Override
    public StringValue toStringBuilder() {
        return new UnicodeBuilderValue(this._buffer, 0, this._length);
    }

    @Override
    public StringValue toUnicodeValue() {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        return this;
    }

    @Override
    public StringValue toUnicodeValue(Env env, String charset) {
        return this;
    }

    @Override
    public StringValue append(Env env, StringValue unicodeStr, String charset) {
        return this.append(unicodeStr);
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        sb.append(this._buffer, 0, this._length);
        return sb;
    }

    @Override
    public StringValue toBinaryValue() {
        return this.toBinaryValue(Env.getInstance());
    }

    @Override
    public StringValue toBinaryValue(Env env) {
        return this.toBinaryValue(env, env.getRuntimeEncoding().toString());
    }

    @Override
    public StringValue toBinaryValue(Env env, String charset) {
        try {
            BinaryBuilderValue result = new BinaryBuilderValue();
            BinaryBuilderStream stream = new BinaryBuilderStream(result);
            WriteStream out = new WriteStream((StreamImpl)stream);
            out.setEncoding(charset);
            out.print(this._buffer, 0, this._length);
            out.close();
            return result;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    @Override
    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        char ch = this._buffer[(int)index];
        if (ch < CHAR_STRINGS.length) {
            return CHAR_STRINGS[ch];
        }
        return new UnicodeBuilderValue(ch);
    }

    @Override
    public Value setCharValueAt(long index, String value) {
        if (this._isCopy) {
            this.copyOnWrite();
        }
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return this;
        }
        UnicodeBuilderValue sb = new UnicodeBuilderValue(this._buffer, 0, (int)index);
        sb.append(value);
        sb.append(this._buffer, (int)(index + 1L), (int)((long)len - index - 1L));
        return sb;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return EMPTY;
        }
        char[] newBuffer = new char[end - start];
        System.arraycopy(this._buffer, start, newBuffer, 0, end - start);
        return new UnicodeBuilderValue(newBuffer, 0, end - start);
    }

    @Override
    public StringValue toLowerCase() {
        int length = this._length;
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'A' <= ch && ch <= 'Z' ? (char)(ch + 97 - 65) : (ch < '\u0080' ? ch : (Character.isUpperCase(ch) ? Character.toLowerCase(ch) : ch));
        }
        string._length = length;
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this._length;
        UnicodeBuilderValue string = new UnicodeBuilderValue(this._length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'a' <= ch && ch <= 'z' ? (char)(ch + 65 - 97) : (ch < '\u0080' ? ch : (Character.isLowerCase(ch) ? Character.toUpperCase(ch) : ch));
        }
        string._length = length;
        return string;
    }

    @Override
    public char[] toCharArray() {
        char[] dest = new char[this._length];
        System.arraycopy(this._buffer, 0, dest, 0, this._length);
        return dest;
    }

    @Override
    public char[] getRawCharArray() {
        return this._buffer;
    }

    @Override
    public char[] getBuffer() {
        return this._buffer;
    }

    @Override
    public void print(Env env) {
        env.print(this._buffer, 0, this._length);
    }

    @Override
    public void serialize(StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this._buffer, 0, this._length);
        sb.append("\";");
    }

    @Override
    public StringValue createStringBuilder() {
        return new UnicodeBuilderValue();
    }

    @Override
    public StringValue createStringBuilder(int length) {
        return new UnicodeBuilderValue(length);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return new UnicodeBuilderValue(this._buffer, 0, this._length);
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("unicode(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        out.print("unicode(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            out.print(this.charAt(i));
        }
        out.print("\"");
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        out.print("new UnicodeBuilderValue(\"");
        this.printJavaString(out, this);
        out.print("\")");
    }

    private void copyOnWrite() {
        if (this._isCopy) {
            this._isCopy = false;
            char[] buffer = new char[this._buffer.length];
            System.arraycopy(this._buffer, 0, buffer, 0, this._length);
            this._buffer = buffer;
        }
    }

    public static int getNumericType(char[] buffer, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int i = offset;
        char ch = '\u0000';
        boolean hasPoint = false;
        if (i < len && ((ch = buffer[i]) == '+' || ch == '-')) {
            ++i;
        }
        if (len <= i) {
            return 0;
        }
        ch = buffer[i];
        if (ch == '.') {
            if (++i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                return 2;
            }
            return 0;
        }
        if ('0' > ch || ch > '9') {
            return 0;
        }
        while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
            ++i;
        }
        if (len <= i) {
            return 1;
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            ++i;
            while (i < len && ('0' <= (ch = buffer[i]) && ch <= '9' || ch == '+' || ch == '-' || ch == 'e' || ch == 'E')) {
                ++i;
            }
            if (i < len) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public static ValueType getValueType(char[] buffer, int offset, int len) {
        if (len == 0) {
            return ValueType.LONG_ADD;
        }
        int i = offset;
        char ch = '\u0000';
        boolean hasPoint = false;
        if (i < len && ((ch = buffer[i]) == '+' || ch == '-')) {
            ++i;
        }
        if (len <= i) {
            return ValueType.STRING;
        }
        ch = buffer[i];
        if (ch == '.') {
            if (++i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                return ValueType.DOUBLE_CMP;
            }
            return ValueType.STRING;
        }
        if ('0' > ch || ch > '9') {
            return ValueType.STRING;
        }
        while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
            ++i;
        }
        if (len <= i) {
            return ValueType.LONG_EQ;
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            ++i;
            while (i < len && ('0' <= (ch = buffer[i]) && ch <= '9' || ch == '+' || ch == '-' || ch == 'e' || ch == 'E')) {
                ++i;
            }
            if (i < len) {
                return ValueType.STRING;
            }
            return ValueType.DOUBLE_CMP;
        }
        return ValueType.STRING;
    }

    public static long toLong(char[] buffer, int offset, int len) {
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean i = false;
        int end = offset + len;
        if (buffer[offset] == '-') {
            sign = -1L;
            ++offset;
        } else if (buffer[offset] == '+') {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            char ch;
            if ('0' <= (ch = buffer[offset++]) && ch <= '9') {
                value = 10L * value + (long)ch - 48L;
                continue;
            }
            return sign * value;
        }
        return sign * value;
    }

    public static double toDouble(char[] buffer, int offset, int len) {
        int i = offset;
        char ch = '\u0000';
        if (i < len && ((ch = buffer[i]) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                ++i;
            }
            if (i == 1) {
                return 0.0;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = buffer[i]) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(new String(buffer, 0, i));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            UnicodeBuilderValue.CHAR_STRINGS[i] = new UnicodeBuilderValue((char)i);
        }
    }
}

